/*
 * Decompiled with CFR 0.152.
 */
package com.xeli.createmetalogistics.util;

import com.simibubi.create.AllDataComponents;
import com.simibubi.create.content.equipment.clipboard.ClipboardContent;
import com.simibubi.create.content.equipment.clipboard.ClipboardEntry;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0007"}, d2={"requestedItemsFromClipboard", "", "Lcom/simibubi/create/content/logistics/BigItemStack;", "clipboard", "Lnet/minecraft/world/item/ItemStack;", "clearRequestedItemsFromClipboard", "", "createmetalogistics-1.21.1"})
public final class RequestedItemsFromClipboardKt {
    @NotNull
    public static final List<BigItemStack> requestedItemsFromClipboard(@NotNull ItemStack clipboard) {
        Intrinsics.checkNotNullParameter((Object)clipboard, (String)"clipboard");
        ClipboardContent clipboardContent = (ClipboardContent)clipboard.get(AllDataComponents.CLIPBOARD_CONTENT);
        if (clipboardContent == null) {
            return CollectionsKt.emptyList();
        }
        ClipboardContent pages = clipboardContent;
        InventorySummary items = new InventorySummary();
        for (List page : pages.pages()) {
            for (ClipboardEntry entry : page) {
                if (entry.icon.isEmpty() || entry.checked) continue;
                items.add(new BigItemStack(entry.icon, entry.itemAmount));
            }
        }
        List list = items.getStacksByCount();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStacksByCount(...)");
        return list;
    }

    public static final void clearRequestedItemsFromClipboard(@NotNull ItemStack clipboard) {
        Intrinsics.checkNotNullParameter((Object)clipboard, (String)"clipboard");
        ClipboardContent clipboardContent = (ClipboardContent)clipboard.get(AllDataComponents.CLIPBOARD_CONTENT);
        if (clipboardContent == null) {
            return;
        }
        ClipboardContent pages = clipboardContent;
        for (List page : pages.pages()) {
            for (ClipboardEntry entry : page) {
                if (entry.icon.isEmpty() || entry.checked) continue;
                entry.checked = true;
            }
        }
        clipboard.set(AllDataComponents.CLIPBOARD_CONTENT, (Object)pages);
    }
}

