/*
 * Decompiled with CFR 0.152.
 */
package com.xeli.createmetalogistics.datagen;

import com.google.common.collect.ImmutableList;
import com.xeli.createmetalogistics.ModBlocks;
import com.xeli.createmetalogistics.content.compiler.CompilerExpansionModuleBlock;
import com.xeli.createmetalogistics.content.filterrequester.FilterRequesterBlock;
import com.xeli.createmetalogistics.item.ModItems;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ\n\u0010\u000e\u001a\u00020\u000f*\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0002J \u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0002J \u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\tH\u0002J(\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\tH\u0002JG\u0010\u001d\u001a\u00020\u0012*\u00020\u00122\u001a\u0010\u001e\u001a\u0016\u0012\u0004\u0012\u00020 \u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\"0!0\u001f2\u001a\u0010#\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030$0!\"\u0006\u0012\u0002\b\u00030$\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020'H\u0014\u00a8\u0006("}, d2={"Lcom/xeli/createmetalogistics/datagen/ModBlockStateProvider;", "Lnet/neoforged/neoforge/client/model/generators/BlockStateProvider;", "output", "Lnet/minecraft/data/PackOutput;", "fileHelper", "Lnet/neoforged/neoforge/common/data/ExistingFileHelper;", "<init>", "(Lnet/minecraft/data/PackOutput;Lnet/neoforged/neoforge/common/data/ExistingFileHelper;)V", "blockResourceLocation", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "name", "", "(Ljava/lang/String;)Lnet/minecraft/resources/ResourceLocation;", "rotation", "", "Lnet/minecraft/core/Direction;", "createRotatableBlock", "Lnet/neoforged/neoforge/client/model/generators/VariantBlockStateBuilder;", "block", "Lnet/minecraft/world/level/block/Block;", "model", "createStaticRotatableBlock", "createCompilerBlock", "modelOff", "modelOn", "createRequesterBlock", "createExpansionModuleBlock", "modelFull", "forProperties", "mapper", "Ljava/util/function/Function;", "Lnet/minecraft/world/level/block/state/BlockState;", "", "Lnet/neoforged/neoforge/client/model/generators/ConfiguredModel;", "properties", "Lnet/minecraft/world/level/block/state/properties/Property;", "(Lnet/neoforged/neoforge/client/model/generators/VariantBlockStateBuilder;Ljava/util/function/Function;[Lnet/minecraft/world/level/block/state/properties/Property;)Lnet/neoforged/neoforge/client/model/generators/VariantBlockStateBuilder;", "registerStatesAndModels", "", "createmetalogistics-1.21.1"})
@SourceDebugExtension(value={"SMAP\nModBlockStateProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModBlockStateProvider.kt\ncom/xeli/createmetalogistics/datagen/ModBlockStateProvider\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,222:1\n37#2:223\n36#2,3:224\n230#3,2:227\n*S KotlinDebug\n*F\n+ 1 ModBlockStateProvider.kt\ncom/xeli/createmetalogistics/datagen/ModBlockStateProvider\n*L\n173#1:223\n173#1:224,3\n121#1:227,2\n*E\n"})
public final class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(@NotNull PackOutput output, @NotNull ExistingFileHelper fileHelper) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)fileHelper, (String)"fileHelper");
        super(output, "createmetalogistics", fileHelper);
    }

    private final ResourceLocation blockResourceLocation(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"createmetalogistics", (String)name);
    }

    public final int rotation(@NotNull Direction $this$rotation) {
        Intrinsics.checkNotNullParameter((Object)$this$rotation, (String)"<this>");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$rotation.ordinal()]) {
            case 1 -> throw new IllegalArgumentException();
            case 2 -> throw new IllegalArgumentException();
            case 3 -> 0;
            case 4 -> 90;
            case 5 -> 180;
            case 6 -> 270;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final VariantBlockStateBuilder createRotatableBlock(Block block, ResourceLocation model) {
        VariantBlockStateBuilder variantBlockStateBuilder = this.getVariantBuilder(block);
        Intrinsics.checkNotNullExpressionValue((Object)variantBlockStateBuilder, (String)"getVariantBuilder(...)");
        Property[] propertyArray = new Property[]{DirectionalBlock.FACING};
        return this.forProperties(variantBlockStateBuilder, arg_0 -> ModBlockStateProvider.createRotatableBlock$propertyHandler(this, model, arg_0), propertyArray);
    }

    private final VariantBlockStateBuilder createStaticRotatableBlock(Block block, ResourceLocation model) {
        VariantBlockStateBuilder variantBlockStateBuilder = this.getVariantBuilder(block);
        Intrinsics.checkNotNullExpressionValue((Object)variantBlockStateBuilder, (String)"getVariantBuilder(...)");
        Property[] propertyArray = new Property[]{DirectionalBlock.FACING};
        return this.forProperties(variantBlockStateBuilder, arg_0 -> ModBlockStateProvider.createStaticRotatableBlock$propertyHandler$0(this, model, arg_0), propertyArray);
    }

    private final VariantBlockStateBuilder createCompilerBlock(Block block, ResourceLocation modelOff, ResourceLocation modelOn) {
        VariantBlockStateBuilder variantBlockStateBuilder = this.getVariantBuilder(block);
        Intrinsics.checkNotNullExpressionValue((Object)variantBlockStateBuilder, (String)"getVariantBuilder(...)");
        Property[] propertyArray = new Property[]{DirectionalBlock.FACING, BlockStateProperties.POWERED};
        return this.forProperties(variantBlockStateBuilder, arg_0 -> ModBlockStateProvider.createCompilerBlock$propertyHandler$1(this, modelOn, modelOff, arg_0), propertyArray);
    }

    private final VariantBlockStateBuilder createRequesterBlock(Block block, ResourceLocation modelOff, ResourceLocation modelOn) {
        VariantBlockStateBuilder variantBlockStateBuilder = this.getVariantBuilder(block);
        Intrinsics.checkNotNullExpressionValue((Object)variantBlockStateBuilder, (String)"getVariantBuilder(...)");
        Property[] propertyArray = new Property[]{FilterRequesterBlock.Companion.getAXIS(), BlockStateProperties.POWERED};
        return this.forProperties(variantBlockStateBuilder, arg_0 -> ModBlockStateProvider.createRequesterBlock$propertyHandler$3(this, modelOn, modelOff, arg_0), propertyArray);
    }

    private final VariantBlockStateBuilder createExpansionModuleBlock(Block block, ResourceLocation modelOff, ResourceLocation modelOn, ResourceLocation modelFull) {
        VariantBlockStateBuilder variantBlockStateBuilder = this.getVariantBuilder(block);
        Intrinsics.checkNotNullExpressionValue((Object)variantBlockStateBuilder, (String)"getVariantBuilder(...)");
        Property[] propertyArray = new Property[]{DirectionalBlock.FACING, CompilerExpansionModuleBlock.Companion.getPOWERED()};
        return this.forProperties(variantBlockStateBuilder, arg_0 -> ModBlockStateProvider.createExpansionModuleBlock$propertyHandler$4(modelFull, modelOn, modelOff, this, arg_0), propertyArray);
    }

    @NotNull
    public final VariantBlockStateBuilder forProperties(@NotNull VariantBlockStateBuilder $this$forProperties, @NotNull Function<BlockState, ConfiguredModel[]> mapper, Property<?> ... properties) {
        Intrinsics.checkNotNullParameter((Object)$this$forProperties, (String)"<this>");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        ImmutableList immutableList = $this$forProperties.getOwner().getStateDefinition().getPossibleStates();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"getPossibleStates(...)");
        Collection allProperties = ((BlockState)CollectionsKt.first((List)((List)immutableList))).getProperties();
        Intrinsics.checkNotNull((Object)allProperties);
        List propertiesToExclude = CollectionsKt.minus((Iterable)allProperties, (Object[])properties);
        Collection $this$toTypedArray$iv = propertiesToExclude;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Property[] propertyArray = thisCollection$iv.toArray(new Property[0]);
        VariantBlockStateBuilder variantBlockStateBuilder = $this$forProperties.forAllStatesExcept(mapper, Arrays.copyOf(propertyArray, propertyArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)variantBlockStateBuilder, (String)"forAllStatesExcept(...)");
        return variantBlockStateBuilder;
    }

    protected void registerStatesAndModels() {
        Object object = ModBlocks.INSTANCE.getStockManifestReaderBlock().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Block block = (Block)object;
        ResourceLocation resourceLocation = this.blockResourceLocation("block/stock_manifest_reader");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"blockResourceLocation(...)");
        this.createRotatableBlock(block, resourceLocation);
        this.itemModels().simpleBlockItem((Block)ModBlocks.INSTANCE.getStockManifestReaderBlock().get());
        Object object2 = ModBlocks.INSTANCE.getStockManifestCompilerBlock().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        Block block2 = (Block)object2;
        ResourceLocation resourceLocation2 = this.blockResourceLocation("block/stock_manifest_compiler");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"blockResourceLocation(...)");
        ResourceLocation resourceLocation3 = this.blockResourceLocation("block/stock_manifest_compiler_active");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation3, (String)"blockResourceLocation(...)");
        this.createCompilerBlock(block2, resourceLocation2, resourceLocation3);
        this.itemModels().simpleBlockItem((Block)ModBlocks.INSTANCE.getStockManifestCompilerBlock().get());
        this.simpleBlock((Block)ModBlocks.INSTANCE.getStationChunkLoaderBlock().get(), (ModelFile)this.models().getExistingFile(ModBlocks.INSTANCE.getStationChunkLoaderBlock().getId()));
        this.itemModels().simpleBlockItem((Block)ModBlocks.INSTANCE.getStationChunkLoaderBlock().get());
        Object object3 = ModBlocks.INSTANCE.getCompilerExpansionModuleBlock().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        Block block3 = (Block)object3;
        ResourceLocation resourceLocation4 = this.blockResourceLocation("block/expansion_module_full");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation4, (String)"blockResourceLocation(...)");
        ResourceLocation resourceLocation5 = resourceLocation4;
        ResourceLocation resourceLocation6 = this.blockResourceLocation("block/expansion_module_on");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation6, (String)"blockResourceLocation(...)");
        ResourceLocation resourceLocation7 = resourceLocation6;
        ResourceLocation resourceLocation8 = this.blockResourceLocation("block/expansion_module");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation8, (String)"blockResourceLocation(...)");
        ResourceLocation resourceLocation9 = resourceLocation8;
        this.createExpansionModuleBlock(block3, resourceLocation9, resourceLocation7, resourceLocation5);
        this.itemModels().simpleBlockItem((Block)ModBlocks.INSTANCE.getCompilerExpansionModuleBlock().get());
        Object object4 = ModBlocks.INSTANCE.getTicketCrateBlock().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        Block block4 = (Block)object4;
        ResourceLocation resourceLocation10 = this.blockResourceLocation("block/ticket_crate");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation10, (String)"blockResourceLocation(...)");
        this.createStaticRotatableBlock(block4, resourceLocation10);
        this.itemModels().withExistingParent(ModItems.INSTANCE.getTicketCrateBlockItem().getId().toString(), this.modLoc("block/ticket_crate"));
        Object object5 = ModBlocks.INSTANCE.getFilterRequesterBlock().get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
        Block block5 = (Block)object5;
        ResourceLocation resourceLocation11 = this.blockResourceLocation("block/filter_requester");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation11, (String)"blockResourceLocation(...)");
        ResourceLocation resourceLocation12 = this.blockResourceLocation("block/filter_requester_powered");
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation12, (String)"blockResourceLocation(...)");
        this.createRequesterBlock(block5, resourceLocation11, resourceLocation12);
        this.itemModels().simpleBlockItem((Block)ModBlocks.INSTANCE.getFilterRequesterBlock().get());
    }

    private static final ConfiguredModel[] createRotatableBlock$propertyHandler(ModBlockStateProvider this$0, ResourceLocation $model, BlockState blockState) {
        Direction facing = (Direction)blockState.getValue((Property)DirectionalBlock.FACING);
        ModelFile.ExistingModelFile modelFile = this$0.models().getExistingFile($model);
        ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)modelFile);
        if (facing.getAxis() != Direction.Axis.Y) {
            Intrinsics.checkNotNull((Object)facing);
            builder.rotationY(this$0.rotation(facing));
        } else if (facing == Direction.UP) {
            builder.rotationX(270);
        } else if (facing == Direction.DOWN) {
            builder.rotationX(90);
        }
        ConfiguredModel[] configuredModelArray = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)configuredModelArray, (String)"build(...)");
        return configuredModelArray;
    }

    private static final ConfiguredModel[] createStaticRotatableBlock$propertyHandler$0(ModBlockStateProvider this$0, ResourceLocation $model, BlockState blockState) {
        ModelFile.ExistingModelFile modelFile = this$0.models().getExistingFile($model);
        ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)modelFile);
        ConfiguredModel[] configuredModelArray = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)configuredModelArray, (String)"build(...)");
        return configuredModelArray;
    }

    private static final ConfiguredModel[] createCompilerBlock$propertyHandler$1(ModBlockStateProvider this$0, ResourceLocation $modelOn, ResourceLocation $modelOff, BlockState blockState) {
        Direction facing = (Direction)blockState.getValue((Property)DirectionalBlock.FACING);
        ModelFile.ExistingModelFile modelFile = (Boolean)blockState.getValue((Property)BlockStateProperties.POWERED) != false ? this$0.models().getExistingFile($modelOn) : this$0.models().getExistingFile($modelOff);
        ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)modelFile);
        if (facing.getAxis() != Direction.Axis.Y) {
            Intrinsics.checkNotNull((Object)facing);
            builder.rotationY(this$0.rotation(facing));
        } else if (facing == Direction.UP) {
            builder.rotationX(270);
        } else if (facing == Direction.DOWN) {
            builder.rotationX(90);
        }
        ConfiguredModel[] configuredModelArray = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)configuredModelArray, (String)"build(...)");
        return configuredModelArray;
    }

    /*
     * WARNING - void declaration
     */
    private static final ConfiguredModel[] createRequesterBlock$propertyHandler$3(ModBlockStateProvider this$0, ResourceLocation $modelOn, ResourceLocation $modelOff, BlockState blockState) {
        Object element$iv2;
        ConfiguredModel.Builder builder;
        ModBlockStateProvider modBlockStateProvider;
        block1: {
            void $this$first$iv;
            Direction.Axis facing = (Direction.Axis)blockState.getValue((Property)FilterRequesterBlock.Companion.getAXIS());
            ModelFile.ExistingModelFile modelFile = (Boolean)blockState.getValue((Property)BlockStateProperties.POWERED) != false ? this$0.models().getExistingFile($modelOn) : this$0.models().getExistingFile($modelOff);
            Iterable iterable = (Iterable)EntriesMappings.entries$0;
            modBlockStateProvider = this$0;
            builder = ConfiguredModel.builder().modelFile((ModelFile)modelFile);
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                Direction it = (Direction)element$iv2;
                boolean bl = false;
                if (!(it.getAxis() == facing)) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        ConfiguredModel.Builder builder2 = builder.rotationX(modBlockStateProvider.rotation((Direction)t));
        ConfiguredModel[] configuredModelArray = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)configuredModelArray, (String)"build(...)");
        return configuredModelArray;
    }

    private static final ConfiguredModel[] createExpansionModuleBlock$propertyHandler$4(ResourceLocation $modelFull, ResourceLocation $modelOn, ResourceLocation $modelOff, ModBlockStateProvider this$0, BlockState blockState) {
        Direction facing = (Direction)blockState.getValue((Property)DirectionalBlock.FACING);
        CompilerExpansionModuleBlock.PoweredState poweredState = (CompilerExpansionModuleBlock.PoweredState)((Object)blockState.getValue((Property)CompilerExpansionModuleBlock.Companion.getPOWERED()));
        ResourceLocation location = switch (poweredState == null ? -1 : WhenMappings.$EnumSwitchMapping$1[poweredState.ordinal()]) {
            case 1 -> $modelFull;
            case 2 -> $modelOn;
            case 3 -> $modelOff;
            case -1 -> throw new NullPointerException();
            default -> throw new NoWhenBranchMatchedException();
        };
        ModelFile.ExistingModelFile modelFile = this$0.models().getExistingFile(location);
        ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)modelFile);
        if (facing.getAxis() != Direction.Axis.Y) {
            Intrinsics.checkNotNull((Object)facing);
            builder.rotationY(this$0.rotation(facing));
        } else if (facing == Direction.UP) {
            builder.rotationX(270);
        } else if (facing == Direction.DOWN) {
            builder.rotationX(90);
        }
        ConfiguredModel[] configuredModelArray = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)configuredModelArray, (String)"build(...)");
        return configuredModelArray;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.DOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.NORTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CompilerExpansionModuleBlock.PoweredState.values().length];
            try {
                nArray[CompilerExpansionModuleBlock.PoweredState.FULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerExpansionModuleBlock.PoweredState.ON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerExpansionModuleBlock.PoweredState.OFF.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

