/*
 * Decompiled with CFR 0.152.
 */
package com.xeli.createmetalogistics.content.ticketcrate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.xeli.createmetalogistics.component.ModDataComponents;
import com.xeli.createmetalogistics.component.TicketData;
import com.xeli.createmetalogistics.content.ticketcrate.PartialTicketItemEntry;
import com.xeli.createmetalogistics.item.ModItems;
import com.xeli.createmetalogistics.util.BehaviourOwnerKt;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0006J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/xeli/createmetalogistics/content/ticketcrate/PartialTicketItemEntry;", "", "item", "Lcom/simibubi/create/content/logistics/BigItemStack;", "packageAddress", "Ljava/util/Optional;", "", "<init>", "(Lcom/simibubi/create/content/logistics/BigItemStack;Ljava/util/Optional;)V", "getItem", "()Lcom/simibubi/create/content/logistics/BigItemStack;", "getPackageAddress", "()Ljava/util/Optional;", "toTicketItemWithNetwork", "Lnet/minecraft/world/item/ItemStack;", "networkBehaviour", "Lcom/simibubi/create/content/logistics/packagerLink/LogisticallyLinkedBehaviour;", "defaultAddress", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "createmetalogistics-1.21.1"})
public final class PartialTicketItemEntry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigItemStack item;
    @NotNull
    private final Optional<String> packageAddress;
    @NotNull
    private static final Codec<PartialTicketItemEntry> CODEC;
    @NotNull
    private static final StreamCodec<RegistryFriendlyByteBuf, PartialTicketItemEntry> STREAM_CODEC;

    public PartialTicketItemEntry(@NotNull BigItemStack item, @NotNull Optional<String> packageAddress) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter(packageAddress, (String)"packageAddress");
        this.item = item;
        this.packageAddress = packageAddress;
    }

    public /* synthetic */ PartialTicketItemEntry(BigItemStack bigItemStack, Optional optional, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            optional = Optional.empty();
        }
        this(bigItemStack, optional);
    }

    @NotNull
    public final BigItemStack getItem() {
        return this.item;
    }

    @NotNull
    public final Optional<String> getPackageAddress() {
        return this.packageAddress;
    }

    @NotNull
    public final ItemStack toTicketItemWithNetwork(@NotNull LogisticallyLinkedBehaviour networkBehaviour, @NotNull String defaultAddress) {
        Intrinsics.checkNotNullParameter((Object)networkBehaviour, (String)"networkBehaviour");
        Intrinsics.checkNotNullParameter((Object)defaultAddress, (String)"defaultAddress");
        Optional<UUID> owner = BehaviourOwnerKt.getOwnerOptional(networkBehaviour);
        List list = CollectionsKt.listOf((Object)this.item);
        String string = this.packageAddress.orElse(defaultAddress);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"orElse(...)");
        Optional<UUID> optional = Optional.empty();
        Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
        TicketData ticket = new TicketData(list, string, optional, owner);
        ItemStack itemStack = new ItemStack((ItemLike)ModItems.INSTANCE.getTicketItem().get());
        itemStack.set((Supplier)ModDataComponents.INSTANCE.getTICKET(), (Object)ticket);
        return itemStack;
    }

    public static /* synthetic */ ItemStack toTicketItemWithNetwork$default(PartialTicketItemEntry partialTicketItemEntry, LogisticallyLinkedBehaviour logisticallyLinkedBehaviour, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return partialTicketItemEntry.toTicketItemWithNetwork(logisticallyLinkedBehaviour, string);
    }

    @NotNull
    public final BigItemStack component1() {
        return this.item;
    }

    @NotNull
    public final Optional<String> component2() {
        return this.packageAddress;
    }

    @NotNull
    public final PartialTicketItemEntry copy(@NotNull BigItemStack item, @NotNull Optional<String> packageAddress) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter(packageAddress, (String)"packageAddress");
        return new PartialTicketItemEntry(item, packageAddress);
    }

    public static /* synthetic */ PartialTicketItemEntry copy$default(PartialTicketItemEntry partialTicketItemEntry, BigItemStack bigItemStack, Optional optional, int n, Object object) {
        if ((n & 1) != 0) {
            bigItemStack = partialTicketItemEntry.item;
        }
        if ((n & 2) != 0) {
            optional = partialTicketItemEntry.packageAddress;
        }
        return partialTicketItemEntry.copy(bigItemStack, optional);
    }

    @NotNull
    public String toString() {
        return "PartialTicketItemEntry(item=" + this.item + ", packageAddress=" + this.packageAddress + ")";
    }

    public int hashCode() {
        int result = this.item.hashCode();
        result = result * 31 + this.packageAddress.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PartialTicketItemEntry)) {
            return false;
        }
        PartialTicketItemEntry partialTicketItemEntry = (PartialTicketItemEntry)other;
        if (!Intrinsics.areEqual((Object)this.item, (Object)partialTicketItemEntry.item)) {
            return false;
        }
        return Intrinsics.areEqual(this.packageAddress, partialTicketItemEntry.packageAddress);
    }

    private static final BigItemStack CODEC$lambda$2$lambda$0(KProperty1 $tmp0, PartialTicketItemEntry p0) {
        return (BigItemStack)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional CODEC$lambda$2$lambda$1(KProperty1 $tmp0, PartialTicketItemEntry p0) {
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final App CODEC$lambda$2(RecordCodecBuilder.Instance instance) {
        return instance.group((App)BigItemStack.CODEC.fieldOf("item").forGetter(arg_0 -> PartialTicketItemEntry.CODEC$lambda$2$lambda$0((KProperty1)Companion.CODEC.1.1.INSTANCE, arg_0)), (App)Codec.STRING.optionalFieldOf("packageAddress").forGetter(arg_0 -> PartialTicketItemEntry.CODEC$lambda$2$lambda$1((KProperty1)Companion.CODEC.1.2.INSTANCE, arg_0))).apply((Applicative)instance, PartialTicketItemEntry::new);
    }

    private static final BigItemStack STREAM_CODEC$lambda$3(KProperty1 $tmp0, PartialTicketItemEntry p0) {
        return (BigItemStack)((Function1)$tmp0).invoke((Object)p0);
    }

    private static final Optional STREAM_CODEC$lambda$4(KProperty1 $tmp0, PartialTicketItemEntry p0) {
        return (Optional)((Function1)$tmp0).invoke((Object)p0);
    }

    static {
        Codec codec = RecordCodecBuilder.create(PartialTicketItemEntry::CODEC$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"create(...)");
        CODEC = codec;
        StreamCodec streamCodec = StreamCodec.composite((StreamCodec)BigItemStack.STREAM_CODEC, arg_0 -> PartialTicketItemEntry.STREAM_CODEC$lambda$3((KProperty1)Companion.STREAM_CODEC.1.INSTANCE, arg_0), (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), arg_0 -> PartialTicketItemEntry.STREAM_CODEC$lambda$4((KProperty1)Companion.STREAM_CODEC.2.INSTANCE, arg_0), PartialTicketItemEntry::new);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"composite(...)");
        STREAM_CODEC = streamCodec;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/xeli/createmetalogistics/content/ticketcrate/PartialTicketItemEntry$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Lcom/xeli/createmetalogistics/content/ticketcrate/PartialTicketItemEntry;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/RegistryFriendlyByteBuf;", "getSTREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "createmetalogistics-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Codec<PartialTicketItemEntry> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final StreamCodec<RegistryFriendlyByteBuf, PartialTicketItemEntry> getSTREAM_CODEC() {
            return STREAM_CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

