/*
 * Decompiled with CFR 0.152.
 */
package com.xeli.createmetalogistics.content.compiler;

import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.xeli.createmetalogistics.component.TicketData;
import com.xeli.createmetalogistics.content.compiler.SecurityPolicy;
import com.xeli.createmetalogistics.content.compiler.StockManifestCompilerBlockEntity;
import com.xeli.createmetalogistics.util.BehaviourOwnerKt;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.reflect.KProperty1;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0016B\u001d\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u0017"}, d2={"Lcom/xeli/createmetalogistics/content/compiler/SecurityPolicy;", "", "requiresOwner", "", "requiresOrigin", "<init>", "(Ljava/lang/String;IZZ)V", "getRequiresOwner", "()Z", "getRequiresOrigin", "ANY", "SAME_OWNER", "SAME_ORIGIN", "SAME_OWNER_SAME_ORIGIN", "canTicketMakeRequest", "compiler", "Lcom/xeli/createmetalogistics/content/compiler/StockManifestCompilerBlockEntity;", "ticketData", "Lcom/xeli/createmetalogistics/component/TicketData;", "getDescription", "Lnet/minecraft/network/chat/Component;", "getName", "Companion", "createmetalogistics-1.21.1"})
@SourceDebugExtension(value={"SMAP\nSecurityPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SecurityPolicy.kt\ncom/xeli/createmetalogistics/content/compiler/SecurityPolicy\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,60:1\n37#2,2:61\n*S KotlinDebug\n*F\n+ 1 SecurityPolicy.kt\ncom/xeli/createmetalogistics/content/compiler/SecurityPolicy\n*L\n52#1:61,2\n*E\n"})
public final class SecurityPolicy
extends Enum<SecurityPolicy> {
    @NotNull
    public static final Companion Companion;
    private final boolean requiresOwner;
    private final boolean requiresOrigin;
    @NotNull
    private static final SecurityPolicy default;
    @NotNull
    private static final IntFunction<SecurityPolicy> BY_ID;
    @NotNull
    private static final StreamCodec<ByteBuf, SecurityPolicy> ID_STREAM_CODEC;
    public static final /* enum */ SecurityPolicy ANY;
    public static final /* enum */ SecurityPolicy SAME_OWNER;
    public static final /* enum */ SecurityPolicy SAME_ORIGIN;
    public static final /* enum */ SecurityPolicy SAME_OWNER_SAME_ORIGIN;
    private static final /* synthetic */ SecurityPolicy[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private SecurityPolicy(boolean requiresOwner, boolean requiresOrigin) {
        this.requiresOwner = requiresOwner;
        this.requiresOrigin = requiresOrigin;
    }

    /* synthetic */ SecurityPolicy(String string, int n, boolean bl, boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        this(bl, bl2);
    }

    public final boolean getRequiresOwner() {
        return this.requiresOwner;
    }

    public final boolean getRequiresOrigin() {
        return this.requiresOrigin;
    }

    public final boolean canTicketMakeRequest(@NotNull StockManifestCompilerBlockEntity compiler, @NotNull TicketData ticketData) {
        UUID originFrequencyId;
        Intrinsics.checkNotNullParameter((Object)((Object)compiler), (String)"compiler");
        Intrinsics.checkNotNullParameter((Object)ticketData, (String)"ticketData");
        if (this.requiresOwner) {
            LogisticallyLinkedBehaviour logisticallyLinkedBehaviour = compiler.behaviour;
            Intrinsics.checkNotNullExpressionValue((Object)logisticallyLinkedBehaviour, (String)"behaviour");
            Optional<UUID> owner = BehaviourOwnerKt.getOwnerOptional(logisticallyLinkedBehaviour);
            if (owner.isPresent() && !Intrinsics.areEqual(owner, ticketData.getRequestNetworkOwnerId())) {
                return false;
            }
        }
        return !this.requiresOrigin || Intrinsics.areEqual((Object)(originFrequencyId = compiler.behaviour.freqId), (Object)OptionalsKt.getOrNull(ticketData.getOriginNetworkId()));
    }

    @NotNull
    public Component getDescription() {
        String string = this.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        MutableComponent mutableComponent = Component.translatable((String)("menu.createmetalogistics.stock_manifest_compiler." + string + ".description"));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    @NotNull
    public Component getName() {
        String string = this.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        MutableComponent mutableComponent = Component.translatable((String)("menu.createmetalogistics.stock_manifest_compiler." + string));
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    public static SecurityPolicy[] values() {
        return (SecurityPolicy[])$VALUES.clone();
    }

    public static SecurityPolicy valueOf(String value) {
        return Enum.valueOf(SecurityPolicy.class, value);
    }

    @NotNull
    public static EnumEntries<SecurityPolicy> getEntries() {
        return $ENTRIES;
    }

    private static final int BY_ID$lambda$0(KProperty1 $tmp0, SecurityPolicy p0) {
        return ((Number)((Function1)$tmp0).invoke((Object)p0)).intValue();
    }

    private static final int ID_STREAM_CODEC$lambda$1(KProperty1 $tmp0, SecurityPolicy p0) {
        return ((Number)((Function1)$tmp0).invoke((Object)p0)).intValue();
    }

    static {
        ANY = new SecurityPolicy("ANY", 0, false, false, 3, null);
        SAME_OWNER = new SecurityPolicy("SAME_OWNER", 1, true, false, 2, null);
        SAME_ORIGIN = new SecurityPolicy("SAME_ORIGIN", 2, false, true, 1, null);
        SAME_OWNER_SAME_ORIGIN = new SecurityPolicy(true, true);
        $VALUES = securityPolicyArray = new SecurityPolicy[]{SecurityPolicy.ANY, SecurityPolicy.SAME_OWNER, SecurityPolicy.SAME_ORIGIN, SecurityPolicy.SAME_OWNER_SAME_ORIGIN};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        default = SAME_ORIGIN;
        Collection $this$toTypedArray$iv = (Collection)SecurityPolicy.getEntries();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        IntFunction intFunction = ByIdMap.continuous(arg_0 -> SecurityPolicy.BY_ID$lambda$0((KProperty1)Companion.BY_ID.1.INSTANCE, arg_0), (Object[])thisCollection$iv.toArray(new SecurityPolicy[0]), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        Intrinsics.checkNotNullExpressionValue((Object)intFunction, (String)"continuous(...)");
        BY_ID = intFunction;
        StreamCodec streamCodec = ByteBufCodecs.idMapper(BY_ID, arg_0 -> SecurityPolicy.ID_STREAM_CODEC$lambda$1((KProperty1)Companion.ID_STREAM_CODEC.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"idMapper(...)");
        ID_STREAM_CODEC = streamCodec;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00050\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/xeli/createmetalogistics/content/compiler/SecurityPolicy$Companion;", "", "<init>", "()V", "default", "Lcom/xeli/createmetalogistics/content/compiler/SecurityPolicy;", "getDefault", "()Lcom/xeli/createmetalogistics/content/compiler/SecurityPolicy;", "BY_ID", "Ljava/util/function/IntFunction;", "getBY_ID", "()Ljava/util/function/IntFunction;", "ID_STREAM_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lio/netty/buffer/ByteBuf;", "getID_STREAM_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "createmetalogistics-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SecurityPolicy getDefault() {
            return default;
        }

        @NotNull
        public final IntFunction<SecurityPolicy> getBY_ID() {
            return BY_ID;
        }

        @NotNull
        public final StreamCodec<ByteBuf, SecurityPolicy> getID_STREAM_CODEC() {
            return ID_STREAM_CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

