/*
 * Decompiled with CFR 0.152.
 */
package com.xeli.createmetalogistics.content.compiler;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.stockTicker.PackageOrderWithCrafts;
import com.simibubi.create.content.logistics.stockTicker.StockCheckingBlockEntity;
import com.xeli.createmetalogistics.ModBlockEntities;
import com.xeli.createmetalogistics.MyConfig;
import com.xeli.createmetalogistics.component.ManifestData;
import com.xeli.createmetalogistics.component.ModDataComponents;
import com.xeli.createmetalogistics.component.TicketData;
import com.xeli.createmetalogistics.content.compiler.AcceptancePolicy;
import com.xeli.createmetalogistics.content.compiler.CompilerExpansionModuleBlockEntity;
import com.xeli.createmetalogistics.content.compiler.SecurityPolicy;
import com.xeli.createmetalogistics.content.compiler.distribution.CompilerSnapshotReceiver;
import com.xeli.createmetalogistics.content.compiler.distribution.ModuleSnapshotReceiver;
import com.xeli.createmetalogistics.content.compiler.distribution.SnapshotReceiver;
import com.xeli.createmetalogistics.item.ManifestItem;
import com.xeli.createmetalogistics.item.ModItems;
import com.xeli.createmetalogistics.screen.custom.CompilerMenu;
import com.xeli.createmetalogistics.util.BehaviourOwnerKt;
import com.xeli.createmetalogistics.util.EncoderContext;
import com.xeli.createmetalogistics.util.TicketDataFilterHasInNetworkKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import ru.zznty.create_factory_abstractions.generic.support.GenericLogisticsManager;
import ru.zznty.create_factory_abstractions.generic.support.GenericOrder;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 H2\u00020\u00012\u00020\u0002:\u0002HIB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014J \u0010(\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0014J\b\u0010)\u001a\u00020!H\u0016J\b\u0010*\u001a\u00020!H\u0016J\u0006\u0010+\u001a\u00020!J \u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u000203H\u0016J\u0016\u00104\u001a\u00020!2\u0006\u00100\u001a\u0002012\u0006\u00105\u001a\u00020\u0015J\u0016\u00104\u001a\u00020!2\u0006\u00100\u001a\u0002012\u0006\u00105\u001a\u00020\u001bJ\u0006\u00106\u001a\u00020\u0013J\f\u00107\u001a\b\u0012\u0004\u0012\u00020908J\u0014\u0010:\u001a\u00020'2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020<08J\u000e\u0010=\u001a\u00020!2\u0006\u0010>\u001a\u00020?J0\u0010@\u001a\u00020A\"\u0004\b\u0000\u0010B*\u00020A2\u001c\u0010C\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030E\u0012\n\u0012\b\u0012\u0004\u0012\u0002HB0E0DH\u0002J\u0010\u0010F\u001a\u00020<2\u0006\u0010G\u001a\u00020<H\u0002R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006J"}, d2={"Lcom/xeli/createmetalogistics/content/compiler/StockManifestCompilerBlockEntity;", "Lcom/simibubi/create/content/logistics/stockTicker/StockCheckingBlockEntity;", "Lnet/minecraft/world/MenuProvider;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "inventory", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "getInventory", "()Lnet/neoforged/neoforge/items/ItemStackHandler;", "value", "", "connectedModules", "getConnectedModules", "()Ljava/util/List;", "cooldown", "", "securityPolicy", "Lcom/xeli/createmetalogistics/content/compiler/SecurityPolicy;", "getSecurityPolicy", "()Lcom/xeli/createmetalogistics/content/compiler/SecurityPolicy;", "setSecurityPolicy", "(Lcom/xeli/createmetalogistics/content/compiler/SecurityPolicy;)V", "acceptancePolicy", "Lcom/xeli/createmetalogistics/content/compiler/AcceptancePolicy;", "getAcceptancePolicy", "()Lcom/xeli/createmetalogistics/content/compiler/AcceptancePolicy;", "setAcceptancePolicy", "(Lcom/xeli/createmetalogistics/content/compiler/AcceptancePolicy;)V", "read", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "clientPacket", "", "write", "tick", "invalidate", "drops", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "i", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "playerTryMakeEdit", "policy", "maxEntries", "validExpansionModules", "", "Lcom/xeli/createmetalogistics/content/compiler/CompilerExpansionModuleBlockEntity;", "generateManifest", "summary", "Lcom/simibubi/create/content/logistics/BigItemStack;", "makeRequest", "ticketData", "Lcom/xeli/createmetalogistics/component/TicketData;", "eraseComponent", "Lnet/minecraft/world/item/ItemStack;", "T", "holder", "Lnet/neoforged/neoforge/registries/DeferredHolder;", "Lnet/minecraft/core/component/DataComponentType;", "removeMetadata", "stack", "Companion", "Inventory", "createmetalogistics-1.21.1"})
@SourceDebugExtension(value={"SMAP\nStockManifestCompilerBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StockManifestCompilerBlockEntity.kt\ncom/xeli/createmetalogistics/content/compiler/StockManifestCompilerBlockEntity\n+ 2 EncoderContext.kt\ncom/xeli/createmetalogistics/util/EncoderContext$Companion\n+ 3 EncoderContext.kt\ncom/xeli/createmetalogistics/util/EncoderContext\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,399:1\n34#2:400\n34#2:407\n31#3:401\n20#3,5:402\n31#3:408\n1611#4,9:409\n1863#4:418\n1864#4:420\n1620#4:421\n1557#4:422\n1628#4,3:423\n1#5:419\n*S KotlinDebug\n*F\n+ 1 StockManifestCompilerBlockEntity.kt\ncom/xeli/createmetalogistics/content/compiler/StockManifestCompilerBlockEntity\n*L\n73#1:400\n89#1:407\n73#1:401\n77#1:402,5\n89#1:408\n182#1:409,9\n182#1:418\n182#1:420\n182#1:421\n198#1:422\n198#1:423,3\n182#1:419\n*E\n"})
public final class StockManifestCompilerBlockEntity
extends StockCheckingBlockEntity
implements MenuProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ItemStackHandler inventory;
    @NotNull
    private List<BlockPos> connectedModules;
    private int cooldown;
    @NotNull
    private SecurityPolicy securityPolicy;
    @NotNull
    private AcceptancePolicy acceptancePolicy;

    public StockManifestCompilerBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super((BlockEntityType)ModBlockEntities.INSTANCE.getStockManifestCompilerBlockEntityType().get(), pos, state);
        this.inventory = new Inventory();
        this.connectedModules = new ArrayList();
        this.securityPolicy = SecurityPolicy.Companion.getDefault();
        this.acceptancePolicy = AcceptancePolicy.Companion.getDefault();
    }

    @NotNull
    public final ItemStackHandler getInventory() {
        return this.inventory;
    }

    @NotNull
    public final List<BlockPos> getConnectedModules() {
        return this.connectedModules;
    }

    @NotNull
    public final SecurityPolicy getSecurityPolicy() {
        return this.securityPolicy;
    }

    public final void setSecurityPolicy(@NotNull SecurityPolicy securityPolicy) {
        Intrinsics.checkNotNullParameter((Object)((Object)securityPolicy), (String)"<set-?>");
        this.securityPolicy = securityPolicy;
    }

    @NotNull
    public final AcceptancePolicy getAcceptancePolicy() {
        return this.acceptancePolicy;
    }

    public final void setAcceptancePolicy(@NotNull AcceptancePolicy acceptancePolicy) {
        Intrinsics.checkNotNullParameter((Object)((Object)acceptancePolicy), (String)"<set-?>");
        this.acceptancePolicy = acceptancePolicy;
    }

    /*
     * WARNING - void declaration
     */
    protected void read(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries, boolean clientPacket) {
        void $this$runIfPresent$iv;
        void arg0$iv;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.read(tag, registries, clientPacket);
        EncoderContext.Companion companion = EncoderContext.Companion;
        HolderLookup.Provider $this$nbtCtx$iv = registries;
        boolean bl = false;
        RegistryOps registryOps = $this$nbtCtx$iv.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)registryOps, (String)"createSerializationContext(...)");
        RegistryOps<Tag> this_$iv = EncoderContext.constructor-impl((RegistryOps<Tag>)registryOps);
        boolean bl2 = false;
        void $this$read_u24lambda_u241 = arg0$iv;
        boolean bl3 = false;
        this.setSecurityPolicy((SecurityPolicy)((Object)SecurityPolicy.getEntries().get(tag.getInt("SecurityPolicy"))));
        this.setAcceptancePolicy((AcceptancePolicy)((Object)AcceptancePolicy.getEntries().get(tag.getInt("AcceptancePolicy"))));
        this.cooldown = tag.getInt("cooldown");
        Tag tag2 = tag.get("connectedModules");
        Codec codec = BlockPos.CODEC.listOf();
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"listOf(...)");
        Codec codec$iv = codec;
        boolean bl4 = false;
        Optional result$iv = codec$iv.decode((DynamicOps)$this$read_u24lambda_u241, (Object)$this$runIfPresent$iv).result();
        if (result$iv.isPresent()) {
            List it = (List)((com.mojang.datafixers.util.Pair)result$iv.get()).getFirst();
            boolean bl5 = false;
            Intrinsics.checkNotNull((Object)it);
            this.connectedModules = CollectionsKt.toMutableList((Collection)it);
        }
        this.getInventory().deserializeNBT(registries, tag.getCompound("inventory"));
    }

    /*
     * WARNING - void declaration
     */
    protected void write(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries, boolean clientPacket) {
        void arg0$iv;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.write(tag, registries, clientPacket);
        EncoderContext.Companion companion = EncoderContext.Companion;
        HolderLookup.Provider $this$nbtCtx$iv = registries;
        boolean bl = false;
        RegistryOps registryOps = $this$nbtCtx$iv.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)registryOps, (String)"createSerializationContext(...)");
        RegistryOps<Tag> this_$iv = EncoderContext.constructor-impl((RegistryOps<Tag>)registryOps);
        boolean bl2 = false;
        void $this$write_u24lambda_u242 = arg0$iv;
        boolean bl3 = false;
        tag.putInt("SecurityPolicy", this.getSecurityPolicy().ordinal());
        tag.putInt("AcceptancePolicy", this.getAcceptancePolicy().ordinal());
        tag.putInt("cooldown", this.cooldown);
        Codec codec = BlockPos.CODEC.listOf();
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"listOf(...)");
        EncoderContext.store-impl((RegistryOps<Tag>)$this$write_u24lambda_u242, tag, "connectedModules", codec, this.getConnectedModules());
        tag.put("inventory", (Tag)this.getInventory().serializeNBT(registries));
    }

    public void tick() {
        super.tick();
        if (this.cooldown <= 0) {
            return;
        }
        if (this.cooldown % 80 > 10 && this.cooldown % 80 <= 30) {
            Level level = this.level;
            if (level != null) {
                BlockPos blockPos = this.getBlockPos();
                SoundEvent soundEvent = SoundEvent.createFixedRangeEvent((ResourceLocation)AllSoundEvents.SCROLL_VALUE.getId(), (float)12.0f);
                Level level2 = this.level;
                Intrinsics.checkNotNull((Object)level2);
                level.playSound(null, blockPos, soundEvent, SoundSource.BLOCKS, 0.2f, level2.random.nextFloat() * 1.0f + 0.5f);
            }
            Level level3 = this.level;
            if (level3 != null) {
                BlockPos blockPos = this.getBlockPos();
                SoundEvent soundEvent = SoundEvent.createFixedRangeEvent((ResourceLocation)SoundEvents.CALCITE_HIT.getLocation(), (float)12.0f);
                Level level4 = this.level;
                Intrinsics.checkNotNull((Object)level4);
                level3.playSound(null, blockPos, soundEvent, SoundSource.BLOCKS, 0.15f, level4.random.nextFloat() * 1.95f);
            }
        }
        if (this.cooldown == 1) {
            Level level = this.level;
            if (level != null) {
                level.playSound(null, this.getBlockPos(), SoundEvent.createFixedRangeEvent((ResourceLocation)AllSoundEvents.DESK_BELL_USE.getId(), (float)8.0f), SoundSource.BLOCKS, 0.6f, 1.0f);
            }
        }
        int n = this.cooldown;
        this.cooldown = n + -1;
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    public final void drops() {
        SimpleContainer inv = new SimpleContainer(this.inventory.getSlots());
        int n = this.inventory.getSlots();
        for (int i = 0; i < n; ++i) {
            inv.setItem(i, this.inventory.getStackInSlot(i));
        }
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        Containers.dropContents((Level)level, (BlockPos)this.worldPosition, (Container)((Container)inv));
    }

    @NotNull
    public AbstractContainerMenu createMenu(int i, @NotNull net.minecraft.world.entity.player.Inventory inventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return new CompilerMenu(i, inventory, (BlockEntity)this, this.securityPolicy, this.acceptancePolicy, this.validExpansionModules().size());
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = Component.translatable((String)"container.createmetalogistics.stock_manifest_compiler");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    public final void playerTryMakeEdit(@NotNull Player player, @NotNull SecurityPolicy policy) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        if (player.canInteractWithBlock(this.getBlockPos(), 4.0)) {
            if (this.behaviour.mayAdministrate(player)) {
                this.securityPolicy = policy;
                this.setChanged();
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"message.createmetalogistics.stock_manifest_compiler.access_denied"), false);
            }
        }
    }

    public final void playerTryMakeEdit(@NotNull Player player, @NotNull AcceptancePolicy policy) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)((Object)policy), (String)"policy");
        if (player.canInteractWithBlock(this.getBlockPos(), 4.0)) {
            if (this.behaviour.mayAdministrate(player)) {
                this.acceptancePolicy = policy;
                this.setChanged();
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"message.createmetalogistics.stock_manifest_compiler.access_denied"), false);
            }
        }
    }

    public final int maxEntries() {
        return MyConfig.INSTANCE.getManifestMaxBytes();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<CompilerExpansionModuleBlockEntity> validExpansionModules() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.connectedModules;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            CompilerExpansionModuleBlockEntity it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            BlockPos pos = (BlockPos)element$iv$iv;
            boolean bl2 = false;
            Level level = this.level;
            Object object = level != null ? level.getBlockEntity(pos) : null;
            if ((object instanceof CompilerExpansionModuleBlockEntity ? (CompilerExpansionModuleBlockEntity)((Object)object) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean generateManifest(@NotNull List<? extends BigItemStack> summary) {
        Intrinsics.checkNotNullParameter(summary, (String)"summary");
        if (this.cooldown > 0 || this.cooldown == -1) {
            return false;
        }
        this.cooldown = -1;
        List<CompilerExpansionModuleBlockEntity> expansionModules = this.validExpansionModules();
        Runnable task = () -> StockManifestCompilerBlockEntity.generateManifest$lambda$6(summary, this, expansionModules);
        Util.backgroundExecutor().submit(task);
        return true;
    }

    public final void makeRequest(@NotNull TicketData ticketData) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)ticketData, (String)"ticketData");
            if (!this.securityPolicy.canTicketMakeRequest(this, ticketData)) {
                Level level = this.level;
                if (level != null) {
                    level.playSound(null, this.getBlockPos(), AllSoundEvents.DENY.getMainEvent(), SoundSource.BLOCKS, 0.5f, 1.0f);
                }
                return;
            }
            Level level = this.level;
            boolean bl = level != null ? !level.isClientSide : false;
            if (bl) {
                PackageOrderWithCrafts order = PackageOrderWithCrafts.simple(ticketData.getList());
                GenericLogisticsManager.broadcastPackageRequest((UUID)this.behaviour.freqId, (LogisticallyLinkedBehaviour.RequestType)LogisticallyLinkedBehaviour.RequestType.REDSTONE, (GenericOrder)GenericOrder.of((PackageOrderWithCrafts)order), null, (String)ticketData.getPackageAddress());
            }
            Level level2 = this.level;
            if (level2 == null) break block3;
            level2.playSound(null, this.getBlockPos(), AllSoundEvents.STOCK_LINK.getMainEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private final <T> ItemStack eraseComponent(ItemStack $this$eraseComponent, DeferredHolder<DataComponentType<?>, DataComponentType<T>> holder) {
        ItemStack itemStack;
        ItemStack it = itemStack = $this$eraseComponent.copy();
        boolean bl = false;
        it.set((Supplier)holder, null);
        ItemStack itemStack2 = itemStack;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"also(...)");
        return itemStack2;
    }

    private final BigItemStack removeMetadata(BigItemStack stack) {
        BigItemStack bigItemStack;
        if (stack.stack.get((Supplier)ModDataComponents.INSTANCE.getTICKET()) != null) {
            ItemStack itemStack = stack.stack;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"stack");
            bigItemStack = new BigItemStack(this.eraseComponent(itemStack, ModDataComponents.INSTANCE.getTICKET()), stack.count);
        } else if (stack.stack.get((Supplier)ModDataComponents.INSTANCE.getMANIFEST()) != null) {
            ItemStack itemStack = stack.stack;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"stack");
            bigItemStack = new BigItemStack(this.eraseComponent(itemStack, ModDataComponents.INSTANCE.getMANIFEST()), stack.count);
        } else {
            bigItemStack = stack;
        }
        return bigItemStack;
    }

    private static final int generateManifest$lambda$6$lambda$4(StockManifestCompilerBlockEntity this$0, BigItemStack stack) {
        ItemStack itemStack = stack.stack;
        Level level = this$0.level;
        Intrinsics.checkNotNull((Object)level);
        Tag itemEncoding = itemStack.save((HolderLookup.Provider)level.registryAccess());
        Intrinsics.checkNotNull((Object)itemEncoding);
        return (int)ManifestItem.Companion.nbtSize(itemEncoding);
    }

    /*
     * WARNING - void declaration
     */
    private static final void generateManifest$lambda$6(List $summary, StockManifestCompilerBlockEntity this$0, List $expansionModules) {
        void $this$mapTo$iv$iv;
        Function1 sizeOfFun = arg_0 -> StockManifestCompilerBlockEntity.generateManifest$lambda$6$lambda$4(this$0, arg_0);
        Iterable $this$map$iv = $summary;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            BigItemStack bigItemStack = (BigItemStack)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0.removeMetadata((BigItemStack)p0));
        }
        List summaryToSend = (List)destination$iv$iv;
        List $this$generateManifest_u24lambda_u246_u24lambda_u245 = $i$f$map = CollectionsKt.createListBuilder();
        boolean bl = false;
        int n = this$0.maxEntries();
        UUID uUID = this$0.behaviour.freqId;
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"freqId");
        LogisticallyLinkedBehaviour logisticallyLinkedBehaviour = this$0.behaviour;
        Intrinsics.checkNotNullExpressionValue((Object)logisticallyLinkedBehaviour, (String)"behaviour");
        $this$generateManifest_u24lambda_u246_u24lambda_u245.add(new CompilerSnapshotReceiver(this$0, (Function1<? super BigItemStack, Integer>)sizeOfFun, n, uUID, BehaviourOwnerKt.getOwnerOptional(logisticallyLinkedBehaviour)));
        for (CompilerExpansionModuleBlockEntity module : $expansionModules) {
            int n2 = module.maxEntries();
            UUID uUID2 = this$0.behaviour.freqId;
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"freqId");
            LogisticallyLinkedBehaviour logisticallyLinkedBehaviour2 = this$0.behaviour;
            Intrinsics.checkNotNullExpressionValue((Object)logisticallyLinkedBehaviour2, (String)"behaviour");
            $this$generateManifest_u24lambda_u246_u24lambda_u245.add(new ModuleSnapshotReceiver(module, (Function1<? super BigItemStack, Integer>)sizeOfFun, n2, uUID2, BehaviourOwnerKt.getOwnerOptional(logisticallyLinkedBehaviour2)));
        }
        List receivers = CollectionsKt.build((List)$i$f$map);
        List receivedSnapshots = SnapshotReceiver.Companion.distributeToAllReceivers(receivers, summaryToSend);
        List remainingSnapshotReceivers = CollectionsKt.minus((Iterable)receivers, (Iterable)receivedSnapshots);
        for (SnapshotReceiver receiver : remainingSnapshotReceivers) {
            if (!(receiver instanceof ModuleSnapshotReceiver)) continue;
            ((ModuleSnapshotReceiver)receiver).generateBlankManifest(new ManifestData(CollectionsKt.emptyList(), summaryToSend.size(), null, null, null, null, 60, null));
        }
        this$0.cooldown = Companion.getBaseCooldown() + (int)((double)receivedSnapshots.size() * CompilerExpansionModuleBlockEntity.Companion.getCooldownModifier());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/xeli/createmetalogistics/content/compiler/StockManifestCompilerBlockEntity$Companion;", "", "<init>", "()V", "registerCapabilities", "", "event", "Lnet/neoforged/neoforge/capabilities/RegisterCapabilitiesEvent;", "baseCooldown", "", "getBaseCooldown", "()I", "createmetalogistics-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerCapabilities(@NotNull RegisterCapabilitiesEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)ModBlockEntities.INSTANCE.getStockManifestCompilerBlockEntityType().get(), (arg_0, arg_1) -> Companion.registerCapabilities$lambda$1(Companion::registerCapabilities$lambda$0, arg_0, arg_1));
        }

        public final int getBaseCooldown() {
            return MyConfig.INSTANCE.getCompilerCooldown();
        }

        private static final IItemHandler registerCapabilities$lambda$0(StockManifestCompilerBlockEntity be, Direction d) {
            return (IItemHandler)be.getInventory();
        }

        private static final IItemHandler registerCapabilities$lambda$1(Function2 $tmp0, Object p0, Direction p1) {
            return (IItemHandler)$tmp0.invoke(p0, (Object)p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0016J \u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\u0011"}, d2={"Lcom/xeli/createmetalogistics/content/compiler/StockManifestCompilerBlockEntity$Inventory;", "Lnet/neoforged/neoforge/items/ItemStackHandler;", "<init>", "(Lcom/xeli/createmetalogistics/content/compiler/StockManifestCompilerBlockEntity;)V", "extractItem", "Lnet/minecraft/world/item/ItemStack;", "slot", "", "amount", "simulate", "", "isItemValid", "stack", "insertItem", "setStackInSlot", "", "onContentsChanged", "createmetalogistics-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nStockManifestCompilerBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StockManifestCompilerBlockEntity.kt\ncom/xeli/createmetalogistics/content/compiler/StockManifestCompilerBlockEntity$Inventory\n+ 2 AcceptancePolicy.kt\ncom/xeli/createmetalogistics/content/compiler/AcceptancePolicy\n*L\n1#1,399:1\n29#2,25:400\n*S KotlinDebug\n*F\n+ 1 StockManifestCompilerBlockEntity.kt\ncom/xeli/createmetalogistics/content/compiler/StockManifestCompilerBlockEntity$Inventory\n*L\n357#1:400,25\n*E\n"})
    private final class Inventory
    extends ItemStackHandler {
        public Inventory() {
            super(2);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack itemStack;
            ItemStack it = itemStack = super.extractItem(slot, amount, simulate);
            boolean bl = false;
            if (!simulate) {
                this.onContentsChanged(slot);
            }
            ItemStack itemStack2 = itemStack;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"also(...)");
            return itemStack2;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            if (slot == 0) {
                return stack.is((Holder)ModItems.INSTANCE.getManifestItem());
            }
            if (!stack.is((Holder)ModItems.INSTANCE.getTicketItem()) || !stack.has((Supplier)ModDataComponents.INSTANCE.getTICKET())) {
                return false;
            }
            Level level = StockManifestCompilerBlockEntity.this.level;
            Intrinsics.checkNotNull((Object)level);
            if (level.isClientSide) {
                return true;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[StockManifestCompilerBlockEntity.this.getAcceptancePolicy().ordinal()]) {
                case 1: {
                    return true;
                }
                case 2: {
                    Object object = stack.get((Supplier)ModDataComponents.INSTANCE.getTICKET());
                    Intrinsics.checkNotNull((Object)object);
                    TicketData data = (TicketData)object;
                    LogisticallyLinkedBehaviour network = StockManifestCompilerBlockEntity.this.behaviour;
                    Intrinsics.checkNotNull((Object)network);
                    List remainder = (List)TicketDataFilterHasInNetworkKt.filterHasInNetwork(data, network).getSecond();
                    return remainder.isEmpty();
                }
                case 3: {
                    return true;
                }
            }
            throw new NoWhenBranchMatchedException();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            ItemStack itemStack;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            if (stack.isEmpty()) {
                ItemStack itemStack2 = ItemStack.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
                return itemStack2;
            }
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            if (slot != 1) {
                return stack;
            }
            if (!this.getStackInSlot(1).isEmpty()) {
                return stack;
            }
            Level level = StockManifestCompilerBlockEntity.this.level;
            Intrinsics.checkNotNull((Object)level);
            if (level.isClientSide) {
                if (!simulate) {
                    this.onContentsChanged(slot);
                }
                ItemStack itemStack3 = stack.copyWithCount(stack.getCount() - 1);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack3, (String)"copyWithCount(...)");
                return itemStack3;
            }
            AcceptancePolicy acceptancePolicy = StockManifestCompilerBlockEntity.this.getAcceptancePolicy();
            LogisticallyLinkedBehaviour logisticallyLinkedBehaviour = StockManifestCompilerBlockEntity.this.behaviour;
            Intrinsics.checkNotNullExpressionValue((Object)logisticallyLinkedBehaviour, (String)"behaviour");
            LogisticallyLinkedBehaviour logisticallyLinkedBehaviour2 = logisticallyLinkedBehaviour;
            StockManifestCompilerBlockEntity stockManifestCompilerBlockEntity = StockManifestCompilerBlockEntity.this;
            boolean $i$f$processTicketWith = false;
            TicketData data$iv = AcceptancePolicy.Companion.getTicketData(stack);
            switch (AcceptancePolicy.WhenMappings.$EnumSwitchMapping$0[this_$iv.ordinal()]) {
                case 1: {
                    TicketData ticketData = data$iv;
                    boolean bl = false;
                    if (!simulate) {
                        stockManifestCompilerBlockEntity.makeRequest(ticketData);
                    }
                    ItemStack itemStack4 = stack.copyWithCount(stack.getCount() - 1);
                    itemStack = itemStack4;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack4, (String)"copyWithCount(...)");
                    break;
                }
                case 2: {
                    void behaviour$iv;
                    List remainder$iv = (List)TicketDataFilterHasInNetworkKt.filterHasInNetwork(data$iv, (LogisticallyLinkedBehaviour)behaviour$iv).getSecond();
                    if (remainder$iv.isEmpty()) {
                        TicketData ticketData = data$iv;
                        boolean bl = false;
                        if (!simulate) {
                            stockManifestCompilerBlockEntity.makeRequest(ticketData);
                        }
                        ItemStack itemStack5 = stack.copyWithCount(stack.getCount() - 1);
                        itemStack = itemStack5;
                        Intrinsics.checkNotNullExpressionValue((Object)itemStack5, (String)"copyWithCount(...)");
                        break;
                    }
                    itemStack = stack;
                    break;
                }
                case 3: {
                    void behaviour$iv;
                    Pair<List<BigItemStack>, List<BigItemStack>> pair = TicketDataFilterHasInNetworkKt.filterHasInNetwork(data$iv, (LogisticallyLinkedBehaviour)behaviour$iv);
                    List itemsHasInNetwork$iv = (List)pair.component1();
                    List remainder$iv = (List)pair.component2();
                    if (remainder$iv.isEmpty()) {
                        TicketData ticketData = data$iv;
                        boolean bl = false;
                        if (!simulate) {
                            stockManifestCompilerBlockEntity.makeRequest(ticketData);
                        }
                        ItemStack itemStack6 = stack.copyWithCount(stack.getCount() - 1);
                        itemStack = itemStack6;
                        Intrinsics.checkNotNullExpressionValue((Object)itemStack6, (String)"copyWithCount(...)");
                        break;
                    }
                    TicketData acceptData$iv = TicketData.copy$default(data$iv, itemsHasInNetwork$iv, null, null, null, 14, null);
                    TicketData remainderData$iv = TicketData.copy$default(data$iv, remainder$iv, null, null, null, 14, null);
                    TicketData ticketData = acceptData$iv;
                    boolean bl = false;
                    if (!simulate) {
                        stockManifestCompilerBlockEntity.makeRequest(ticketData);
                    }
                    ticketData = remainderData$iv;
                    boolean bl2 = false;
                    if (!simulate) {
                        void it;
                        ItemStack itemStack7;
                        ItemStack itemStack8 = itemStack7 = stack.copy();
                        int n = 1;
                        Inventory inventory = this;
                        boolean bl3 = false;
                        it.set((Supplier)ModDataComponents.INSTANCE.getTICKET(), (Object)ticketData);
                        Unit unit = Unit.INSTANCE;
                        Inventory.super.setStackInSlot(n, itemStack7);
                        this.onContentsChanged(slot);
                    }
                    ItemStack itemStack9 = stack.copyWithCount(stack.getCount() - 1);
                    itemStack = itemStack9;
                    Intrinsics.checkNotNullExpressionValue((Object)itemStack9, (String)"copyWithCount(...)");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return itemStack;
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            switch (slot) {
                case 1: {
                    if (!stack.is((Holder)ModItems.INSTANCE.getTicketItem())) break;
                    Object object = stack.get((Supplier)ModDataComponents.INSTANCE.getTICKET());
                    Intrinsics.checkNotNull((Object)object);
                    StockManifestCompilerBlockEntity.this.makeRequest((TicketData)object);
                    break;
                }
                case 0: {
                    super.setStackInSlot(slot, stack);
                }
            }
        }

        protected void onContentsChanged(int slot) {
            StockManifestCompilerBlockEntity.this.setChanged();
            Level level = StockManifestCompilerBlockEntity.this.level;
            Intrinsics.checkNotNull((Object)level);
            if (!level.isClientSide()) {
                Level level2 = StockManifestCompilerBlockEntity.this.level;
                Intrinsics.checkNotNull((Object)level2);
                level2.sendBlockUpdated(StockManifestCompilerBlockEntity.this.getBlockPos(), StockManifestCompilerBlockEntity.this.getBlockState(), StockManifestCompilerBlockEntity.this.getBlockState(), 3);
            }
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[AcceptancePolicy.values().length];
                try {
                    nArray[AcceptancePolicy.ACCEPT_PARTIAL_CONSUME_ALL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AcceptancePolicy.REQUIRE_ALL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[AcceptancePolicy.ACCEPT_PARTIAL_CONSUME_PART.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

