/*
 * Decompiled with CFR 0.152.
 */
package com.xeli.createmetalogistics.mixin;

import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DimensionPalette;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.xeli.createmetalogistics.ChunkLoader;
import com.xeli.createmetalogistics.GlobalStationHasChunkloaders;
import java.util.HashMap;
import java.util.Map;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GlobalStation.class})
public abstract class GlobalStationMixin
implements GlobalStationHasChunkloaders {
    public Map<BlockPos, ChunkLoader.GlobalChunkLoader> connectedLoaders;

    @Override
    public Map<BlockPos, ChunkLoader.GlobalChunkLoader> getConnectedLoaders() {
        return this.connectedLoaders;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void modifyConstructor(CallbackInfo ci) {
        this.connectedLoaders = new HashMap<BlockPos, ChunkLoader.GlobalChunkLoader>();
    }

    @Inject(method={"read"}, at={@At(value="TAIL")})
    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean migration, DimensionPalette dimensions, CallbackInfo CI) {
        ListTag loaderList = nbt.getList("MetaLoaders", 10);
        NBTHelper.iterateCompoundList((ListTag)loaderList, c -> {
            ChunkLoader.GlobalChunkLoader loader = new ChunkLoader.GlobalChunkLoader();
            this.connectedLoaders.put(NBTHelper.readBlockPos((CompoundTag)c, (String)"Pos"), loader);
        });
    }

    @Inject(method={"write"}, at={@At(value="TAIL")})
    public void write(CompoundTag nbt, HolderLookup.Provider registries, DimensionPalette dimensions, CallbackInfo CI) {
        nbt.put("MetaLoaders", (Tag)NBTHelper.writeCompoundList(this.connectedLoaders.entrySet(), e -> {
            CompoundTag c = new CompoundTag();
            c.put("Pos", NbtUtils.writeBlockPos((BlockPos)((BlockPos)e.getKey())));
            return c;
        }));
    }

    @Inject(method={"runMailTransfer"}, at={@At(value="HEAD")})
    public void runMailTransfer(CallbackInfo ci) {
        GlobalStation station = (GlobalStation)this;
        Train train = station.getPresentTrain();
        if (train == null || train.navigation.destination == null) {
            return;
        }
        ServerLevel level = null;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null && ((level = server.getLevel(station.getBlockEntityDimension())) == null || level.isClientSide())) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = level;
            for (Map.Entry<BlockPos, ChunkLoader.GlobalChunkLoader> entry : this.connectedLoaders.entrySet()) {
                BlockPos pos = entry.getKey();
                ChunkLoader.INSTANCE.addServerLevelAndTicket(serverLevel, new ChunkPos(pos), 3, pos);
            }
        }
    }
}

