/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost;

import com.demonwav.mcdev.annotations.Translatable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import dev.isxander.mainmenucredits.MainMenuCredits;
import dev.isxander.mainmenucredits.config.MMCConfig;
import dev.isxander.mainmenucredits.config.MMCConfigEntry;
import io.github.gaming32.worldhost.FriendsListUpdate;
import io.github.gaming32.worldhost.LoadedWorldHostPlugin;
import io.github.gaming32.worldhost.Loader;
import io.github.gaming32.worldhost.WHPlayerSkin;
import io.github.gaming32.worldhost.config.WorldHostConfig;
import io.github.gaming32.worldhost.ext.ServerDataExt;
import io.github.gaming32.worldhost.gui.OnlineStatusLocation;
import io.github.gaming32.worldhost.gui.screen.FriendsScreen;
import io.github.gaming32.worldhost.gui.screen.JoiningWorldHostScreen;
import io.github.gaming32.worldhost.gui.screen.OnlineFriendsScreen;
import io.github.gaming32.worldhost.mixin.MinecraftAccessor;
import io.github.gaming32.worldhost.origincheck.OriginCheckers;
import io.github.gaming32.worldhost.plugin.FriendAdder;
import io.github.gaming32.worldhost.plugin.InfoTextsCategory;
import io.github.gaming32.worldhost.plugin.OnlineFriend;
import io.github.gaming32.worldhost.plugin.ProfileInfo;
import io.github.gaming32.worldhost.plugin.WorldHostPlugin;
import io.github.gaming32.worldhost.plugin.vanilla.GameProfileProfileInfo;
import io.github.gaming32.worldhost.protocol.ProtocolClient;
import io.github.gaming32.worldhost.protocol.proxy.ProxyPassthrough;
import io.github.gaming32.worldhost.protocol.proxy.ProxyProtocolClient;
import io.github.gaming32.worldhost.protocol.punch.PunchManager;
import io.github.gaming32.worldhost.proxy.ProxyClient;
import io.github.gaming32.worldhost.toast.WHToast;
import io.github.gaming32.worldhost.upnp.Gateway;
import io.github.gaming32.worldhost.upnp.GatewayFinder;
import io.github.gaming32.worldhost.upnp.UPnPErrors;
import io.github.gaming32.worldhost.versions.Components;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2540;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2924;
import net.minecraft.class_2926;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_3312;
import net.minecraft.class_412;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_639;
import net.minecraft.class_642;
import org.apache.commons.io.function.IOConsumer;
import org.apache.commons.io.function.IOFunction;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.EnglishReasonPhraseCatalog;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.parsers.json.JsonReader;
import org.quiltmc.parsers.json.JsonWriter;
import org.slf4j.Logger;

public class WorldHost
implements ClientModInitializer {
    public static final String MOD_ID = "world-host";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Loader MOD_LOADER = Loader.FABRIC;
    private static final int[] RECONNECT_DELAYS = new int[]{20, 100, 200, 300, 600, 1200, 1800, 2400, 6000};
    public static final Path GAME_DIR = WorldHost.getGameDir();
    public static final Path CACHE_DIR = GAME_DIR.resolve(".world-host-cache");
    public static final Path CONFIG_DIR = GAME_DIR.resolve("config");
    public static final Path GLOBAL_CONFIG_DIR = WorldHost.locateGlobalConfigDir();
    public static final Path CONFIG_FILE = CONFIG_DIR.resolve("world-host.json5");
    public static final Path OLD_CONFIG_FILE = CONFIG_DIR.resolve("world-host.json");
    public static final Path FRIENDS_FILE = GLOBAL_CONFIG_DIR.resolve("friends.json");
    public static final Path OLD_FRIENDS_FILE = CONFIG_DIR.resolve("world-host-friends.json");
    public static final WorldHostConfig CONFIG = new WorldHostConfig();
    private static List<String> wordsForCid;
    private static Object2IntMap<String> wordsForCidInverse;
    public static final long MAX_CONNECTION_IDS = 0x40000000000L;
    public static final Map<UUID, OnlineFriend> ONLINE_FRIENDS;
    public static final Map<UUID, class_2926> ONLINE_FRIEND_PINGS;
    public static final Set<FriendsListUpdate> ONLINE_FRIEND_UPDATES;
    public static final Long2ObjectMap<ProxyClient> CONNECTED_PROXY_CLIENTS;
    public static final long CONNECTION_ID;
    public static final HttpClient HTTP_CLIENT;
    private static boolean hasScannedForUpnp;
    @Nullable
    public static Gateway upnpGateway;
    private static class_3312 profileCache;
    @Nullable
    public static ProtocolClient protoClient;
    @Nullable
    public static ProxyProtocolClient proxyProtocolClient;
    public static int reconnectDelay;
    private static int delayIndex;
    @Nullable
    private static Future<Void> connectingFuture;
    public static boolean shareWorldOnLoad;
    @Nullable
    public static SocketAddress proxySocketAddress;
    public static boolean clientLoadedFully;
    public static long tickCount;
    private static List<LoadedWorldHostPlugin> plugins;

    public void onInitializeClient() {
        ModContainer container = (ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow();
        WorldHost.init((IOFunction<String, Path>)((IOFunction)path -> (Path)container.findPath(path).orElseThrow(() -> new NoSuchFileException((String)path))), (Path)container.getOrigin().getPaths().getFirst());
    }

    private static void init(IOFunction<String, Path> assetGetter, Path modPath) {
        try (BufferedReader reader = Files.newBufferedReader((Path)assetGetter.apply((Object)"16k.txt"), StandardCharsets.US_ASCII);){
            wordsForCid = reader.lines().filter(s -> !s.startsWith("//")).toList();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (wordsForCid.size() != 16384) {
            throw new RuntimeException("Expected WORDS_FOR_CID to have 16384 elements, but it has " + wordsForCid.size() + " elements.");
        }
        wordsForCidInverse = new Object2IntAVLTreeMap(String.CASE_INSENSITIVE_ORDER);
        wordsForCidInverse.defaultReturnValue(-1);
        for (int i = 0; i < wordsForCid.size(); ++i) {
            wordsForCidInverse.put((Object)wordsForCid.get(i), i);
        }
        LOGGER.info("Using client-generated connection ID {}", (Object)WorldHost.connectionIdToString(CONNECTION_ID));
        WorldHost.loadConfig();
        WorldHost.prepareFileWatcher();
        List<URI> nonstandardOrigins = OriginCheckers.getNonstandardOriginsOnce(OriginCheckers.NATIVE_CHECKER, modPath);
        if (!nonstandardOrigins.isEmpty()) {
            LOGGER.warn("Found nonstandard download origins: {}", nonstandardOrigins);
            WHToast.builder("world-host.nonstandard_origin").description((class_2561)class_2561.method_43469((String)"world-host.nonstandard_origin.desc", (Object[])new Object[]{nonstandardOrigins.stream().map(URI::getHost).distinct().collect(Collectors.joining(", "))})).important().ticks(200).show();
        }
        try {
            Files.createDirectories(CACHE_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create cache directory", (Throwable)e);
        }
        profileCache = new class_3312(((MinecraftAccessor)class_310.method_1551()).getAuthenticationService().createProfileRepository(), CACHE_DIR.resolve("usercache.json").toFile());
        profileCache.method_37157((Executor)class_310.method_1551());
        plugins = ImmutableList.sortedCopyOf(WorldHost.collectPlugins());
        LOGGER.info("Found {} World Host plugin(s): {}", (Object)plugins.size(), (Object)plugins.stream().map(plugin -> plugin.modId() + " (" + String.valueOf(plugin.plugin()) + ")").collect(Collectors.joining(", ")));
        for (LoadedWorldHostPlugin plugin2 : plugins) {
            plugin2.plugin().init();
        }
        if (CONFIG.isUPnP()) {
            WorldHost.scanUpnp();
        }
        Runtime.getRuntime().addShutdownHook(Thread.ofPlatform().name("World Host Shutdown Thread").unstarted(WorldHost::shutdownClients));
        WorldHost.reconnect(false, true);
    }

    private static Path locateGlobalConfigDir() {
        return switch (class_156.method_668()) {
            case class_156.class_158.field_1133 -> Path.of(System.getenv("APPDATA"), "World Host Mod");
            case class_156.class_158.field_1137 -> Path.of(System.getProperty("user.home"), "Library/Application Support/World Host Mod");
            default -> {
                Object configHome = System.getenv("XDG_CONFIG_HOME");
                if (configHome == null) {
                    configHome = System.getProperty("user.home") + "/.config";
                }
                yield Path.of((String)configHome, "world-host-mod");
            }
        };
    }

    public static void loadConfig() {
        WorldHost.loadConfigFile(CONFIG_FILE, (IOFunction<Path, JsonReader>)((IOFunction)JsonReader::json5), OLD_CONFIG_FILE, (IOFunction<Path, JsonReader>)((IOFunction)JsonReader::json), (IOConsumer<JsonReader>)((IOConsumer)CONFIG::read));
        WorldHost.loadFriendsOnly();
        WorldHost.saveConfig();
    }

    private static void loadFriendsOnly() {
        WorldHost.loadConfigFile(FRIENDS_FILE, (IOFunction<Path, JsonReader>)((IOFunction)JsonReader::json), OLD_FRIENDS_FILE, (IOFunction<Path, JsonReader>)((IOFunction)JsonReader::json), (IOConsumer<JsonReader>)((IOConsumer)CONFIG::readFriends));
    }

    @Contract(value="_, _, !null, null, _ -> fail")
    private static void loadConfigFile(Path configFile, IOFunction<Path, JsonReader> configFormat, @Nullable Path oldConfigFile, @Nullable IOFunction<Path, JsonReader> oldConfigFormat, IOConsumer<JsonReader> configReader) {
        block20: {
            try (JsonReader reader = (JsonReader)configFormat.apply((Object)configFile);){
                configReader.accept((Object)reader);
                if (oldConfigFile != null && Files.exists(oldConfigFile, new LinkOption[0])) {
                    LOGGER.info("Old {} still exists. Consider removing it.", (Object)oldConfigFile.getFileName());
                }
            }
            catch (NoSuchFileException e) {
                if (oldConfigFile == null) break block20;
                assert (oldConfigFormat != null);
                LOGGER.info("{} not found. Trying to load old {}.", (Object)configFile.getFileName(), (Object)oldConfigFile.getFileName());
                try (JsonReader reader2 = (JsonReader)oldConfigFormat.apply((Object)oldConfigFile);){
                    configReader.accept((Object)reader2);
                    LOGGER.info("Found and read old {} into new {}. Consider removing the old {}.", new Object[]{oldConfigFile.getFileName(), configFile.getFileName(), oldConfigFile.getFileName()});
                }
                catch (NoSuchFileException e1) {
                    LOGGER.info("Old {} not found. Writing default config.", (Object)oldConfigFile.getFileName());
                }
                catch (IOException e1) {
                    LOGGER.error("Failed to load old {}.", (Object)oldConfigFile.getFileName(), (Object)e1);
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to load {}.", (Object)configFile.getFileName(), (Object)e);
            }
        }
    }

    public static void saveConfig() {
        WorldHost.saveConfigFile(CONFIG_FILE, (IOFunction<Path, JsonWriter>)((IOFunction)JsonWriter::json5), (IOConsumer<JsonWriter>)((IOConsumer)CONFIG::write));
        WorldHost.saveConfigFile(FRIENDS_FILE, (IOFunction<Path, JsonWriter>)((IOFunction)JsonWriter::json), (IOConsumer<JsonWriter>)((IOConsumer)CONFIG::writeFriends));
    }

    private static void saveConfigFile(Path configFile, IOFunction<Path, JsonWriter> configFormat, IOConsumer<JsonWriter> configWriter) {
        try {
            Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
            try (JsonWriter writer = (JsonWriter)configFormat.apply((Object)configFile);){
                configWriter.accept((Object)writer);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to write {}.", (Object)configFile.getFileName(), (Object)e);
        }
    }

    private static void prepareFileWatcher() {
        try {
            WatchService watchService = GLOBAL_CONFIG_DIR.getFileSystem().newWatchService();
            GLOBAL_CONFIG_DIR.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            Thread.ofVirtual().name("WorldHostFileWatcher").start(() -> {
                try {
                    while (class_310.method_1551().method_22108() || !clientLoadedFully) {
                        WatchKey key = watchService.take();
                        for (WatchEvent<?> event : key.pollEvents()) {
                            Path eventPath = GLOBAL_CONFIG_DIR.resolve((Path)event.context());
                            if (!eventPath.equals(FRIENDS_FILE)) continue;
                            LOGGER.info("Friends file modified. Reloading...");
                            class_310.method_1551().execute(() -> {
                                Set<UUID> oldFriends = Set.copyOf(CONFIG.getFriends());
                                WorldHost.loadFriendsOnly();
                                WorldHost.fullFriendsRefresh(oldFriends);
                            });
                        }
                        key.reset();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Exception in file watcher. Stopping.", (Throwable)e);
                }
                try {
                    watchService.close();
                }
                catch (IOException e) {
                    LOGGER.error("Exception closing file watcher", (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            LOGGER.warn("Failed to setup watch service for {}. Friends setup in other instances will not be dynamically refreshed.", (Object)FRIENDS_FILE, (Object)e);
        }
    }

    public static void setFriends(Set<UUID> friends) {
        Set<UUID> oldFriends = Set.copyOf(CONFIG.getFriends());
        CONFIG.getFriends().clear();
        CONFIG.getFriends().addAll(friends);
        WorldHost.fullFriendsRefresh(oldFriends);
    }

    public static void fullFriendsRefresh(Set<UUID> oldFriends) {
        if (!CONFIG.isEnableFriends()) {
            return;
        }
        Set<UUID> friends = CONFIG.getFriends();
        Sets.SetView removedFriends = Sets.difference(oldFriends, friends);
        Sets.SetView newFriends = Sets.difference(oldFriends, friends);
        if (protoClient != null) {
            class_1132 server = class_310.method_1551().method_1576();
            if (server != null && server.method_3860()) {
                if (!removedFriends.isEmpty()) {
                    protoClient.closedWorld((Collection<UUID>)removedFriends);
                }
                if (!newFriends.isEmpty()) {
                    protoClient.publishedWorld((Collection<UUID>)newFriends);
                }
            }
            WorldHost.refreshFriendsList();
            class_437 class_4372 = class_310.method_1551().field_1755;
            if (class_4372 instanceof FriendsScreen) {
                FriendsScreen friendsScreen = (FriendsScreen)class_4372;
                friendsScreen.refresh();
            }
        }
    }

    private static List<LoadedWorldHostPlugin> collectPlugins() {
        return FabricLoader.getInstance().getEntrypointContainers("worldhost", WorldHostPlugin.class).stream().map(container -> new LoadedWorldHostPlugin(container.getProvider().getMetadata().getId(), (WorldHostPlugin)container.getEntrypoint())).toList();
    }

    public static List<LoadedWorldHostPlugin> getPlugins() {
        return plugins;
    }

    public static List<class_2561> getInfoTexts(InfoTextsCategory category) {
        ArrayList<class_2561> result = new ArrayList<class_2561>();
        for (LoadedWorldHostPlugin plugin : plugins) {
            result.addAll(plugin.plugin().getInfoTexts(category));
        }
        return result;
    }

    public static List<FriendAdder> getFriendAdders() {
        return plugins.stream().map(LoadedWorldHostPlugin::plugin).map(WorldHostPlugin::friendAdder).flatMap(Optional::stream).toList();
    }

    public static void friendWentOnline(OnlineFriend friend) {
        ONLINE_FRIENDS.put(friend.uuid(), friend);
        ONLINE_FRIEND_UPDATES.forEach(FriendsListUpdate::friendsListUpdate);
        if (!CONFIG.isAnnounceFriendsOnline()) {
            return;
        }
        if (class_310.method_1551().field_1755 instanceof OnlineFriendsScreen) {
            return;
        }
        WorldHost.showFriendOrOnlineToast(friend.profileInfo(), "world-host.went_online", "world-host.went_online.desc", 200, !friend.joinability().canJoin() ? null : () -> friend.joinWorld(class_310.method_1551().field_1755));
    }

    public static void tickHandler() {
        ++tickCount;
        PunchManager.retransmitAll();
        if (protoClient == null || protoClient.isClosed()) {
            protoClient = null;
            if (proxyProtocolClient != null) {
                proxyProtocolClient.close();
                proxyProtocolClient = null;
            }
            connectingFuture = null;
            if (reconnectDelay == 0) {
                reconnectDelay = delayIndex == RECONNECT_DELAYS.length ? RECONNECT_DELAYS[delayIndex - 1] : RECONNECT_DELAYS[delayIndex++];
            } else if (--reconnectDelay == 0) {
                WorldHost.reconnect(CONFIG.isEnableReconnectionToasts(), false);
            }
        }
        if (proxyProtocolClient != null && proxyProtocolClient.isClosed()) {
            proxyProtocolClient = null;
        }
        if (connectingFuture != null && connectingFuture.isDone()) {
            connectingFuture = null;
            delayIndex = 0;
            WorldHost.refreshFriendsList();
            class_1132 server = class_310.method_1551().method_1576();
            if (server != null && server.method_3860()) {
                assert (protoClient != null);
                protoClient.publishedWorld(CONFIG.getFriends());
            }
        }
    }

    public static void refreshFriendsList() {
        LOGGER.info("Refreshing friends list...");
        ONLINE_FRIENDS.clear();
        ONLINE_FRIEND_UPDATES.forEach(FriendsListUpdate::friendsListUpdate);
        for (LoadedWorldHostPlugin plugin : plugins) {
            plugin.plugin().refreshOnlineFriends();
        }
    }

    public static void commandRegistrationHandler(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"worldhost").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"ip").requires(s -> s.method_9211().method_3860())).executes(WorldHost::ipCommand))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tempip").requires(s -> CONFIG.isUPnP() && s.method_9211().method_3860() && upnpGateway != null && protoClient != null && !protoClient.getUserIp().isEmpty())).executes(ctx -> {
            assert (upnpGateway != null);
            assert (protoClient != null);
            try {
                int port = ((class_2168)ctx.getSource()).method_9211().method_3756();
                UPnPErrors.AddPortMappingErrors error = upnpGateway.openPort(port, 60, false);
                if (error == null) {
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"world-host.worldhost.tempip.success", (Object[])new Object[]{Components.copyOnClickText(protoClient.getUserIp() + ":" + port)}), false);
                    return 1;
                }
                LOGGER.info("Failed to use UPnP mode due to {}. tempip not supported.", (Object)error);
            }
            catch (Exception e) {
                LOGGER.error("Failed to open UPnP due to exception", (Throwable)e);
            }
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43469((String)"world-host.worldhost.tempip.failure", (Object[])new Object[]{class_2564.method_10885((class_2561)class_2561.method_43470((String)"/worldhost ip")).method_27694(style -> style.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11745, "/worldhost ip")))}));
            return 0;
        })));
    }

    public static void scanUpnp() {
        if (hasScannedForUpnp) {
            return;
        }
        hasScannedForUpnp = true;
        LOGGER.info("Scanning for UPnP gateway");
        new GatewayFinder(gateway -> {
            upnpGateway = gateway;
            LOGGER.info("Found UPnP gateway: {}", (Object)gateway.getGatewayIP());
        });
    }

    public static boolean hasScannedForUpnp() {
        return hasScannedForUpnp;
    }

    public static void reconnect(boolean successToast, boolean failureToast) {
        WorldHost.shutdownClients();
        LOGGER.info("Attempting to connect to WH server at {}", (Object)CONFIG.getServerIp());
        protoClient = new ProtocolClient(CONFIG.getServerIp(), successToast, failureToast);
        connectingFuture = protoClient.getConnectingFuture();
        protoClient.authenticate(class_310.method_1551().method_1548());
    }

    public static void shutdownClients() {
        if (protoClient != null) {
            protoClient.close();
        }
        if (proxyProtocolClient != null) {
            proxyProtocolClient.close();
        }
        if (protoClient != null) {
            try {
                protoClient.getShutdownFuture().get(5L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOGGER.error("Failed to wait for protocol client shutdown", (Throwable)e);
            }
        }
        protoClient = null;
        if (proxyProtocolClient != null) {
            try {
                proxyProtocolClient.getShutdownFuture().get(5L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                LOGGER.error("Failed to wait for proxy protocol client shutdown", (Throwable)e);
            }
        }
        proxyProtocolClient = null;
    }

    public static class_3312 getProfileCache() {
        return profileCache;
    }

    public static WHPlayerSkin getInsecureSkin(GameProfile profile) {
        return WHPlayerSkin.fromSkinManager(class_310.method_1551().method_1582(), profile);
    }

    public static class_2960 getSkinLocationNow(GameProfile profile) {
        return WorldHost.getInsecureSkin(profile).texture();
    }

    public static void getMaybeAsync(class_3312 cache, String name, Consumer<Optional<GameProfile>> action) {
        cache.method_37156(name).thenAccept(action);
    }

    public static GameProfile fetchProfile(MinecraftSessionService sessionService, UUID uuid, @Nullable GameProfile fallback) {
        ProfileResult result = sessionService.fetchProfile(uuid, false);
        if (result == null) {
            return fallback != null ? fallback : new GameProfile(uuid, "");
        }
        return result.profile();
    }

    public static GameProfile fetchProfile(MinecraftSessionService sessionService, UUID uuid) {
        return WorldHost.fetchProfile(sessionService, uuid, null);
    }

    public static GameProfile fetchProfile(MinecraftSessionService sessionService, GameProfile profile) {
        return WorldHost.fetchProfile(sessionService, profile.getId(), profile);
    }

    public static CompletableFuture<GameProfile> resolveGameProfile(GameProfile profile) {
        if (profile.getId().version() != 4) {
            return CompletableFuture.completedFuture(profile);
        }
        return CompletableFuture.supplyAsync(() -> WorldHost.fetchProfile(class_310.method_1551().method_1495(), profile), (Executor)class_156.method_55473());
    }

    public static CompletableFuture<ProfileInfo> resolveProfileInfo(GameProfile profile) {
        return WorldHost.resolveGameProfile(profile).thenApply(GameProfileProfileInfo::new);
    }

    public static boolean isFriend(UUID user) {
        return CONFIG.isEnableFriends() && CONFIG.getFriends().contains(user);
    }

    public static void addFriends(UUID ... friends) {
        WorldHost.addFriends(List.of(friends));
    }

    public static void addFriends(Collection<UUID> friends) {
        CONFIG.getFriends().addAll(friends);
        WorldHost.saveConfig();
        class_1132 server = class_310.method_1551().method_1576();
        if (server != null && server.method_3860() && protoClient != null) {
            protoClient.publishedWorld(friends);
        }
    }

    public static void showFriendOrOnlineToast(CompletableFuture<ProfileInfo> profileFuture, @Translatable String title, @Translatable String description, int ticks, @Nullable Runnable clickAction) {
        profileFuture.thenAccept(profile -> WHToast.builder((class_2561)class_2561.method_43469((String)title, (Object[])new Object[]{profile.name()})).description((class_2561)class_2561.method_43471((String)description)).icon(profile.iconRenderer()).clickAction(clickAction).ticks(ticks).important().show());
    }

    public static class_2540 createByteBuf() {
        return new class_2540(Unpooled.buffer());
    }

    public static class_2926 parseServerStatus(class_2540 buf) throws IOException {
        return ((class_2924)class_2924.field_48258.decode((Object)buf)).comp_1272();
    }

    public static class_2540 writeServerStatus(@Nullable class_2926 metadata) {
        if (metadata == null) {
            metadata = WorldHost.createEmptyServerStatus();
        }
        class_2540 buf = WorldHost.createByteBuf();
        class_2924.field_48258.encode((Object)buf, (Object)new class_2924(metadata));
        return buf;
    }

    public static class_2926 createEmptyServerStatus() {
        return new class_2926(class_5244.field_39003, Optional.empty(), Optional.empty(), Optional.empty(), false);
    }

    @Nullable
    public static String getExternalIp() {
        if (protoClient == null) {
            return null;
        }
        if (proxyProtocolClient != null) {
            return WorldHost.getExternalIp0(proxyProtocolClient.getBaseAddr(), proxyProtocolClient.getMcPort());
        }
        if (protoClient.getBaseIp().isEmpty()) {
            return null;
        }
        return WorldHost.getExternalIp0(protoClient.getBaseIp(), protoClient.getBasePort());
    }

    private static String getExternalIp0(String baseIp, int basePort) {
        assert (protoClient != null);
        String ip = WorldHost.connectionIdToString(protoClient.getConnectionId()) + "." + baseIp;
        if (basePort != 25565) {
            ip = ip + ":" + basePort;
        }
        return ip;
    }

    public static void pingFriends() {
        ONLINE_FRIEND_PINGS.clear();
        if (ONLINE_FRIENDS.isEmpty()) {
            return;
        }
        for (LoadedWorldHostPlugin plugin : plugins) {
            plugin.plugin().pingFriends(ONLINE_FRIENDS.values());
        }
    }

    public static void pingFriends(Collection<OnlineFriend> friends) {
        if (friends.isEmpty()) {
            return;
        }
        for (OnlineFriend friend : friends) {
            ONLINE_FRIEND_PINGS.remove(friend.uuid());
        }
        for (LoadedWorldHostPlugin plugin : plugins) {
            plugin.plugin().pingFriends(friends);
        }
    }

    public static String connectionIdToString(long connectionId) {
        if (connectionId < 0L || connectionId >= 0x40000000000L) {
            throw new IllegalArgumentException("Invalid connection ID " + connectionId);
        }
        if (CONFIG.isUseShortIp()) {
            return StringUtils.leftPad((String)Long.toString(connectionId, 36), (int)9, (char)'0');
        }
        int first = (int)(connectionId & 0x3FFFL);
        int second = (int)(connectionId >>> 14) & 0x3FFF;
        int third = (int)(connectionId >>> 28) & 0x3FFF;
        return wordsForCid.get(first) + "-" + wordsForCid.get(second) + "-" + wordsForCid.get(third);
    }

    @Nullable
    public static Long tryParseConnectionId(String str) {
        String[] words = str.split("-");
        if (words.length != 3) {
            if (words.length == 1) {
                String word = words[0];
                if (word.length() != 9) {
                    return null;
                }
                return Long.parseLong(word, 36);
            }
            return null;
        }
        long result = 0L;
        int shift = 0;
        for (String word : words) {
            int part = wordsForCidInverse.getInt((Object)word);
            if (part == -1) {
                return null;
            }
            result |= (long)part << shift;
            shift += 14;
        }
        return result;
    }

    public static void join(long connectionId, class_437 parentScreen) {
        if (protoClient == null) {
            LOGGER.error("Tried to join {}, but protoClient == null!", (Object)WorldHost.connectionIdToString(connectionId));
            return;
        }
        protoClient.setAttemptingToJoin(connectionId);
        class_310.method_1551().method_1507((class_437)new JoiningWorldHostScreen(parentScreen));
        protoClient.requestDirectJoin(connectionId);
    }

    public static void connect(class_437 parentScreen, long cid) {
        if (protoClient == null) {
            LOGGER.error("Tried to connect to {}, but protoClient == null!", (Object)WorldHost.connectionIdToString(cid));
            return;
        }
        WorldHost.connect(parentScreen, cid, WorldHost.connectionIdToString(cid) + "." + protoClient.getBaseIp(), protoClient.getBasePort());
    }

    public static void connect(class_437 parentScreen, long cid, String host, int port) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.method_1576() != null) {
            minecraft.method_1576().method_3747(false);
        }
        class_639 serverAddress = new class_639(host, port);
        class_642 serverData = new class_642(WorldHost.connectionIdToString(cid), serverAddress.toString(), class_642.class_8678.field_45611);
        ((ServerDataExt)serverData).wh$setConnectionId(cid);
        class_412.method_36877((class_437)parentScreen, (class_310)minecraft, (class_639)serverAddress, (class_642)serverData, (boolean)false, null);
    }

    private static int ipCommand(CommandContext<class_2168> ctx) {
        if (protoClient == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"world-host.worldhost.ip.not_connected"));
            return 0;
        }
        String externalIp = WorldHost.getExternalIp();
        if (externalIp == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43471((String)"world-host.worldhost.ip.no_server_support"));
            return 0;
        }
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43469((String)"world-host.worldhost.ip.success", (Object[])new Object[]{Components.copyOnClickText(externalIp)}), false);
        return 1;
    }

    public static void proxyConnect(long connectionId, InetAddress remoteAddr, Supplier<ProxyPassthrough> proxy) {
        class_1132 server = class_310.method_1551().method_1576();
        if (server == null || !server.method_3860()) {
            if (protoClient != null) {
                protoClient.proxyDisconnect(connectionId);
            }
            return;
        }
        try {
            ProxyClient proxyClient = new ProxyClient(remoteAddr, connectionId, proxy);
            CONNECTED_PROXY_CLIENTS.put(connectionId, (Object)proxyClient);
            proxyClient.start();
        }
        catch (IOException e) {
            LOGGER.error("Failed to start ProxyClient", (Throwable)e);
        }
    }

    public static void proxyPacket(long connectionId, byte[] data) {
        ProxyClient proxyClient = (ProxyClient)((Object)CONNECTED_PROXY_CLIENTS.get(connectionId));
        if (proxyClient != null) {
            proxyClient.send(data);
        } else {
            LOGGER.warn("Received packet for unknown connection {}", (Object)connectionId);
        }
    }

    public static void proxyDisconnect(long connectionId) {
        ProxyClient proxyClient = (ProxyClient)((Object)CONNECTED_PROXY_CLIENTS.remove(connectionId));
        if (proxyClient != null) {
            proxyClient.close();
        } else {
            LOGGER.warn("Received disconnect from unknown connection {}", (Object)connectionId);
        }
    }

    public static String getModVersion(String modId) {
        return ((ModContainer)FabricLoader.getInstance().getModContainer(modId).orElseThrow(() -> new IllegalStateException("Couldn't find mod " + modId))).getMetadata().getVersion().getFriendlyString();
    }

    public static boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    public static int getMenuLines(boolean isPause, OnlineStatusLocation side) {
        if (!WorldHost.isModLoaded("isxander-main-menu-credits")) {
            return 0;
        }
        MMCConfig baseConfig = MainMenuCredits.getInstance().getConfig();
        MMCConfigEntry config = isPause ? baseConfig.PAUSE_MENU : baseConfig.MAIN_MENU;
        return (side == OnlineStatusLocation.RIGHT ? config.getBottomRight() : config.getBottomLeft()).size();
    }

    public static int getMenuLineSpacing() {
        return 12;
    }

    public static <T> CompletableFuture<T> httpGet(String baseUri, Consumer<URIBuilder> buildAction, IOFunction<InputStream, T> handler) {
        URI uri;
        try {
            URIBuilder uriBuilder = new URIBuilder(baseUri);
            buildAction.accept(uriBuilder);
            uri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        HttpRequest request = HttpRequest.newBuilder().uri(uri).header("User-Agent", "World Host/" + WorldHost.getModVersion(MOD_ID)).GET().build();
        return HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofInputStream()).thenComposeAsync(response -> {
            if (response.statusCode() != 200) {
                String reason = EnglishReasonPhraseCatalog.INSTANCE.getReason(response.statusCode(), null);
                return CompletableFuture.failedFuture(new IOException("Failed to GET " + String.valueOf(response.request().uri()) + ": " + response.statusCode() + " " + reason));
            }
            try {
                return CompletableFuture.completedFuture(handler.apply((Object)((InputStream)response.body())));
            }
            catch (Throwable t) {
                return CompletableFuture.failedFuture(t);
            }
        }, (Executor)class_156.method_27958());
    }

    private static Path getGameDir() {
        return FabricLoader.getInstance().getGameDir();
    }

    public static UUID getUserId() {
        class_320 user = class_310.method_1551().method_1548();
        return user.method_44717();
    }

    static {
        ONLINE_FRIENDS = new LinkedHashMap<UUID, OnlineFriend>();
        ONLINE_FRIEND_PINGS = new HashMap<UUID, class_2926>();
        ONLINE_FRIEND_UPDATES = Collections.newSetFromMap(new WeakHashMap());
        CONNECTED_PROXY_CLIENTS = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
        CONNECTION_ID = new SecureRandom().nextLong(0x40000000000L);
        HTTP_CLIENT = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).executor((Executor)class_156.method_27958()).build();
        reconnectDelay = 0;
        delayIndex = 0;
    }
}

