/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost;

import io.github.gaming32.worldhost.WorldHost;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.quiltmc.parsers.json.JsonReader;
import org.semver4j.Semver;

public class WorldHostUpdateChecker {
    public static final String MODRINTH_ID = "world-host";

    public static CompletableFuture<Optional<String>> checkForUpdates() {
        return ((CompletableFuture)WorldHost.httpGet("https://api.modrinth.com/v2/project/world-host/version", builder -> builder.addParameter("game_versions", "[\"" + WorldHost.getModVersion("minecraft") + "\"]").addParameter("loaders", "[\"" + String.valueOf((Object)WorldHost.MOD_LOADER) + "\"]"), input -> {
            try (JsonReader reader = JsonReader.json((Reader)new InputStreamReader((InputStream)input, StandardCharsets.UTF_8));){
                reader.beginArray();
                if (!reader.hasNext()) {
                    String string = null;
                    return string;
                }
                reader.beginObject();
                while (reader.hasNext()) {
                    String key = reader.nextName();
                    if (!key.equals("version_number")) {
                        reader.skipValue();
                        continue;
                    }
                    String string = reader.nextString();
                    return string;
                }
                String string = null;
                return string;
            }
        }).thenApply(latestVersion -> {
            if (latestVersion == null) {
                return Optional.empty();
            }
            if (new Semver(WorldHost.getModVersion(MODRINTH_ID)).compareTo(new Semver(latestVersion)) >= 0) {
                return Optional.empty();
            }
            return Optional.of(latestVersion);
        })).exceptionally(t -> {
            WorldHost.LOGGER.error("Failed to check for updates", t);
            return Optional.empty();
        });
    }

    public static String formatUpdateLink(String version) {
        return "https://modrinth.com/mod/world-host/version/" + version;
    }
}

