/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.compat.simplevoicechat;

import de.maxhenkel.voicechat.api.ClientVoicechatSocket;
import de.maxhenkel.voicechat.api.RawUdpPacket;
import de.maxhenkel.voicechat.plugins.impl.VoicechatSocketBase;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class WorldHostClientVoicechatSocket
extends VoicechatSocketBase
implements ClientVoicechatSocket {
    @Nullable
    private DatagramSocket socket;
    @Nullable
    private SocketAddress targetAddress;

    public void setTargetAddress(@Nullable SocketAddress targetAddress) {
        this.targetAddress = targetAddress;
    }

    public void open() throws Exception {
        this.socket = new DatagramSocket();
    }

    public RawUdpPacket read() throws Exception {
        if (this.socket == null) {
            throw new IllegalStateException("Socket not opened yet");
        }
        return this.read(this.socket);
    }

    public void send(byte[] data, SocketAddress address) throws Exception {
        this.sendDirect(data, Objects.requireNonNullElse(this.targetAddress, address));
    }

    public void sendDirect(byte[] data, SocketAddress address) throws IOException {
        if (this.socket == null) {
            return;
        }
        this.socket.send(new DatagramPacket(data, data.length, address));
    }

    public void close() {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    public boolean isClosed() {
        return this.socket == null;
    }
}

