/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.config;

import io.github.gaming32.worldhost.SecurityLevel;
import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.config.ConfigProperty;
import io.github.gaming32.worldhost.config.option.ConfigOption;
import io.github.gaming32.worldhost.config.option.ConfigOptions;
import io.github.gaming32.worldhost.gui.OnlineStatusLocation;
import io.github.gaming32.worldhost.testing.WorldHostTesting;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import org.quiltmc.parsers.json.JsonReader;
import org.quiltmc.parsers.json.JsonWriter;

public class WorldHostConfig {
    public static final String DEFAULT_SERVER_IP = "world-host.jemnetworks.com";
    private String serverIp = "world-host.jemnetworks.com";
    private OnlineStatusLocation onlineStatusLocation = OnlineStatusLocation.RIGHT;
    private boolean enableFriends = true;
    private boolean enableReconnectionToasts = false;
    private boolean UPnP = false;
    private boolean useShortIp = false;
    private boolean showOutdatedWorldHost = true;
    private boolean shareButton = true;
    private boolean allowFriendRequests = true;
    private boolean announceFriendsOnline = true;
    private boolean whitelistJoins = false;
    private SecurityLevel requiredSecurityLevel = WorldHostTesting.ENABLED ? SecurityLevel.OFFLINE : SecurityLevel.SECURE;
    private final Set<UUID> friends = Collections.synchronizedSet(new LinkedHashSet());

    public void read(JsonReader reader) throws IOException {
        reader.beginObject();
        block12: while (reader.hasNext()) {
            String key;
            switch (key = reader.nextName()) {
                default: {
                    ConfigOption<?> option = ConfigOptions.OPTIONS.get(key);
                    if (option != null) {
                        option.readValue(reader, this);
                        break;
                    }
                    WorldHost.LOGGER.warn("Unknown WH config key {}. Skipping.", (Object)key);
                    reader.skipValue();
                    break;
                }
                case "serverUri": {
                    WorldHost.LOGGER.info("Found old-style serverUri. Converting to new-style serverIp.");
                    String serverUri = reader.nextString();
                    int index = serverUri.indexOf("://");
                    if (index == -1) {
                        WorldHost.LOGGER.warn("Invalid serverUri. Missing ://");
                        this.serverIp = serverUri;
                        continue block12;
                    }
                    this.serverIp = serverUri.substring(index + 3);
                    if (!this.serverIp.endsWith(":9646")) continue block12;
                    this.serverIp = this.serverIp.substring(0, this.serverIp.length() - 5);
                    break;
                }
                case "showOnlineStatus": {
                    WorldHost.LOGGER.info("Converting old showOnlineStatus to new onlineStatusLocation.");
                    this.onlineStatusLocation = reader.nextBoolean() ? OnlineStatusLocation.RIGHT : OnlineStatusLocation.OFF;
                    break;
                }
                case "noUPnP": {
                    WorldHost.LOGGER.info("Converting old noUPnP to new UPnP");
                    this.UPnP = !reader.nextBoolean();
                    break;
                }
                case "friends": {
                    WorldHost.LOGGER.info("Found old friends list.");
                    reader.beginArray();
                    this.friends.clear();
                    while (reader.hasNext()) {
                        this.friends.add(UUID.fromString(reader.nextString()));
                    }
                    reader.endArray();
                }
            }
        }
        reader.endObject();
    }

    public void readFriends(JsonReader reader) throws IOException {
        reader.beginArray();
        this.friends.clear();
        while (reader.hasNext()) {
            this.friends.add(UUID.fromString(reader.nextString()));
        }
        reader.endArray();
    }

    public void write(JsonWriter writer) throws IOException {
        writer.beginObject();
        for (ConfigOption<?> option : ConfigOptions.OPTIONS.values()) {
            writer.name(option.getName());
            option.writeValue(this, writer);
        }
        writer.endObject();
    }

    public void writeFriends(JsonWriter writer) throws IOException {
        writer.beginArray();
        for (UUID friend : this.friends) {
            writer.value(friend.toString());
        }
        writer.endArray();
    }

    @ConfigProperty(order=0)
    @ConfigProperty.StringDefault(value="world-host.jemnetworks.com")
    public String getServerIp() {
        return this.serverIp;
    }

    public void setServerIp(String serverIp) {
        this.serverIp = serverIp;
    }

    @ConfigProperty(order=1)
    @ConfigProperty.EnumFallback(value="right")
    public OnlineStatusLocation getOnlineStatusLocation() {
        return this.onlineStatusLocation;
    }

    public void setOnlineStatusLocation(OnlineStatusLocation onlineStatusLocation) {
        this.onlineStatusLocation = onlineStatusLocation;
    }

    @ConfigProperty(order=2)
    public boolean isEnableFriends() {
        return this.enableFriends;
    }

    public void setEnableFriends(boolean enableFriends) {
        this.enableFriends = enableFriends;
    }

    @ConfigProperty(order=3)
    public boolean isEnableReconnectionToasts() {
        return this.enableReconnectionToasts;
    }

    public void setEnableReconnectionToasts(boolean enableReconnectionToasts) {
        this.enableReconnectionToasts = enableReconnectionToasts;
    }

    @ConfigProperty(order=4)
    public boolean isUPnP() {
        return this.UPnP;
    }

    public void setUPnP(boolean UPnP2) {
        this.UPnP = UPnP2;
    }

    @ConfigProperty(order=5)
    public boolean isUseShortIp() {
        return this.useShortIp;
    }

    public void setUseShortIp(boolean useShortIp) {
        this.useShortIp = useShortIp;
    }

    @ConfigProperty(order=6)
    public boolean isShowOutdatedWorldHost() {
        return this.showOutdatedWorldHost;
    }

    public void setShowOutdatedWorldHost(boolean showOutdatedWorldHost) {
        this.showOutdatedWorldHost = showOutdatedWorldHost;
    }

    @ConfigProperty(order=7)
    public boolean isShareButton() {
        return this.shareButton;
    }

    public void setShareButton(boolean shareButton) {
        this.shareButton = shareButton;
    }

    @ConfigProperty(order=8)
    public boolean isAllowFriendRequests() {
        return this.allowFriendRequests;
    }

    public void setAllowFriendRequests(boolean allowFriendRequests) {
        this.allowFriendRequests = allowFriendRequests;
    }

    @ConfigProperty(order=9)
    public boolean isAnnounceFriendsOnline() {
        return this.announceFriendsOnline;
    }

    public void setAnnounceFriendsOnline(boolean announceFriendsOnline) {
        this.announceFriendsOnline = announceFriendsOnline;
    }

    @ConfigProperty(order=10)
    public boolean isWhitelistJoins() {
        return this.whitelistJoins;
    }

    public void setWhitelistJoins(boolean whitelistJoins) {
        this.whitelistJoins = whitelistJoins;
    }

    @ConfigProperty(order=11)
    @ConfigProperty.EnumFallback(value="secure")
    public SecurityLevel getRequiredSecurityLevel() {
        return this.requiredSecurityLevel;
    }

    public void setRequiredSecurityLevel(SecurityLevel requiredSecurityLevel) {
        this.requiredSecurityLevel = requiredSecurityLevel;
    }

    public Set<UUID> getFriends() {
        return this.friends;
    }
}

