/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.config.option;

import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.config.ConfigProperty;
import io.github.gaming32.worldhost.config.WorldHostConfig;
import io.github.gaming32.worldhost.config.option.EnumOption;
import io.github.gaming32.worldhost.config.option.StringOption;
import io.github.gaming32.worldhost.config.option.YesNoOption;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.class_327;
import net.minecraft.class_339;
import org.jetbrains.annotations.Nullable;
import org.quiltmc.parsers.json.JsonReader;
import org.quiltmc.parsers.json.JsonWriter;

public abstract sealed class ConfigOption<T>
permits EnumOption, StringOption, YesNoOption {
    protected final PropertyDescriptor property;
    private final int order;
    @Nullable
    private Runnable onSet = null;

    protected ConfigOption(PropertyDescriptor property) {
        this.property = property;
        ConfigProperty info = property.getReadMethod().getAnnotation(ConfigProperty.class);
        this.order = info.order();
    }

    public String getName() {
        return this.property.getName();
    }

    public int getOrder() {
        return this.order;
    }

    public void onSet(Runnable onSet) {
        if (this.onSet == null) {
            this.onSet = onSet;
        } else {
            Runnable previous = this.onSet;
            this.onSet = () -> {
                previous.run();
                onSet.run();
            };
        }
    }

    public T getValue(WorldHostConfig config) {
        try {
            return (T)this.property.getReadMethod().invoke((Object)config, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public void setValue(WorldHostConfig config, T value) {
        this.setValueSilently(config, value);
        WorldHost.saveConfig();
        if (this.onSet != null) {
            this.onSet.run();
        }
    }

    public void setValueSilently(WorldHostConfig config, T value) {
        try {
            this.property.getWriteMethod().invoke((Object)config, value);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public final void readValue(JsonReader reader, WorldHostConfig config) throws IOException {
        this.setValueSilently(config, this.readValue(reader));
    }

    public abstract T readValue(JsonReader var1) throws IOException;

    public final void writeValue(WorldHostConfig config, JsonWriter writer) throws IOException {
        this.writeValue(this.getValue(config), writer);
    }

    public abstract void writeValue(T var1, JsonWriter var2) throws IOException;

    public boolean isWide() {
        return false;
    }

    public abstract Collection<? extends class_339> createWidgets(int var1, int var2, int var3, int var4, class_327 var5);
}

