/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.config.option;

import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.config.ConfigProperty;
import io.github.gaming32.worldhost.config.option.ConfigOption;
import io.github.gaming32.worldhost.gui.widget.EnumButton;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_3542;
import org.quiltmc.parsers.json.JsonReader;
import org.quiltmc.parsers.json.JsonWriter;

public final class EnumOption<E extends Enum<E>>
extends ConfigOption<E> {
    private final Class<E> enumType;
    private final Function<String, E> lookup;
    private final E fallbackValue;

    public EnumOption(PropertyDescriptor property) {
        super(property);
        if (!property.getPropertyType().isEnum()) {
            throw new IllegalArgumentException("Using EnumOption for non-enum option " + property.getName());
        }
        if (!class_3542.class.isAssignableFrom(property.getPropertyType())) {
            throw new IllegalArgumentException("EnumOption values need to be StringRepresentable on " + property.getName());
        }
        this.enumType = property.getPropertyType();
        this.lookup = Arrays.stream((Enum[])this.enumType.getEnumConstants()).collect(Collectors.toMap(rec$ -> ((class_3542)rec$).method_15434(), Function.identity()))::get;
        ConfigProperty.EnumFallback enumFallback = property.getReadMethod().getAnnotation(ConfigProperty.EnumFallback.class);
        if (enumFallback == null) {
            throw new IllegalArgumentException("@ConfigProperty.EnumFallback not specified for " + property.getName());
        }
        this.fallbackValue = (Enum)this.lookup.apply(enumFallback.value());
        if (this.fallbackValue == null) {
            throw new IllegalArgumentException("Unknown enum value " + enumFallback.value() + " specified for " + property.getName());
        }
    }

    @Override
    public E readValue(JsonReader reader) throws IOException {
        String name = reader.nextString();
        Enum value = (Enum)this.lookup.apply(name);
        if (value == null) {
            WorldHost.LOGGER.warn("Unknown value {} for {}. Defaulting to {}.", new Object[]{name, this.property.getName(), ((class_3542)this.fallbackValue).method_15434()});
            return this.fallbackValue;
        }
        return (E)value;
    }

    @Override
    public void writeValue(E value, JsonWriter writer) throws IOException {
        writer.value(((class_3542)value).method_15434());
    }

    @Override
    public Collection<? extends class_339> createWidgets(int x, int y, int width, int height, class_327 font) {
        String translationBase = "world-host.config." + this.property.getName();
        String tooltipKey = translationBase + ".tooltip";
        EnumButton<Enum> button = new EnumButton<Enum>(x, y, width, height, translationBase, (class_2561)class_2561.method_43471((String)translationBase), (class_2561)(class_1074.method_4663((String)tooltipKey) ? class_2561.method_43471((String)tooltipKey) : null), this.enumType, b -> this.setValue(WorldHost.CONFIG, (Enum)b.getValue()));
        button.setValue((Enum)this.getValue(WorldHost.CONFIG));
        return List.of(button);
    }
}

