/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.gui.screen;

import io.github.gaming32.worldhost.LoadedWorldHostPlugin;
import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.WorldHostComponents;
import io.github.gaming32.worldhost.gui.screen.AddFriendScreen;
import io.github.gaming32.worldhost.gui.screen.ScreenWithInfoTexts;
import io.github.gaming32.worldhost.gui.screen.WorldHostScreen;
import io.github.gaming32.worldhost.gui.widget.UserListWidget;
import io.github.gaming32.worldhost.plugin.FriendListFriend;
import io.github.gaming32.worldhost.plugin.InfoTextsCategory;
import io.github.gaming32.worldhost.plugin.ProfileInfo;
import io.github.gaming32.worldhost.versions.WorldHostRenderSystem;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FriendsScreen
extends ScreenWithInfoTexts {
    public static final class_2561 ADD_FRIEND_TEXT = class_2561.method_43471((String)"world-host.add_friend");
    private final class_437 parent;
    private class_4185 infoButton;
    private class_4185 removeButton;
    private FriendsList list;

    public FriendsScreen(class_437 parent) {
        super(WorldHostComponents.FRIENDS, InfoTextsCategory.FRIENDS_SCREEN);
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        if (this.list == null) {
            this.list = new FriendsList();
        }
        this.setListSize((class_350<?>)this.list, 32, this.getInfoTextsAdjustedBottomMargin(64));
        this.method_25429((class_364)this.list);
        this.method_37063((class_364)FriendsScreen.button(ADD_FRIEND_TEXT, button -> {
            assert (this.field_22787 != null);
            this.field_22787.method_1507((class_437)new AddFriendScreen(this, ADD_FRIEND_TEXT, null, (friend, notify) -> friend.addFriend((boolean)notify, this::refresh)));
        }).width(152).pos(this.field_22789 / 2 - 154, this.field_22790 - 54).build());
        this.infoButton = (class_4185)this.method_37063((class_364)FriendsScreen.button((class_2561)class_2561.method_43471((String)"world-host.friends.show_info"), button -> {
            if (this.list.method_25334() != null) {
                ((FriendsEntry)this.list.method_25334()).friend.showFriendInfo(this);
            }
        }).width(152).pos(this.field_22789 / 2 - 154, this.field_22790 - 30).build());
        this.infoButton.field_22763 = false;
        this.removeButton = (class_4185)this.method_37063((class_364)FriendsScreen.button((class_2561)class_2561.method_43471((String)"world-host.friends.remove"), button -> {
            if (this.list.method_25334() != null) {
                ((FriendsEntry)this.list.method_25334()).maybeRemove();
            }
        }).width(152).pos(this.field_22789 / 2 + 2, this.field_22790 - 54).build());
        this.removeButton.field_22763 = false;
        this.method_37063((class_364)FriendsScreen.button(class_5244.field_24334, button -> {
            assert (this.field_22787 != null);
            this.field_22787.method_1507(this.parent);
        }).width(152).pos(this.field_22789 / 2 + 2, this.field_22790 - 30).build());
        this.list.reloadEntries();
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    public void refresh() {
        assert (this.field_22787 != null);
        this.field_22787.execute(() -> this.list.reloadEntries());
    }

    @Override
    public void method_25394(@NotNull class_332 context, int mouseX, int mouseY, float delta) {
        this.whRenderBackground(context, mouseX, mouseY, delta);
        this.list.method_25394(context, mouseX, mouseY, delta);
        FriendsScreen.drawCenteredString(context, this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public class FriendsList
    extends class_4280<FriendsEntry> {
        private int reloadCount;

        public FriendsList() {
            super(FriendsScreen.this.field_22787, 0, 0, 0, 36);
            this.reloadCount = 0;
        }

        public void setSelected(@Nullable FriendsEntry entry) {
            super.method_25313((class_350.class_351)entry);
            FriendsScreen.this.infoButton.field_22763 = entry != null;
            FriendsScreen.this.removeButton.field_22763 = entry != null;
        }

        private void reloadEntries() {
            int currentReloadCount = ++this.reloadCount;
            this.method_25339();
            for (LoadedWorldHostPlugin plugin : WorldHost.getPlugins()) {
                plugin.plugin().listFriends(friend -> class_310.method_1551().execute(() -> {
                    if (this.reloadCount == currentReloadCount) {
                        this.addEntry(new FriendsEntry((FriendListFriend)friend));
                    }
                }));
            }
        }

        public int addEntry(@NotNull FriendsEntry entry) {
            return super.method_25321((class_350.class_351)entry);
        }
    }

    public class FriendsEntry
    extends class_4280.class_4281<FriendsEntry> {
        private final class_310 minecraft = class_310.method_1551();
        private final FriendListFriend friend;
        private ProfileInfo profile;
        private long clickTime;

        public FriendsEntry(FriendListFriend friend) {
            this.friend = friend;
            this.profile = friend.fallbackProfileInfo();
            ((CompletableFuture)friend.profileInfo().thenAccept(ready -> {
                this.profile = ready;
            })).exceptionally(t -> {
                WorldHost.LOGGER.error("Failed to request profile info for {}", (Object)friend, t);
                return null;
            });
        }

        @NotNull
        public class_2561 method_37006() {
            return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{this.getNameWithTag()});
        }

        public class_2561 getNameWithTag() {
            return UserListWidget.getNameWithTag(this.friend, this.profile);
        }

        public void method_25343(@NotNull class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.profile.iconRenderer().draw(context, x, y, 32, 32);
            WorldHostRenderSystem.disableBlend();
            class_327 class_3272 = this.minecraft.field_1772;
            class_2561 class_25612 = this.getNameWithTag();
            Objects.requireNonNull(this.minecraft.field_1772);
            WorldHostScreen.drawCenteredString(context, class_3272, class_25612, x + 110, y + 16 - 9 / 2, 0xFFFFFF);
        }

        public void maybeRemove() {
            this.minecraft.method_1507((class_437)new class_410(yes -> {
                if (yes) {
                    this.friend.removeFriend(FriendsScreen.this::refresh);
                }
                this.minecraft.method_1507((class_437)FriendsScreen.this);
            }, (class_2561)class_2561.method_43471((String)"world-host.friends.remove.title"), (class_2561)class_2561.method_43471((String)"world-host.friends.remove.message")));
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            FriendsScreen.this.list.setSelected(this);
            if (class_156.method_658() - this.clickTime < 250L) {
                this.friend.showFriendInfo(FriendsScreen.this);
                this.clickTime = class_156.method_658();
                return true;
            }
            this.clickTime = class_156.method_658();
            return false;
        }
    }
}

