/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.gui.screen;

import com.mojang.authlib.GameProfile;
import de.florianmichael.viafabricplus.screen.base.ProtocolSelectionScreen;
import de.florianmichael.viafabricplus.settings.impl.GeneralSettings;
import io.github.gaming32.worldhost.FriendsListUpdate;
import io.github.gaming32.worldhost.ResourceLocations;
import io.github.gaming32.worldhost.SecurityLevel;
import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.WorldHostComponents;
import io.github.gaming32.worldhost.gui.screen.FriendsScreen;
import io.github.gaming32.worldhost.gui.screen.ScreenWithInfoTexts;
import io.github.gaming32.worldhost.gui.screen.WorldHostScreen;
import io.github.gaming32.worldhost.gui.widget.EnumButton;
import io.github.gaming32.worldhost.gui.widget.FriendsButton;
import io.github.gaming32.worldhost.mixin.ServerStatusPingerAccessor;
import io.github.gaming32.worldhost.plugin.InfoTextsCategory;
import io.github.gaming32.worldhost.plugin.Joinability;
import io.github.gaming32.worldhost.plugin.OnlineFriend;
import io.github.gaming32.worldhost.plugin.ProfileInfo;
import io.github.gaming32.worldhost.versions.WorldHostRenderSystem;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2926;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_500;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_642;
import net.minecraft.class_7919;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnlineFriendsScreen
extends ScreenWithInfoTexts
implements FriendsListUpdate {
    private static final class_2960 INCOMPATIBLE_SPRITE = ResourceLocations.minecraft("server_list/incompatible");
    private static final class_2960 JOIN_HIGHLIGHTED_SPRITE = ResourceLocations.minecraft("server_list/join_highlighted");
    private static final class_2960 JOIN_SPRITE = ResourceLocations.minecraft("server_list/join");
    private final class_437 parent;
    private OnlineFriendsList list;
    private class_4185 joinButton;
    @Nullable
    private List<class_5481> tooltip;

    public OnlineFriendsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"world-host.online_friends.title"), InfoTextsCategory.ONLINE_FRIENDS_SCREEN);
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        assert (this.field_22787 != null);
        OnlineFriendsScreen.sendRepeatEvents(true);
        if (this.list == null) {
            this.list = new OnlineFriendsList();
            WorldHost.pingFriends();
            this.addListEntries(WorldHost.ONLINE_FRIENDS);
            WorldHost.ONLINE_FRIEND_UPDATES.add(this);
        }
        this.setListSize((class_350<?>)this.list, 60, this.getInfoTextsAdjustedBottomMargin(64));
        this.method_25429((class_364)this.list);
        this.joinButton = (class_4185)this.method_37063((class_364)OnlineFriendsScreen.button((class_2561)class_2561.method_43471((String)"selectServer.select"), button -> this.connect()).width(152).pos(this.field_22789 / 2 - 154, this.field_22790 - 54).build());
        this.method_37063((class_364)OnlineFriendsScreen.button((class_2561)class_2561.method_43471((String)"selectServer.refresh"), button -> WorldHost.refreshFriendsList()).width(152).pos(this.field_22789 / 2 + 2, this.field_22790 - 54).build());
        this.method_37063((class_364)OnlineFriendsScreen.button(WorldHostComponents.FRIENDS, button -> this.field_22787.method_1507((class_437)new FriendsScreen(this))).width(152).pos(this.field_22789 / 2 - 154, this.field_22790 - 30).build());
        this.method_37063((class_364)OnlineFriendsScreen.button(class_5244.field_24335, button -> this.field_22787.method_1507(this.parent)).width(152).pos(this.field_22789 / 2 + 2, this.field_22790 - 30).build());
        this.method_37063((class_364)OnlineFriendsScreen.button(WorldHostComponents.SERVERS, button -> {
            assert (this.field_22787 != null);
            this.field_22787.method_1507((class_437)new class_500(this.parent));
        }).pos(this.field_22789 / 2 - 102, 32).width(100).build());
        ((FriendsButton)this.method_37063((class_364)new FriendsButton((int)(this.field_22789 / 2 + 2), (int)32, (int)100, (int)20, (class_4185.class_4241)(class_4185.class_4241)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/class_4185;)V, lambda$init$5(net.minecraft.class_4185 ), (Lnet/minecraft/class_4185;)V)()))).field_22763 = false;
        this.updateButtonActivationStates();
        if (WorldHost.isModLoaded("viafabricplus")) {
            this.vfpInit();
        }
    }

    private void vfpInit() {
        class_4185.class_7840 builder = class_4185.method_46430((class_2561)class_2561.method_43470((String)"ViaFabricPlus"), button -> ProtocolSelectionScreen.INSTANCE.open((class_437)this)).method_46437(98, 20);
        builder = GeneralSettings.withOrientation((class_4185.class_7840)builder, (int)GeneralSettings.global().multiplayerScreenButtonOrientation.getIndex(), (int)this.field_22789, (int)this.field_22790);
        this.method_37063((class_364)builder.method_46431());
    }

    public void method_25432() {
        assert (this.field_22787 != null);
        OnlineFriendsScreen.sendRepeatEvents(false);
        WorldHost.ONLINE_FRIEND_UPDATES.remove(this);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 294) {
            WorldHost.refreshFriendsList();
            return true;
        }
        if (this.list.method_25334() != null) {
            if (keyCode != 257 && keyCode != 335) {
                return this.list.method_25404(keyCode, scanCode, modifiers);
            }
            this.connect();
            return true;
        }
        return false;
    }

    @Override
    public void method_25394(@NotNull class_332 context, int mouseX, int mouseY, float delta) {
        this.tooltip = null;
        this.whRenderBackground(context, mouseX, mouseY, delta);
        this.list.method_25394(context, mouseX, mouseY, delta);
        OnlineFriendsScreen.drawCenteredString(context, this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.tooltip != null) {
            this.renderTooltip(context, this.tooltip, mouseX, mouseY);
        }
    }

    public void method_25393() {
        super.method_25393();
        for (OnlineFriendsListEntry entry : this.list.method_25396()) {
            entry.updateDisplayInfo();
        }
    }

    public void connect() {
        OnlineFriendsListEntry entry = (OnlineFriendsListEntry)this.list.method_25334();
        if (entry == null || entry.friend.joinability() instanceof Joinability.Unjoinable) {
            return;
        }
        WorldHost.LOGGER.info("Requesting to join {}", (Object)entry.friend);
        entry.friend.joinWorld(this);
    }

    public void select(OnlineFriendsListEntry entry) {
        this.list.setSelected(entry);
        this.updateButtonActivationStates();
    }

    private void updateButtonActivationStates() {
        OnlineFriendsListEntry selected = (OnlineFriendsListEntry)this.list.method_25334();
        if (selected != null) {
            Joinability joinability = selected.friend.joinability();
            this.joinButton.field_22763 = joinability.canJoin();
            this.joinButton.method_47400((class_7919)joinability.reason().map(class_7919::method_47407).orElse(null));
        } else {
            this.joinButton.field_22763 = false;
        }
    }

    @Override
    public void friendsListUpdate(Map<UUID, OnlineFriend> friends) {
        LinkedHashMap<UUID, OnlineFriend> friendsToAdd = new LinkedHashMap<UUID, OnlineFriend>(friends);
        for (int i = this.list.method_25396().size() - 1; i >= 0; --i) {
            UUID uuid = ((OnlineFriendsListEntry)((Object)this.list.method_25396().get((int)i))).friend.uuid();
            if (friends.containsKey(uuid)) {
                friendsToAdd.remove(uuid);
                continue;
            }
            this.list.remove(i);
        }
        WorldHost.pingFriends(friends.values());
        this.addListEntries(friendsToAdd);
    }

    private void addListEntries(Map<?, OnlineFriend> friends) {
        friends.values().stream().map(x$0 -> new OnlineFriendsListEntry((OnlineFriend)x$0)).forEach(this.list::addEntry);
    }

    private static /* synthetic */ void lambda$init$5(class_4185 button) {
    }

    public class OnlineFriendsList
    extends class_4280<OnlineFriendsListEntry> {
        public OnlineFriendsList() {
            super(OnlineFriendsScreen.this.field_22787, 0, 0, 0, 36);
        }

        @Nullable
        protected OnlineFriendsListEntry remove(int index) {
            return (OnlineFriendsListEntry)super.method_25338(index);
        }

        protected int addEntry(@NotNull OnlineFriendsListEntry entry) {
            return super.method_25321((class_350.class_351)entry);
        }

        public void setSelected(@Nullable OnlineFriendsListEntry entry) {
            super.method_25313((class_350.class_351)entry);
            OnlineFriendsScreen.this.updateButtonActivationStates();
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            OnlineFriendsListEntry entry = (OnlineFriendsListEntry)this.method_25334();
            return entry != null && entry.method_25404(keyCode, scanCode, modifiers) || super.method_25404(keyCode, scanCode, modifiers);
        }

        public int method_25322() {
            return super.method_25322() + 85;
        }

        public int method_25337(int index) {
            return super.method_25337(index);
        }

        public int getItemHeight() {
            return this.field_22741;
        }
    }

    public class OnlineFriendsListEntry
    extends class_4280.class_4281<OnlineFriendsListEntry> {
        private final class_310 minecraft;
        private final class_642 serverInfo = new class_642("", "", class_642.class_8678.field_45611);
        private final OnlineFriend friend;
        private ProfileInfo profile;
        private class_2561 displayName;
        @Nullable
        private List<class_5481> joinabilityTooltip;
        private boolean joinable;
        private final class_2960 iconTextureId;
        private byte[] iconData;
        @Nullable
        private class_1043 icon;
        private long clickTime;

        public OnlineFriendsListEntry(OnlineFriend friend) {
            this.minecraft = class_310.method_1551();
            this.friend = friend;
            this.profile = friend.fallbackProfileInfo();
            ((CompletableFuture)friend.profileInfo().thenAccept(ready -> {
                this.profile = ready;
            })).exceptionally(t -> {
                WorldHost.LOGGER.error("Failed to request profile info for {}", (Object)friend, t);
                return null;
            });
            this.iconTextureId = ResourceLocations.worldHost("servers/" + String.valueOf(friend.uuid()) + "/icon");
            this.updateDisplayInfo();
        }

        @NotNull
        public class_2561 method_37006() {
            return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{this.displayName});
        }

        public void method_25343(@NotNull class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            byte[] icon;
            boolean incompatibleVersion = this.serverInfo.field_3756 != class_155.method_16673().method_48020();
            WorldHostScreen.drawString(context, OnlineFriendsScreen.this.field_22793, this.displayName, x + 35, y + 1, 0xFFFFFF, false);
            List lines = OnlineFriendsScreen.this.field_22793.method_1728((class_5348)this.serverInfo.field_3757, entryWidth - 34);
            for (int i = 0; i < Math.min(lines.size(), 2); ++i) {
                WorldHostScreen.drawString(context, OnlineFriendsScreen.this.field_22793, (class_5481)lines.get(i), x + 35, y + 12 + 9 * i, 0x808080, false);
            }
            class_2561 sideLabel = incompatibleVersion ? this.serverInfo.field_3760.method_27661().method_27692(class_124.field_1061) : this.serverInfo.field_3753;
            int labelWidth = OnlineFriendsScreen.this.field_22793.method_27525((class_5348)sideLabel);
            WorldHostScreen.drawString(context, OnlineFriendsScreen.this.field_22793, sideLabel, x + entryWidth - labelWidth - 17, y + 1, 0x808080, false);
            if (incompatibleVersion) {
                WorldHostRenderSystem.enableBlend();
                WorldHostScreen.blitSprite(context, INCOMPATIBLE_SPRITE, x + entryWidth - 15, y, 10, 8);
                WorldHostRenderSystem.disableBlend();
            }
            if (!Arrays.equals(icon = this.serverInfo.method_49306(), this.iconData)) {
                if (this.uploadServerIcon(icon)) {
                    this.iconData = icon;
                } else {
                    this.serverInfo.method_49305(null);
                }
            }
            if (icon == null) {
                this.profile.iconRenderer().draw(context, x, y, 32, 32);
                WorldHostRenderSystem.disableBlend();
            } else {
                WorldHostRenderSystem.enableBlend();
                WorldHostScreen.blit(context, this.iconTextureId, x, y, 0.0f, 0.0f, 32, 32, 32, 32);
                WorldHostRenderSystem.disableBlend();
            }
            int relX = mouseX - x;
            int relY = mouseY - y;
            if (relX >= entryWidth - 15 && relX <= entryWidth - 5 && relY >= 0 && relY <= 8) {
                if (incompatibleVersion) {
                    OnlineFriendsScreen.this.tooltip = List.of(class_2561.method_43471((String)"multiplayer.status.incompatible").method_30937());
                }
            } else if (relX >= entryWidth - labelWidth - 17 && relX <= entryWidth - 17 && relY >= 0 && relY <= 8) {
                OnlineFriendsScreen.this.tooltip = new ArrayList<class_5481>();
                for (class_2561 line : this.serverInfo.field_3762) {
                    OnlineFriendsScreen.this.tooltip.add(line.method_30937());
                }
            } else if (this.joinabilityTooltip != null && hovered) {
                OnlineFriendsScreen.this.tooltip = this.joinabilityTooltip;
            }
            boolean touchscreen = (Boolean)this.minecraft.field_1690.method_42446().method_41753();
            if (this.joinable && (touchscreen || hovered)) {
                WorldHostScreen.fill(context, x, y, x + 32, y + 32, -1601138544);
                if (relX < 32 && relX > 16) {
                    WorldHostScreen.blitSprite(context, JOIN_HIGHLIGHTED_SPRITE, x, y, 32, 32);
                } else {
                    WorldHostScreen.blitSprite(context, JOIN_SPRITE, x, y, 32, 32);
                }
            }
        }

        private void updateDisplayInfo() {
            this.serverInfo.field_3752 = this.profile.name();
            this.updateNameAndTooltip();
            class_2926 metadata = WorldHost.ONLINE_FRIEND_PINGS.get(this.friend.uuid());
            if (metadata == null) {
                this.serverInfo.field_3753 = class_5244.field_39003;
                this.serverInfo.field_3757 = class_5244.field_39003;
                return;
            }
            this.serverInfo.field_3757 = metadata.comp_1273();
            metadata.comp_1275().ifPresentOrElse(version -> {
                this.serverInfo.field_3760 = class_2561.method_43470((String)version.comp_1282());
                this.serverInfo.field_3756 = version.comp_1283();
            }, () -> {
                this.serverInfo.field_3760 = class_2561.method_43471((String)"multiplayer.status.old");
                this.serverInfo.field_3756 = 0;
            });
            metadata.comp_1274().ifPresentOrElse(players -> {
                this.serverInfo.field_3753 = ServerStatusPingerAccessor.callFormatPlayerCount(players.comp_1280(), players.comp_1279());
                this.serverInfo.field_41861 = players;
                if (!players.comp_1281().isEmpty()) {
                    ArrayList<class_5250> playerList = new ArrayList<class_5250>(players.comp_1281().size());
                    for (GameProfile gameProfile : players.comp_1281()) {
                        playerList.add(class_2561.method_43470((String)gameProfile.getName()));
                    }
                    if (players.comp_1281().size() < players.comp_1280()) {
                        playerList.add(class_2561.method_43469((String)"multiplayer.status.and_more", (Object[])new Object[]{players.comp_1280() - players.comp_1281().size()}));
                    }
                    this.serverInfo.field_3762 = playerList;
                } else {
                    this.serverInfo.field_3762 = List.of();
                }
            }, () -> {
                this.serverInfo.field_3753 = class_2561.method_43471((String)"multiplayer.status.unknown").method_27692(class_124.field_1063);
            });
            metadata.comp_1276().ifPresent(favicon -> {
                if (!Arrays.equals(favicon.comp_1278(), this.serverInfo.method_49306())) {
                    this.serverInfo.method_49305(favicon.comp_1278());
                }
            });
        }

        private void updateNameAndTooltip() {
            SecurityLevel security = this.friend.security();
            Joinability joinability = this.friend.joinability();
            class_5250 newDisplayName = security == SecurityLevel.SECURE ? class_2561.method_43470((String)this.profile.name()) : class_2561.method_43469((String)"world-host.world_with_security", (Object[])new Object[]{this.profile.name(), EnumButton.getTranslation("world-host.config.requiredSecurityLevel", security)});
            newDisplayName.method_27694(joinability.nameFormatting());
            this.displayName = newDisplayName;
            this.joinabilityTooltip = joinability.reason().map(text -> OnlineFriendsScreen.this.field_22793.method_1728((class_5348)text, 170)).orElse(null);
            this.joinable = joinability.canJoin();
        }

        private boolean uploadServerIcon(byte @Nullable [] newIconData) {
            if (newIconData == null) {
                this.minecraft.method_1531().method_4615(this.iconTextureId);
                if (this.icon != null && this.icon.method_4525() != null) {
                    this.icon.method_4525().close();
                }
                this.icon = null;
            } else {
                try {
                    class_1011 image = class_1011.method_49277((byte[])newIconData);
                    Validate.validState((image.method_4307() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                    Validate.validState((image.method_4323() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                    if (this.icon == null) {
                        this.icon = new class_1043(image);
                    } else {
                        this.icon.method_4526(image);
                        this.icon.method_4524();
                    }
                    this.minecraft.method_1531().method_4616(this.iconTextureId, (class_1044)this.icon);
                }
                catch (Throwable t) {
                    WorldHost.LOGGER.error("Invalid icon for World Host server {} ({})", new Object[]{this.serverInfo.field_3752, this.friend.uuid(), t});
                    return false;
                }
            }
            return true;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            OnlineFriendsScreen.this.select(this);
            double relX = mouseX - (double)OnlineFriendsScreen.this.list.method_25342();
            if (relX < 32.0 && relX > 16.0) {
                OnlineFriendsScreen.this.connect();
                this.clickTime = class_156.method_658();
                return true;
            }
            if (class_156.method_658() - this.clickTime < 250L) {
                OnlineFriendsScreen.this.connect();
            }
            this.clickTime = class_156.method_658();
            return false;
        }
    }
}

