/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.gui.screen;

import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.WorldHostComponents;
import io.github.gaming32.worldhost.config.option.ConfigOption;
import io.github.gaming32.worldhost.config.option.ConfigOptions;
import io.github.gaming32.worldhost.gui.screen.FriendsScreen;
import io.github.gaming32.worldhost.gui.screen.WorldHostScreen;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import org.jetbrains.annotations.NotNull;

public class WorldHostConfigScreen
extends WorldHostScreen {
    private static final class_2561 TITLE = class_2561.method_43471((String)"world-host.config.title");
    private static final class_2561 UPNP = class_2561.method_43470((String)"UPnP");
    private final class_437 parent;
    private final String oldServerIp = WorldHost.CONFIG.getServerIp();
    private final boolean oldEnableFriends = WorldHost.CONFIG.isEnableFriends();

    public WorldHostConfigScreen(class_437 parent) {
        super(TITLE);
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        int yOffset = this.field_22790 / 6 - 24;
        boolean useThreeColumns = yOffset + 24 * WorldHostConfigScreen.getRowCount(2) + 68 >= this.field_22790;
        int columns = useThreeColumns ? 3 : 2;
        int columnLeft = useThreeColumns ? 153 : 155;
        int columnSpacing = useThreeColumns ? 4 : 10;
        int columnWidth = useThreeColumns ? 100 : 150;
        int columnIndex = 0;
        for (ConfigOption<?> option : ConfigOptions.OPTIONS.values()) {
            boolean wide = option.isWide();
            if (columnIndex == columns - 1 || wide) {
                yOffset += 24;
                columnIndex = 0;
            } else {
                ++columnIndex;
            }
            option.createWidgets(this.field_22789 / 2 - columnLeft + (columnWidth + columnSpacing) * columnIndex, yOffset, !wide ? columnWidth : columnWidth * columns + columnSpacing * (columns - 1), 20, this.field_22793).forEach(x$0 -> {
                class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
            });
            if (!wide) continue;
            columnIndex = columns - 1;
        }
        this.method_37063((class_364)WorldHostConfigScreen.button(WorldHostComponents.FRIENDS, button -> {
            assert (this.field_22787 != null);
            this.field_22787.method_1507((class_437)new FriendsScreen(this));
        }).pos(this.field_22789 / 2 - 155, yOffset += 48).build());
        this.method_37063((class_364)WorldHostConfigScreen.button(class_5244.field_24334, button -> {
            assert (this.field_22787 != null);
            this.field_22787.method_1507(this.parent);
        }).pos(this.field_22789 / 2 + 5, yOffset).build());
    }

    private static int getRowCount(int columns) {
        int columnIndex = 0;
        int rowCount = 0;
        for (ConfigOption<?> option : ConfigOptions.OPTIONS.values()) {
            boolean wide = option.isWide();
            if (columnIndex == columns - 1 || wide) {
                ++rowCount;
                columnIndex = 0;
            } else {
                ++columnIndex;
            }
            if (!wide) continue;
            columnIndex = columns - 1;
        }
        return rowCount;
    }

    public void method_25394(@NotNull class_332 context, int mouseX, int mouseY, float delta) {
        this.whRenderBackground(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        WorldHostConfigScreen.drawCenteredString(context, this.field_22793, this.field_22785, this.field_22789 / 2, 15, 0xFFFFFF);
        if (WorldHost.hasScannedForUpnp()) {
            WorldHostConfigScreen.drawRightString(context, this.field_22793, UPNP, this.field_22789 - 7, this.field_22790 - 15, WorldHost.upnpGateway != null ? 0x55FF55 : 0xFF5555);
        }
    }

    public void method_25432() {
        if (!WorldHost.CONFIG.getServerIp().equals(this.oldServerIp)) {
            WorldHost.reconnect(true, true);
        }
        if (this.oldEnableFriends && !WorldHost.CONFIG.isEnableFriends() && WorldHost.protoClient != null) {
            WorldHost.protoClient.closedWorld(WorldHost.CONFIG.getFriends());
        }
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }
}

