/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.gui.widget;

import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.gui.screen.WorldHostConfigScreen;
import io.github.gaming32.worldhost.mixin.PlainTextButtonAccessor;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7077;
import org.jetbrains.annotations.NotNull;

public final class OnlineStatusButton
extends class_7077 {
    private static final class_124[] COLORS = new class_124[]{class_124.field_1061, class_124.field_1065, class_124.field_1077};
    private static final List<Supplier<class_2561>> TEXTS = List.of(() -> class_2561.method_43469((String)"world-host.online_status.offline", (Object[])new Object[]{WorldHost.reconnectDelay / 20 + 1}), () -> class_2561.method_43471((String)"world-host.online_status.connecting"), () -> class_2561.method_43471((String)"world-host.online_status.online"));
    private final int alignedX;
    private final boolean rightAlign;
    private final class_327 font;
    private int currentStatus = OnlineStatusButton.getStatus();

    public OnlineStatusButton(int alignedX, int y, int height, boolean rightAlign, class_327 font) {
        super(alignedX, y, 0, height, OnlineStatusButton.generateStatusComponent(), b -> {
            if (class_437.method_25442()) {
                if (OnlineStatusButton.getStatus() != 1) {
                    WorldHost.reconnect(true, true);
                }
            } else {
                class_310 minecraft = class_310.method_1551();
                minecraft.method_1507((class_437)new WorldHostConfigScreen(minecraft.field_1755));
            }
        }, font);
        this.alignedX = alignedX;
        this.font = font;
        this.rightAlign = rightAlign;
        this.method_25358(font.method_27525((class_5348)this.method_25369()));
        this.updateX();
    }

    private void updateX() {
        this.method_46421(this.rightAlign ? this.alignedX - this.method_25368() : this.alignedX);
    }

    private static int getStatus() {
        if (WorldHost.protoClient == null) {
            return 0;
        }
        return WorldHost.protoClient.getConnectingFuture().isDone() ? 2 : 1;
    }

    private static class_2561 generateStatusComponent() {
        int status = OnlineStatusButton.getStatus();
        return class_2561.method_43469((String)"world-host.online_status", (Object[])new Object[]{class_2561.method_43470((String)"\u25cf").method_27692(COLORS[status]), TEXTS.get(status).get()});
    }

    public void method_48579(@NotNull class_332 context, int i, int j, float f) {
        int status = OnlineStatusButton.getStatus();
        if (status != this.currentStatus || status == 0 && (WorldHost.reconnectDelay + 1) % 20 == 0) {
            this.currentStatus = status;
            PlainTextButtonAccessor accessor = (PlainTextButtonAccessor)((Object)this);
            class_2561 message = OnlineStatusButton.generateStatusComponent();
            this.method_25355(message);
            accessor.setPTBMessage(message);
            accessor.setUnderlinedMessage((class_2561)class_2564.method_10889((class_5250)message.method_27661(), (class_2583)class_2583.field_24360.method_27706(class_124.field_1073)));
            this.method_25358(this.font.method_27525((class_5348)message));
            this.updateX();
        }
        super.method_48579(context, i, j, f);
    }

    public boolean method_25367() {
        return this.currentStatus != 1 && super.method_25367();
    }
}

