/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.gui.widget;

import com.google.common.collect.Lists;
import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.gui.screen.WorldHostScreen;
import io.github.gaming32.worldhost.plugin.FriendListFriend;
import io.github.gaming32.worldhost.plugin.ProfileInfo;
import io.github.gaming32.worldhost.toast.IconRenderer;
import io.github.gaming32.worldhost.versions.WorldHostRenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6382;
import net.minecraft.class_9017;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UserListWidget
extends class_9017 {
    private final List<UserInfo> users = new ArrayList<UserInfo>();
    private final List<ActionButtonWrapper> actionButtons = new ArrayList<ActionButtonWrapper>();
    private final List<? extends class_364> children = Lists.transform(this.actionButtons, ActionButtonWrapper::button);
    private final class_327 font;
    private final Function<FriendListFriend, List<Action>> getApplicableActions;

    public UserListWidget(class_327 font, int x, int y, int width, int height, Function<FriendListFriend, List<Action>> getApplicableActions) {
        this(font, x, y, width, height, getApplicableActions, null);
    }

    public UserListWidget(class_327 font, int x, int y, int width, int height, Function<FriendListFriend, List<Action>> getApplicableActions, @Nullable UserListWidget old) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.font = font;
        this.getApplicableActions = getApplicableActions;
        if (old != null && !old.users.isEmpty()) {
            this.users.addAll(old.users);
            this.addButtons(0);
        }
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float partialTick) {
        WorldHostScreen.pose(context).method_22903();
        context.method_44379(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759);
        WorldHostScreen.pose(context).method_22904(0.0, -this.method_44387(), 0.0);
        Objects.requireNonNull(this.font);
        int textYOffset = 10 - 9 / 2;
        int x = this.method_46426();
        int y = this.method_46427();
        for (int i = 0; i < this.getVisibleCount(); ++i) {
            UserInfo user = this.users.get(i);
            user.getIcon().draw(context, x, y, 20, 20);
            WorldHostRenderSystem.disableBlend();
            class_2561 unclippedName = user.getUnclippedName();
            if (user.nameNeedsClipping(unclippedName)) {
                WorldHostScreen.drawString(context, this.font, user.clipName(unclippedName), x + 24, y + textYOffset, 0xFFFFFF, true);
                if (mouseX >= x + 24 && mouseX <= x + 24 + user.getMaxNameWidth() && mouseY >= y && mouseY <= y + 20) {
                    context.method_51438(this.font, unclippedName, mouseX, mouseY);
                }
            } else {
                WorldHostScreen.drawString(context, this.font, unclippedName, x + 24, y + textYOffset, 0xFFFFFF, true);
            }
            y += 24;
        }
        WorldHostScreen.pose(context).method_22909();
        for (ActionButtonWrapper button : this.actionButtons) {
            button.button.method_48229(button.baseX - (this.method_44392() ? 10 : 0), button.baseY - (int)this.method_44387());
            button.button.method_25394(context, mouseX, mouseY, partialTick);
        }
        context.method_44380();
        this.method_44396(context);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public int getUsersCount() {
        return this.users.size();
    }

    public void clearUsers() {
        this.users.clear();
        this.actionButtons.clear();
    }

    public void setUsers(List<? extends FriendListFriend> users) {
        this.users.clear();
        this.actionButtons.clear();
        this.addUsers(users);
    }

    public void addUsers(List<? extends FriendListFriend> users) {
        int oldSize = this.users.size();
        for (FriendListFriend friendListFriend : users) {
            this.users.add(new UserInfo(friendListFriend));
        }
        this.addButtons(oldSize);
    }

    public void addUser(FriendListFriend user) {
        this.users.add(new UserInfo(user));
        this.addButtons(this.users.size() - 1);
    }

    private void addButtons(int fromI) {
        int y = this.method_46427() + fromI * 24;
        for (int i = fromI; i < this.getVisibleCount(); ++i) {
            UserInfo user = this.users.get(i);
            int x = this.method_55442() - 24 * user.actions.size() + 4;
            for (Action action : user.actions) {
                this.actionButtons.add(new ActionButtonWrapper(WorldHostScreen.button(action.text, b -> action.apply.run()).tooltip(action.tooltip).pos(x, y).size(20, 20).build(), x, y));
                x += 24;
            }
            y += 24;
        }
    }

    public int getVisibleCount() {
        return this.users.size();
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        return this.children;
    }

    protected int method_44395() {
        return 24 * this.users.size();
    }

    protected double method_44393() {
        return 12.0;
    }

    public static class_2561 getNameWithTag(FriendListFriend user, ProfileInfo profile) {
        return (class_2561)user.tag().map(component -> class_2561.method_43469((String)"world-host.friends.tagged_friend", (Object[])new Object[]{profile.name(), component})).orElseGet(() -> class_2561.method_43470((String)profile.name()));
    }

    private final class UserInfo {
        final FriendListFriend user;
        final List<Action> actions;
        private ProfileInfo profile;

        UserInfo(FriendListFriend user) {
            this.user = user;
            this.actions = UserListWidget.this.getApplicableActions.apply(user);
            this.profile = user.fallbackProfileInfo();
            ((CompletableFuture)user.profileInfo().thenAcceptAsync(ready -> {
                this.profile = ready;
            }, (Executor)class_310.method_1551())).exceptionally(t -> {
                WorldHost.LOGGER.error("Failed to request profile info for {}", (Object)user, t);
                return null;
            });
        }

        class_2561 getUnclippedName() {
            return UserListWidget.getNameWithTag(this.user, this.profile);
        }

        boolean nameNeedsClipping(class_2561 unclippedName) {
            return UserListWidget.this.font.method_27525((class_5348)unclippedName) >= this.getMaxNameWidth();
        }

        int getMaxNameWidth() {
            return UserListWidget.this.field_22758 - 24 - 24 * this.actions.size();
        }

        class_5481 clipName(class_2561 unclippedName) {
            class_5348 clipped = UserListWidget.this.font.method_1714((class_5348)unclippedName, this.getMaxNameWidth() - UserListWidget.this.font.method_27525((class_5348)class_5244.field_39678));
            return class_2477.method_10517().method_30934(class_5348.method_29433((class_5348[])new class_5348[]{clipped, class_5244.field_39678}));
        }

        IconRenderer getIcon() {
            return this.profile.iconRenderer();
        }
    }

    public record ActionButtonWrapper(class_4185 button, int baseX, int baseY) {
    }

    public record Action(class_2561 text, @Nullable class_2561 tooltip, Runnable apply) {
        public Action(class_2561 text, Runnable apply) {
            this(text, null, apply);
        }
    }
}

