/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.origincheck;

import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.origincheck.OriginChecker;
import io.github.gaming32.worldhost.origincheck.checker.GioOriginChecker;
import io.github.gaming32.worldhost.origincheck.checker.MacOriginChecker;
import io.github.gaming32.worldhost.origincheck.checker.NoopOriginChecker;
import io.github.gaming32.worldhost.origincheck.checker.WindowsOriginChecker;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_156;

public class OriginCheckers {
    public static final OriginChecker NATIVE_CHECKER = switch (class_156.method_668()) {
        case class_156.class_158.field_1133 -> {
            WindowsOriginChecker var0;
            yield var0 = new WindowsOriginChecker();
        }
        case class_156.class_158.field_1137 -> {
            MacOriginChecker var0_1 = new MacOriginChecker();
            yield var0_1;
        }
        default -> {
            try {
                GioOriginChecker var0_2 = new GioOriginChecker();
                yield var0_2;
            }
            catch (IllegalStateException e) {
                WorldHost.LOGGER.info("GIO origin checker not available", (Throwable)e);
                NoopOriginChecker var0_3 = new NoopOriginChecker();
                yield var0_3;
            }
        }
    };
    public static final List<String> STANDARD_ORIGINS = List.of("modrinth.com", "github.com", "githubusercontent.com", "maven.jemnetworks.com");

    public static boolean isStandardHost(String host) {
        int hostLength = host.length();
        for (String origin : STANDARD_ORIGINS) {
            if (host.equals(origin)) {
                return true;
            }
            int originLength = origin.length();
            if (hostLength <= originLength || !host.endsWith(origin) || host.charAt(hostLength - originLength - 1) != '.') continue;
            return true;
        }
        return false;
    }

    public static boolean hasStandardOrigin(URI uri) {
        return OriginCheckers.isStandardHost(uri.getHost());
    }

    public static List<URI> getNonstandardOrigins(List<URI> uris) {
        return uris.stream().filter(Predicate.not(OriginCheckers::hasStandardOrigin)).toList();
    }

    public static List<URI> getNonstandardOrigins(OriginChecker checker, Path file) {
        return OriginCheckers.getNonstandardOrigins(checker.findOrigins(file));
    }

    public static List<URI> getNonstandardOriginsOnce(OriginChecker checker, Path file) {
        if (!checker.needsChecking(file)) {
            return List.of();
        }
        List<URI> result = OriginCheckers.getNonstandardOrigins(checker, file);
        checker.markChecked(file);
        return result;
    }
}

