/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.origincheck.checker;

import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.origincheck.OriginChecker;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

abstract class AbstractOriginChecker
implements OriginChecker {
    AbstractOriginChecker() {
    }

    abstract String getCheckedMarker();

    abstract String getOriginAttributeName();

    abstract List<@Nullable String> parseOrigins(ByteBuffer var1) throws Exception;

    @Override
    public boolean needsChecking(Path file) {
        UserDefinedFileAttributeView attributes = Files.getFileAttributeView(file, UserDefinedFileAttributeView.class, new LinkOption[0]);
        if (attributes == null) {
            return false;
        }
        try {
            return !attributes.list().contains(this.getCheckedMarker());
        }
        catch (IOException e) {
            WorldHost.LOGGER.error("Failed to check for {} on {}", new Object[]{this.getCheckedMarker(), file, e});
            return false;
        }
    }

    @Override
    public List<URI> findOrigins(Path file) {
        UserDefinedFileAttributeView attributes = Files.getFileAttributeView(file, UserDefinedFileAttributeView.class, new LinkOption[0]);
        if (attributes == null) {
            return List.of();
        }
        try {
            if (!attributes.list().contains(this.getOriginAttributeName())) {
                return List.of();
            }
            ByteBuffer bb = ByteBuffer.allocate(attributes.size(this.getOriginAttributeName()));
            attributes.read(this.getOriginAttributeName(), bb);
            bb.flip();
            return this.toUriList(this.parseOrigins(bb));
        }
        catch (Exception e) {
            WorldHost.LOGGER.error("Failed to read {} on {}", new Object[]{this.getOriginAttributeName(), file, e});
            return List.of();
        }
    }

    private List<URI> toUriList(List<@Nullable String> uris) {
        ArrayList<URI> result = new ArrayList<URI>(uris.size());
        for (String url : uris) {
            if (url == null) continue;
            try {
                result.add(new URI(url));
            }
            catch (URISyntaxException e) {
                WorldHost.LOGGER.warn("Failed to parse {} URL {}", new Object[]{this.getOriginAttributeName(), url, e});
            }
        }
        return result;
    }

    @Override
    public void markChecked(Path file) {
        UserDefinedFileAttributeView attributes = Files.getFileAttributeView(file, UserDefinedFileAttributeView.class, new LinkOption[0]);
        if (attributes == null) {
            return;
        }
        try {
            attributes.write(this.getCheckedMarker(), ByteBuffer.allocate(0));
        }
        catch (IOException e) {
            WorldHost.LOGGER.error("Failed to write {} on {}", new Object[]{this.getCheckedMarker(), file, e});
        }
    }
}

