/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.origincheck.checker;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.origincheck.OriginChecker;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class GioOriginChecker
implements OriginChecker {
    private static final String CHECKED_MARKER = "metadata::world-host-origin-checked";
    private static final String DOWNLOAD_URI = "metadata::download-uri";
    private final Gio gio;

    public GioOriginChecker() throws IllegalStateException {
        try {
            this.gio = (Gio)Native.load((String)"gio-2.0", Gio.class);
        }
        catch (UnsatisfiedLinkError e) {
            throw new IllegalStateException("Gio library not available", e);
        }
    }

    @Override
    public boolean needsChecking(Path file) {
        return this.doWithInfo(file, CHECKED_MARKER, false, (gioFile, info) -> this.gio.g_file_info_get_attribute_string((Pointer)info, CHECKED_MARKER) == null);
    }

    @Override
    public List<URI> findOrigins(Path file) {
        String uri = this.doWithInfo(file, DOWNLOAD_URI, null, (gioFile, info) -> this.gio.g_file_info_get_attribute_string((Pointer)info, DOWNLOAD_URI));
        if (uri == null) {
            return List.of();
        }
        try {
            return List.of(new URI(uri));
        }
        catch (URISyntaxException e) {
            WorldHost.LOGGER.warn("Failed to parse {} URI {}", new Object[]{DOWNLOAD_URI, uri, e});
            return List.of();
        }
    }

    @Override
    public void markChecked(Path file) {
        this.doWithInfo(file, "", (gioFile, info) -> {
            this.gio.g_file_info_set_attribute_string((Pointer)info, CHECKED_MARKER, "");
            if (!this.gio.g_file_set_attributes_from_info((Pointer)gioFile, (Pointer)info, 0, null, null)) {
                WorldHost.LOGGER.warn("Failed to set {} on {}", (Object)CHECKED_MARKER, (Object)file);
            }
        });
    }

    private void doWithInfo(Path file, String attributes, BiConsumer<Pointer, Pointer> action) {
        this.doWithInfo(file, attributes, null, (gioFile, info) -> {
            action.accept((Pointer)gioFile, (Pointer)info);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doWithInfo(Path file, String attributes, T defaultValue, BiFunction<Pointer, Pointer, T> action) {
        if (file.getFileSystem() != FileSystems.getDefault()) {
            return defaultValue;
        }
        Pointer gioFile = this.gio.g_file_new_for_path(file.toString());
        try {
            T t;
            Pointer info = this.gio.g_file_query_info(gioFile, attributes, 0, null, null);
            if (info == null) {
                T t2 = defaultValue;
                return t2;
            }
            try {
                t = action.apply(gioFile, info);
            }
            catch (Throwable throwable) {
                Native.free((long)Pointer.nativeValue((Pointer)info));
                throw throwable;
            }
            Native.free((long)Pointer.nativeValue((Pointer)info));
            return t;
        }
        finally {
            Native.free((long)Pointer.nativeValue((Pointer)gioFile));
        }
    }

    private static interface Gio
    extends Library {
        public Pointer g_file_new_for_path(String var1);

        public Pointer g_file_query_info(Pointer var1, String var2, int var3, Pointer var4, Pointer var5);

        public String g_file_info_get_attribute_string(Pointer var1, String var2);

        public void g_file_info_set_attribute_string(Pointer var1, String var2, String var3);

        public boolean g_file_set_attributes_from_info(Pointer var1, Pointer var2, int var3, Pointer var4, Pointer var5);
    }
}

