/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.origincheck.checker;

import io.github.gaming32.worldhost.origincheck.checker.AbstractOriginChecker;
import io.github.gaming32.worldhost.origincheck.parser.SimpleBplistParser;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;

public class MacOriginChecker
extends AbstractOriginChecker {
    @Override
    String getCheckedMarker() {
        return "io.github.gaming32.worldhost:originChecked";
    }

    @Override
    String getOriginAttributeName() {
        return "com.apple.metadata:kMDItemWhereFroms";
    }

    @Override
    List<String> parseOrigins(ByteBuffer bb) {
        Object bplist = SimpleBplistParser.parseBplist(bb);
        if (!(bplist instanceof Collection)) {
            return List.of();
        }
        Collection collection = (Collection)bplist;
        return collection.stream().filter(String.class::isInstance).map(String.class::cast).toList();
    }
}

