/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.origincheck.parser;

import it.unimi.dsi.fastutil.bytes.Byte2LongFunction;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.IntFunction;
import net.minecraft.class_156;

public class SimpleBplistParser {
    private static final long CORE_DATA_EPOCH = (Long)class_156.method_656(() -> {
        Calendar calender = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ROOT);
        calender.set(2001, 0, 1, 0, 0, 0);
        return calender.getTimeInMillis() / 1000L;
    });
    private static final int TYPE_SIMPLE = 0;
    private static final int TYPE_INT = 1;
    private static final int TYPE_REAL = 2;
    private static final int TYPE_DATE = 3;
    private static final int TYPE_DATA = 4;
    private static final int TYPE_ASCII = 5;
    private static final int TYPE_UNICODE = 6;
    private static final int TYPE_UTF8 = 7;
    private static final int TYPE_UID = 8;
    private static final int TYPE_ARRAY = 10;
    private static final int TYPE_ORDSET = 11;
    private static final int TYPE_SET = 12;
    private static final int TYPE_DICT = 13;
    private static final int SIMPLE_NULL = 0;
    private static final int SIMPLE_FALSE = 8;
    private static final int SIMPLE_TRUE = 9;
    private static final int SIMPLE_URL = 12;
    private static final int SIMPLE_URL_WITH_BASE = 13;
    private static final int SIMPLE_UUID = 14;
    private static final int SIMPLE_FILL = 15;
    private static final byte[] MAGIC = "bplist".getBytes(StandardCharsets.US_ASCII);
    private final ByteBuffer data;
    private final int[] offsets;
    private final int refSize;
    private final int rootObject;
    private final Map<Charset, CharsetDecoder> decoderCache = HashMap.newHashMap(3);

    private SimpleBplistParser(ByteBuffer data) {
        this.data = data;
        data.position(data.limit() - 32 + 6);
        int offsetSize = data.get() & 0xFF;
        this.refSize = data.get() & 0xFF;
        this.offsets = new int[(int)data.getLong()];
        this.rootObject = (int)data.getLong();
        int offsetTableStart = (int)data.getLong();
        this.readOffsetTable(offsetTableStart, offsetSize);
    }

    public static Object parseBplist(ByteBuffer data) {
        data.order(ByteOrder.BIG_ENDIAN);
        data.position(0);
        byte[] magic = new byte[MAGIC.length];
        data.get(magic);
        if (!Arrays.equals(magic, MAGIC)) {
            throw new IllegalArgumentException("Not a bplist file");
        }
        data.get();
        data.get();
        return new SimpleBplistParser(data).readRoot();
    }

    private Object readRoot() {
        return this.readObjectByIndex(this.rootObject);
    }

    private Object readObjectByIndex(int index) {
        this.data.position(this.offsets[index]);
        return this.readObject();
    }

    private Object readObject() {
        int marker = this.data.get() & 0xFF;
        int type = (marker & 0xF0) >> 4;
        int typeExtra = marker & 0xF;
        return switch (type) {
            case 0 -> {
                Boolean v0;
                switch (typeExtra) {
                    case 0: {
                        Serializable var5_4;
                        v0 = var5_4 = null;
                        break;
                    }
                    case 8: {
                        Serializable var5_4;
                        v0 = var5_4 = Boolean.valueOf(false);
                        break;
                    }
                    case 9: {
                        Serializable var5_4;
                        v0 = var5_4 = Boolean.valueOf(true);
                        break;
                    }
                    case 12: {
                        Serializable var5_4;
                        Object urlObj = this.readObject();
                        if (!(urlObj instanceof String)) {
                            throw new BplistParsingFailure("Expected url to be string");
                        }
                        String url = (String)urlObj;
                        try {
                            v0 = var5_4 = new URI(url).toURL();
                            break;
                        }
                        catch (MalformedURLException | URISyntaxException e) {
                            throw new BplistParsingFailure("Invalid URL " + url, e);
                        }
                    }
                    case 13: {
                        throw new BplistParsingFailure("Extended url not supported");
                    }
                    case 14: {
                        Serializable var5_4;
                        v0 = var5_4 = new UUID(this.data.getLong(), this.data.getLong());
                        break;
                    }
                    case 15: {
                        throw new BplistParsingFailure("Should never parse fill byte");
                    }
                    default: {
                        throw new BplistParsingFailure("Unknown marker byte 0x" + Integer.toHexString(marker));
                    }
                }
                Boolean var4_9 = v0;
                yield var4_9;
            }
            case 1 -> {
                Long var4_10 = this.readIntObject(typeExtra);
                yield var4_10;
            }
            case 2 -> {
                Number var4_11 = this.readReal(typeExtra);
                yield var4_11;
            }
            case 3 -> {
                Date var4_12 = new Date((this.data.getLong() - CORE_DATA_EPOCH) * 1000L);
                yield var4_12;
            }
            case 4 -> {
                byte[] result = new byte[this.readSize(typeExtra)];
                this.data.get(result);
                byte[] var4_13 = result;
                yield var4_13;
            }
            case 5 -> {
                String var4_14 = this.readString(StandardCharsets.US_ASCII, typeExtra);
                yield var4_14;
            }
            case 6 -> {
                String var4_15 = this.readString(StandardCharsets.UTF_16BE, typeExtra);
                yield var4_15;
            }
            case 7 -> {
                String var4_16 = this.readString(StandardCharsets.UTF_8, typeExtra);
                yield var4_16;
            }
            case 8 -> throw new BplistParsingFailure("Unsupported object type uid");
            case 10 -> {
                ArrayList var4_17 = this.readCollection(ArrayList::new, typeExtra);
                yield var4_17;
            }
            case 11 -> {
                LinkedHashSet var4_18 = this.readCollection(LinkedHashSet::newLinkedHashSet, typeExtra);
                yield var4_18;
            }
            case 12 -> {
                HashSet var4_19 = this.readCollection(HashSet::newHashSet, typeExtra);
                yield var4_19;
            }
            case 13 -> {
                Map<?, ?> var4_20 = this.readDict(typeExtra);
                yield var4_20;
            }
            default -> throw new BplistParsingFailure("Unknown marker byte 0x" + Integer.toHexString(marker));
        };
    }

    private long readIntObject(int extra) {
        return this.readIntSigned(1 << extra);
    }

    private Number readReal(int extra) {
        long bits = this.readIntObject(extra);
        return switch (extra) {
            case 2 -> Float.valueOf(Float.intBitsToFloat((int)bits));
            case 3 -> Double.longBitsToDouble(bits);
            default -> throw new BplistParsingFailure("Unsupported real size 2^" + extra);
        };
    }

    private String readString(Charset charset, int extra) {
        CharsetDecoder decoder = this.decoderCache.computeIfAbsent(charset, c -> c.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE)).reset();
        CharBuffer result = CharBuffer.allocate(this.readSize(extra));
        decoder.decode(this.data, result, true);
        if (result.remaining() > 0) {
            throw new BplistParsingFailure("Failed to read entire string (" + result.remaining() + " unread)");
        }
        return result.flip().toString();
    }

    private <C extends Collection<Object>> C readCollection(IntFunction<C> factory, int extra) {
        int size = this.readSize(extra);
        Collection result = (Collection)factory.apply(size);
        int pos = this.data.position();
        for (int i = 0; i < size; ++i) {
            result.add(this.readObjectByIndex((int)this.readIntUnsigned(this.refSize)));
            this.data.position(pos += this.refSize);
        }
        return (C)result;
    }

    private Map<?, ?> readDict(int extra) {
        int i;
        int size = this.readSize(extra);
        Object[] keys = new Object[size];
        Object[] values = new Object[size];
        int pos = this.data.position();
        for (i = 0; i < size; ++i) {
            keys[i] = this.readObjectByIndex((int)this.readIntUnsigned(this.refSize));
            this.data.position(pos += this.refSize);
        }
        for (i = 0; i < size; ++i) {
            values[i] = this.readObjectByIndex((int)this.readIntUnsigned(this.refSize));
            this.data.position(pos += this.refSize);
        }
        HashMap<Object, Object> result = HashMap.newHashMap(size);
        for (int i2 = 0; i2 < size; ++i2) {
            result.put(keys[i2], values[i2]);
        }
        return result;
    }

    private int readSize(int extra) {
        if (extra != 15) {
            return extra;
        }
        return (int)this.readIntObject(this.data.get() & 0xF);
    }

    private void readOffsetTable(int offsetTableStart, int offsetSize) {
        this.data.position(offsetTableStart);
        for (int i = 0; i < this.offsets.length; ++i) {
            this.offsets[i] = (int)this.readIntUnsigned(offsetSize);
        }
    }

    private long readIntUnsigned(int size) {
        return this.readInt(size, x -> (long)x & 0xFFL);
    }

    private long readIntSigned(int size) {
        return this.readInt(size, x -> x);
    }

    private long readInt(int size, Byte2LongFunction starter) {
        if (size < 1) {
            throw new IllegalArgumentException("Size < 1");
        }
        long result = starter.get(this.data.get());
        for (int i = 1; i < size; ++i) {
            result = result << 8 | (long)(this.data.get() & 0xFF);
        }
        return result;
    }

    public static class BplistParsingFailure
    extends RuntimeException {
        private static final long serialVersionUID = -5280726282273772182L;

        public BplistParsingFailure(String message) {
            super(message);
        }

        public BplistParsingFailure(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

