/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.plugin.vanilla;

import com.mojang.authlib.GameProfile;
import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.plugin.FriendAdder;
import io.github.gaming32.worldhost.plugin.FriendListFriend;
import io.github.gaming32.worldhost.plugin.vanilla.WorldHostFriendListFriend;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_4844;

public class WorldHostFriendAdder
implements FriendAdder {
    public static final Pattern VALID_USERNAME = Pattern.compile("^[a-zA-Z0-9_]{1,16}$");
    public static final Pattern VALID_UUID = Pattern.compile("^[a-z0-9]{8}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{4}-[a-z0-9]{12}$");

    @Override
    public class_2561 label() {
        return class_2561.method_43470((String)"World Host");
    }

    @Override
    public void searchFriends(String name, int maxResults, Consumer<FriendListFriend> friendConsumer) {
        if (VALID_USERNAME.matcher(name).matches()) {
            WorldHost.getMaybeAsync(WorldHost.getProfileCache(), name, profile -> profile.map(WorldHostFriendListFriend::new).ifPresent(friendConsumer));
        } else if (VALID_UUID.matcher(name).matches()) {
            friendConsumer.accept(new WorldHostFriendListFriend(UUID.fromString(name)));
        } else if (name.startsWith("o:")) {
            String actualName = name.substring(2);
            friendConsumer.accept(new WorldHostFriendListFriend(new GameProfile(class_4844.method_43344((String)actualName), actualName)));
        }
    }

    @Override
    public boolean delayLookup(String name) {
        return !VALID_UUID.matcher(name).matches() && !name.startsWith("o:");
    }

    @Override
    public int maxValidNameLength() {
        return 36;
    }
}

