/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.protocol;

import com.google.common.net.HostAndPort;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.ForcedUsernameChangeException;
import com.mojang.authlib.exceptions.InsufficientPrivilegesException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.exceptions.UserBannedException;
import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.protocol.WorldHostC2SMessage;
import io.github.gaming32.worldhost.protocol.WorldHostS2CMessage;
import io.github.gaming32.worldhost.protocol.proxy.ProxyPassthrough;
import io.github.gaming32.worldhost.toast.WHToast;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.net.SocketException;
import java.security.Key;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_320;
import net.minecraft.class_3515;
import net.minecraft.class_5525;
import org.apache.commons.io.input.BoundedInputStream;
import org.jetbrains.annotations.Nullable;

public final class ProtocolClient
implements AutoCloseable,
ProxyPassthrough {
    private static final Thread.Builder CONNECTION_THREAD_BUILDER = Thread.ofVirtual().name("WH-ConnectionThread-", 1L);
    private static final Thread.Builder SEND_THREAD_BUILDER = Thread.ofVirtual().name("WH-SendThread-", 1L);
    private static final Thread.Builder RECV_THREAD_BUILDER = Thread.ofVirtual().name("WH-RecvThread-", 1L);
    public static final int PROTOCOL_VERSION = 7;
    private static final int KEY_PREFIX = -84279296;
    private final String originalHost;
    private HostAndPort hostAndPort;
    final CompletableFuture<Void> connectingFuture = new CompletableFuture();
    private final BlockingQueue<Optional<WorldHostC2SMessage>> sendQueue = new LinkedBlockingQueue<Optional<WorldHostC2SMessage>>();
    private final CompletableFuture<Void> shutdownFuture = new CompletableFuture();
    private CompletableFuture<class_320> authUser = new CompletableFuture();
    private boolean authenticated;
    private boolean closed;
    private long connectionId = WorldHost.CONNECTION_ID;
    private String baseIp = "";
    private int basePort;
    private String userIp = "";
    private int punchPort;
    @Nullable
    private Long attemptingToJoin;

    public ProtocolClient(String host, boolean successToast, boolean failureToast) {
        this.originalHost = host;
        CONNECTION_THREAD_BUILDER.start(() -> {
            block13: {
                Cipher encryptCipher;
                Cipher decryptCipher;
                Socket socket;
                block11: {
                    socket = null;
                    decryptCipher = null;
                    encryptCipher = null;
                    try {
                        this.hostAndPort = HostAndPort.fromString((String)host).withDefaultPort(9646);
                        socket = new Socket(this.hostAndPort.getHost(), this.hostAndPort.getPort());
                        class_320 user = this.authUser.join();
                        this.authUser = null;
                        SecretKey secretKey = ProtocolClient.performHandshake(socket, user, this.connectionId);
                        decryptCipher = class_3515.method_15235((int)2, (Key)secretKey);
                        encryptCipher = class_3515.method_15235((int)1, (Key)secretKey);
                    }
                    catch (Exception e) {
                        block12: {
                            WorldHost.LOGGER.error("Failed to connect to {} ({}).", new Object[]{this.originalHost, this.hostAndPort, e});
                            if (failureToast) {
                                WHToast.builder("world-host.wh_connect.connect_failed").description(class_2561.method_30163((String)e.getLocalizedMessage())).show();
                            }
                            if (socket == null) break block11;
                            try {
                                socket.close();
                            }
                            catch (IOException e1) {
                                WorldHost.LOGGER.error("Failed to close WH socket", (Throwable)e1);
                                if (!failureToast) break block12;
                                WHToast.builder("world-host.wh_connect.close_failed").description(class_2561.method_30163((String)e1.getLocalizedMessage())).show();
                            }
                        }
                        socket = null;
                    }
                }
                if (socket == null) {
                    this.close();
                    return;
                }
                if (successToast) {
                    WHToast.builder("world-host.wh_connect.connected").show();
                }
                Socket fSocket = socket;
                Cipher fDecryptCipher = decryptCipher;
                Cipher fEncryptCipher = encryptCipher;
                Thread sendThread = SEND_THREAD_BUILDER.start(() -> {
                    try {
                        Optional<WorldHostC2SMessage> optionalMessage;
                        DataOutputStream dos = new DataOutputStream(new CipherOutputStream(fSocket.getOutputStream(), fEncryptCipher));
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        DataOutputStream tempDos = new DataOutputStream(baos);
                        while (!this.closed && !(optionalMessage = this.sendQueue.take()).isEmpty()) {
                            WorldHostC2SMessage message = optionalMessage.get();
                            message.encode(tempDos);
                            dos.writeInt(baos.size() + 1);
                            dos.writeByte(message.typeId() & 0xFF);
                            dos.write(baos.toByteArray());
                            baos.reset();
                            dos.flush();
                        }
                    }
                    catch (IOException e) {
                        WorldHost.LOGGER.error("Disconnected from WH server in send thread", (Throwable)e);
                    }
                    catch (Exception e) {
                        WorldHost.LOGGER.error("Critical error in WH send thread", (Throwable)e);
                    }
                    this.close();
                });
                RECV_THREAD_BUILDER.start(() -> {
                    block8: {
                        try {
                            DataInputStream dis = new DataInputStream(new CipherInputStream(fSocket.getInputStream(), fDecryptCipher));
                            while (!this.closed) {
                                int length = dis.readInt() - 1;
                                if (length < 0) {
                                    WorldHost.LOGGER.warn("Received invalid empty packet from WH server");
                                    continue;
                                }
                                int typeId = dis.readUnsignedByte();
                                BoundedInputStream is = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream((InputStream)dis)).setPropagateClose(false)).setMaxCount((long)length)).get();
                                WorldHostS2CMessage message = null;
                                try {
                                    message = WorldHostS2CMessage.decode(typeId, new DataInputStream((InputStream)is));
                                }
                                catch (EOFException e) {
                                    WorldHost.LOGGER.error("Message decoder for message {} read past end (length {})!", (Object)typeId, (Object)length);
                                }
                                catch (Exception e) {
                                    WorldHost.LOGGER.error("Error decoding WH message", (Throwable)e);
                                }
                                if (is.getCount() < (long)length) {
                                    WorldHost.LOGGER.warn("Didn't read entire message (read: {}, total: {}, message: {})", new Object[]{is.getCount(), length, message});
                                    dis.skipNBytes((long)length - is.getCount());
                                }
                                if (message == null) continue;
                                WorldHost.LOGGER.debug("Received {}", (Object)message);
                                message.handle(this);
                            }
                        }
                        catch (Exception e) {
                            if (e instanceof SocketException && e.getMessage().equals("Socket closed")) break block8;
                            WorldHost.LOGGER.error("Critical error in WH recv thread", (Throwable)e);
                        }
                    }
                    this.close();
                });
                try {
                    sendThread.join();
                }
                catch (InterruptedException e) {
                    WorldHost.LOGGER.error("{} interrupted", (Object)Thread.currentThread().getName(), (Object)e);
                }
                try {
                    socket.close();
                }
                catch (IOException e) {
                    WorldHost.LOGGER.error("Failed to close WH socket.", (Throwable)e);
                    if (!WorldHost.CONFIG.isEnableReconnectionToasts()) break block13;
                    WHToast.builder("world-host.wh_connect.close_failed").description(class_2561.method_30163((String)e.getLocalizedMessage())).show();
                }
            }
            this.shutdownFuture.complete(null);
        });
    }

    private static SecretKey performHandshake(Socket socket, class_320 user, long connectionId) throws IOException, class_5525 {
        String failure;
        DataOutputStream dos = new DataOutputStream(socket.getOutputStream());
        dos.writeInt(7);
        dos.flush();
        DataInputStream dis = new DataInputStream(socket.getInputStream());
        if (dis.readInt() != -84279296) {
            throw new IllegalStateException("Server does not support updated auth protocol.");
        }
        byte[] publicKeyBytes = new byte[dis.readUnsignedShort()];
        dis.readFully(publicKeyBytes);
        byte[] challenge = new byte[dis.readUnsignedShort()];
        dis.readFully(challenge);
        SecretKey secretKey = class_3515.method_15239();
        PublicKey publicKey = class_3515.method_15242((byte[])publicKeyBytes);
        String authKey = new BigInteger(class_3515.method_15240((String)"", (PublicKey)publicKey, (SecretKey)secretKey)).toString(16);
        byte[] encryptedChallenge = class_3515.method_15238((Key)publicKey, (byte[])challenge);
        dos.writeShort(encryptedChallenge.length);
        dos.write(encryptedChallenge);
        dos.flush();
        byte[] encryptedSecretKey = class_3515.method_15238((Key)publicKey, (byte[])secretKey.getEncoded());
        dos.writeShort(encryptedSecretKey.length);
        dos.write(encryptedSecretKey);
        dos.flush();
        UUID profileId = user.method_44717();
        if (profileId.version() == 4 && (failure = ProtocolClient.authenticateServer(profileId, user.method_1674(), authKey)) != null) {
            throw new IllegalStateException(failure);
        }
        WorldHostC2SMessage.writeUuid(dos, profileId);
        WorldHostC2SMessage.writeString(dos, user.method_1676());
        dos.writeLong(connectionId);
        dos.flush();
        return secretKey;
    }

    private static String authenticateServer(UUID profile, String authenticationToken, String serverId) {
        try {
            class_310.method_1551().method_1495().joinServer(profile, authenticationToken, serverId);
            return null;
        }
        catch (AuthenticationUnavailableException e) {
            return null;
        }
        catch (InvalidCredentialsException e) {
            return class_1074.method_4662((String)"disconnect.loginFailedInfo.invalidSession", (Object[])new Object[0]);
        }
        catch (InsufficientPrivilegesException e) {
            return class_1074.method_4662((String)"disconnect.loginFailedInfo.insufficientPrivileges", (Object[])new Object[0]);
        }
        catch (AuthenticationException e) {
            if (e instanceof ForcedUsernameChangeException || e instanceof UserBannedException) {
                return class_1074.method_4662((String)"disconnect.loginFailedInfo.userBanned", (Object[])new Object[0]);
            }
            return e.getMessage();
        }
    }

    public String getOriginalHost() {
        return this.originalHost;
    }

    public HostAndPort getHostAndPort() {
        return this.hostAndPort;
    }

    public void authenticate(class_320 user) {
        this.authenticated = true;
        if (this.authUser != null) {
            this.authUser.complete(user);
        }
    }

    void enqueue(WorldHostC2SMessage message) {
        if (this.closed) {
            WorldHost.LOGGER.warn("Attempted to send over closed connection: {}", (Object)message);
            return;
        }
        if (!this.authenticated) {
            throw new IllegalStateException("Attempted to communicate with server before authenticating.");
        }
        try {
            this.sendQueue.put(Optional.of(message));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void listOnline(Collection<UUID> friends) {
        this.enqueue(new WorldHostC2SMessage.ListOnline(friends));
    }

    public void publishedWorld(Collection<UUID> friends) {
        this.enqueue(new WorldHostC2SMessage.PublishedWorld(friends));
    }

    public void closedWorld(Collection<UUID> friends) {
        this.enqueue(new WorldHostC2SMessage.ClosedWorld(friends));
    }

    public void friendRequest(UUID friend) {
        this.enqueue(new WorldHostC2SMessage.FriendRequest(friend));
    }

    public void queryRequest(Collection<UUID> friends) {
        this.enqueue(new WorldHostC2SMessage.QueryRequest(friends));
    }

    @Deprecated
    public void requestJoin(UUID friend) {
        this.enqueue(new WorldHostC2SMessage.RequestJoin(friend));
    }

    @Override
    public void proxyS2CPacket(long connectionId, byte[] data) {
        this.enqueue(new WorldHostC2SMessage.ProxyS2CPacket(connectionId, data));
    }

    @Override
    public void proxyDisconnect(long connectionId) {
        this.enqueue(new WorldHostC2SMessage.ProxyDisconnect(connectionId));
    }

    public void requestDirectJoin(long connectionId) {
        this.enqueue(new WorldHostC2SMessage.RequestDirectJoin(connectionId));
    }

    public void requestPunchOpen(long targetConnection, String purpose, UUID punchId, String myHost, int myPort, String myLocalHost, int myLocalPort) {
        this.enqueue(new WorldHostC2SMessage.RequestPunchOpen(targetConnection, purpose, punchId, myHost, myPort, myLocalHost, myLocalPort));
    }

    public void punchFailed(long targetConnection, UUID punchId) {
        this.enqueue(new WorldHostC2SMessage.PunchFailed(targetConnection, punchId));
    }

    public void beginPortLookup(UUID lookupId) {
        this.enqueue(new WorldHostC2SMessage.BeginPortLookup(lookupId));
    }

    public void punchSuccess(long connectionId, UUID punchId, String host, int port) {
        this.enqueue(new WorldHostC2SMessage.PunchSuccess(connectionId, punchId, host, port));
    }

    public Future<Void> getConnectingFuture() {
        return this.connectingFuture;
    }

    public CompletableFuture<Void> getShutdownFuture() {
        return this.shutdownFuture;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(long connectionId) {
        this.connectionId = connectionId;
    }

    public String getBaseIp() {
        return this.baseIp;
    }

    public void setBaseIp(String baseIp) {
        this.baseIp = baseIp;
    }

    public int getBasePort() {
        return this.basePort;
    }

    public void setBasePort(int basePort) {
        this.basePort = basePort;
    }

    public String getUserIp() {
        return this.userIp;
    }

    public void setUserIp(String userIp) {
        this.userIp = userIp;
    }

    public int getPunchPort() {
        return this.punchPort;
    }

    public void setPunchPort(int punchPort) {
        this.punchPort = punchPort;
    }

    @Nullable
    public Long getAttemptingToJoin() {
        return this.attemptingToJoin;
    }

    public void setAttemptingToJoin(@Nullable Long attemptingToJoin) {
        this.attemptingToJoin = attemptingToJoin;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.sendQueue.add(Optional.empty());
    }
}

