/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.protocol;

import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.protocol.JoinType;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2926;

public sealed interface WorldHostC2SMessage {
    public byte typeId();

    public void encode(DataOutputStream var1) throws IOException;

    public static void writeUuid(DataOutputStream dos, UUID uuid) throws IOException {
        dos.writeLong(uuid.getMostSignificantBits());
        dos.writeLong(uuid.getLeastSignificantBits());
    }

    public static void writeString(DataOutputStream dos, String string) throws IOException {
        byte[] buf = string.getBytes(StandardCharsets.UTF_8);
        dos.writeShort(buf.length);
        dos.write(buf);
    }

    public record PunchSuccess(long connectionId, UUID punchId, String host, int port) implements WorldHostC2SMessage
    {
        @Override
        public byte typeId() {
            return 15;
        }

        @Override
        public void encode(DataOutputStream dos) throws IOException {
            dos.writeLong(this.connectionId);
            WorldHostC2SMessage.writeUuid(dos, this.punchId);
            WorldHostC2SMessage.writeString(dos, this.host);
            dos.writeShort(this.port);
        }
    }

    public record BeginPortLookup(UUID lookupId) implements WorldHostC2SMessage
    {
        @Override
        public byte typeId() {
            return 14;
        }

        @Override
        public void encode(DataOutputStream dos) throws IOException {
            WorldHostC2SMessage.writeUuid(dos, this.lookupId);
        }
    }

    public record PunchFailed(long targetConnection, UUID punchId) implements WorldHostC2SMessage
    {
        @Override
        public byte typeId() {
            return 13;
        }

        @Override
        public void encode(DataOutputStream dos) throws IOException {
            WorldHostC2SMessage.writeUuid(dos, this.punchId);
        }
    }

    public record RequestPunchOpen(long targetConnection, String purpose, UUID punchId, String myHost, int myPort, String myLocalHost, int myLocalPort) implements WorldHostC2SMessage
    {
        @Override
        public byte typeId() {
            return 12;
        }

        @Override
        public void encode(DataOutputStream dos) throws IOException {
            dos.writeLong(this.targetConnection);
            WorldHostC2SMessage.writeString(dos, this.purpose);
            WorldHostC2SMessage.writeUuid(dos, this.punchId);
            WorldHostC2SMessage.writeString(dos, this.myHost);
            dos.writeShort(this.myPort);
            WorldHostC2SMessage.writeString(dos, this.myLocalHost);
            dos.writeShort(this.myLocalPort);
        }
    }

    public record NewQueryResponse(long connectionId, class_2926 metadata) implements WorldHostC2SMessage
    {
        @Override
        public byte typeId() {
            return 11;
        }

        @Override
        public void encode(DataOutputStream dos) throws IOException {
            dos.writeLong(this.connectionId);
            class_2540 buf = WorldHost.writeServerStatus(this.metadata);
            buf.method_52959((OutputStream)dos, buf.readableBytes());
        }
    }

    public record RequestDirectJoin(long connectionId) implements WorldHostC2SMessage
    {
        @Override
        public byte typeId() {
            return 10;
        }

        @Override
        public void encode(DataOutputStream dos) throws IOException {
            dos.writeLong(this.connectionId);
        }
    }

    public record ProxyDisconnect(long connectionId) implements WorldHostC2SMessage
    {
        @Override
        public byte typeId() {
            return 9;
        }

        @Override
        public void encode(DataOutputStream dos) throws IOException {
            dos.writeLong(this.connectionId);
        }
    }

    public record ProxyS2CPacket(long connectionId, byte[] data) implements WorldHostC2SMessage
    {
        @Override
        public byte typeId() {
            return 8;
        }

        @Override
        public void encode(DataOutputStream dos) throws IOException {
            dos.writeLong(this.connectionId);
            dos.write(this.data);
        }
    }

    @Deprecated
    public record QueryResponse(long connectionId, class_2926 metadata) implements WorldHostC2SMessage
    {
        @Override
        public byte typeId() {
            return 7;
        }

        @Override
        public void encode(DataOutputStream dos) throws IOException {
            dos.writeLong(this.connectionId);
            class_2540 buf = WorldHost.writeServerStatus(this.metadata);
            dos.writeInt(buf.readableBytes());
            buf.method_52959((OutputStream)dos, buf.readableBytes());
        }
    }

    public record QueryRequest(Collection<UUID> friends) implements WorldHostC2SMessage
    {
        @Override
        public byte typeId() {
            return 6;
        }

        @Override
        public void encode(DataOutputStream dos) throws IOException {
            dos.writeInt(this.friends.size());
            for (UUID friend : this.friends) {
                WorldHostC2SMessage.writeUuid(dos, friend);
            }
        }
    }

    public record JoinGranted(long connectionId, JoinType joinType) implements WorldHostC2SMessage
    {
        @Override
        public byte typeId() {
            return 5;
        }

        @Override
        public void encode(DataOutputStream dos) throws IOException {
            dos.writeLong(this.connectionId);
            this.joinType.encode(dos);
        }
    }

    @Deprecated
    public record RequestJoin(UUID friend) implements WorldHostC2SMessage
    {
        @Override
        public byte typeId() {
            return 4;
        }

        @Override
        public void encode(DataOutputStream dos) throws IOException {
            WorldHostC2SMessage.writeUuid(dos, this.friend);
        }
    }

    public record ClosedWorld(Collection<UUID> friends) implements WorldHostC2SMessage
    {
        @Override
        public byte typeId() {
            return 3;
        }

        @Override
        public void encode(DataOutputStream dos) throws IOException {
            dos.writeInt(this.friends.size());
            for (UUID friend : this.friends) {
                WorldHostC2SMessage.writeUuid(dos, friend);
            }
        }
    }

    public record PublishedWorld(Collection<UUID> friends) implements WorldHostC2SMessage
    {
        @Override
        public byte typeId() {
            return 2;
        }

        @Override
        public void encode(DataOutputStream dos) throws IOException {
            dos.writeInt(this.friends.size());
            for (UUID friend : this.friends) {
                WorldHostC2SMessage.writeUuid(dos, friend);
            }
        }
    }

    public record FriendRequest(UUID toUser) implements WorldHostC2SMessage
    {
        @Override
        public byte typeId() {
            return 1;
        }

        @Override
        public void encode(DataOutputStream dos) throws IOException {
            WorldHostC2SMessage.writeUuid(dos, this.toUser);
        }
    }

    public record ListOnline(Collection<UUID> friends) implements WorldHostC2SMessage
    {
        @Override
        public byte typeId() {
            return 0;
        }

        @Override
        public void encode(DataOutputStream dos) throws IOException {
            dos.writeInt(this.friends.size());
            for (UUID friend : this.friends) {
                WorldHostC2SMessage.writeUuid(dos, friend);
            }
        }
    }
}

