/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.protocol;

import com.google.common.net.HostAndPort;
import com.mojang.authlib.GameProfile;
import io.github.gaming32.worldhost.FriendsListUpdate;
import io.github.gaming32.worldhost.SecurityLevel;
import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.WorldHostUpdateChecker;
import io.github.gaming32.worldhost.gui.screen.AddFriendScreen;
import io.github.gaming32.worldhost.gui.screen.FriendsScreen;
import io.github.gaming32.worldhost.gui.screen.JoiningWorldHostScreen;
import io.github.gaming32.worldhost.gui.screen.OnlineFriendsScreen;
import io.github.gaming32.worldhost.plugin.vanilla.WorldHostFriendListFriend;
import io.github.gaming32.worldhost.plugin.vanilla.WorldHostOnlineFriend;
import io.github.gaming32.worldhost.protocol.JoinType;
import io.github.gaming32.worldhost.protocol.ProtocolClient;
import io.github.gaming32.worldhost.protocol.WorldHostC2SMessage;
import io.github.gaming32.worldhost.protocol.proxy.ProxyProtocolClient;
import io.github.gaming32.worldhost.protocol.punch.PunchManager;
import io.github.gaming32.worldhost.protocol.punch.PunchReason;
import io.github.gaming32.worldhost.protocol.punch.PunchTransmitter;
import io.github.gaming32.worldhost.toast.WHToast;
import io.github.gaming32.worldhost.upnp.UPnPErrors;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executor;
import net.minecraft.class_1074;
import net.minecraft.class_1132;
import net.minecraft.class_156;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2926;
import net.minecraft.class_310;
import net.minecraft.class_419;
import net.minecraft.class_437;
import net.minecraft.class_442;

public sealed interface WorldHostS2CMessage {
    public void handle(ProtocolClient var1);

    public static WorldHostS2CMessage decode(int typeId, DataInputStream dis) throws IOException {
        return switch (typeId) {
            case 0 -> Error.decode(dis);
            case 1 -> IsOnlineTo.decode(dis);
            case 2 -> OnlineGame.decode(dis);
            case 3 -> FriendRequest.decode(dis);
            case 4 -> PublishedWorld.decode(dis);
            case 5 -> ClosedWorld.decode(dis);
            case 6 -> RequestJoin.decode(dis);
            case 7 -> QueryRequest.decode(dis);
            case 8 -> QueryResponse.decode(dis);
            case 9 -> ProxyC2SPacket.decode(dis);
            case 10 -> ProxyConnect.decode(dis);
            case 11 -> ProxyDisconnect.decode(dis);
            case 12 -> ConnectionInfo.decode(dis);
            case 13 -> ExternalProxyServer.decode(dis);
            case 14 -> OutdatedWorldHost.decode(dis);
            case 15 -> ConnectionNotFound.decode(dis);
            case 16 -> NewQueryResponse.decode(dis);
            case 17 -> Warning.decode(dis);
            case 18 -> PunchOpenRequest.decode(dis);
            case 19 -> CancelPortLookup.decode(dis);
            case 20 -> PortLookupSuccess.decode(dis);
            case 21 -> PunchRequestCancelled.decode(dis);
            case 22 -> PunchSuccess.decode(dis);
            default -> new Error("Received packet with unknown typeId from server (outdated client?): " + typeId);
        };
    }

    public static UUID readUuid(DataInputStream dis) throws IOException {
        return new UUID(dis.readLong(), dis.readLong());
    }

    public static String readString(DataInputStream dis) throws IOException {
        byte[] buf = new byte[dis.readUnsignedShort()];
        dis.readFully(buf);
        return new String(buf, StandardCharsets.UTF_8);
    }

    public record Error(String message, boolean critical) implements WorldHostS2CMessage
    {
        public static final int ID = 0;

        public Error(String message) {
            this(message, false);
        }

        public static Error decode(DataInputStream dis) throws IOException {
            return new Error(WorldHostS2CMessage.readString(dis), dis.read() > 0);
        }

        @Override
        public void handle(ProtocolClient client) {
            if (this.critical) {
                WHToast.builder("world-host.protocol_error_occurred").description((class_2561)class_2561.method_43470((String)this.message)).show();
                throw new RuntimeException(this.message);
            }
            WorldHost.LOGGER.error("Received protocol error: {}", (Object)this.message);
        }
    }

    public record IsOnlineTo(UUID user) implements WorldHostS2CMessage
    {
        public static final int ID = 1;

        public static IsOnlineTo decode(DataInputStream dis) throws IOException {
            return new IsOnlineTo(WorldHostS2CMessage.readUuid(dis));
        }

        @Override
        public void handle(ProtocolClient client) {
            class_1132 server;
            if (WorldHost.isFriend(this.user) && (server = class_310.method_1551().method_1576()) != null && server.method_3860()) {
                client.publishedWorld(List.of(this.user));
            }
        }
    }

    public record OnlineGame(String host, int port, long ownerCid, boolean isPunchProtocol) implements WorldHostS2CMessage
    {
        public static final int ID = 2;

        public static OnlineGame decode(DataInputStream dis) throws IOException {
            return new OnlineGame(WorldHostS2CMessage.readString(dis), dis.readUnsignedShort(), dis.readLong(), dis.readBoolean());
        }

        @Override
        public void handle(ProtocolClient client) {
            class_310.method_1551().execute(() -> {
                Long attemptingToJoin = client.getAttemptingToJoin();
                if (attemptingToJoin == null || this.ownerCid != attemptingToJoin) {
                    return;
                }
                class_310 minecraft = class_310.method_1551();
                assert (minecraft.field_1755 != null);
                if (this.isPunchProtocol) {
                    WorldHost.LOGGER.error("Punch is not supported!");
                } else {
                    WorldHost.connect(new OnlineFriendsScreen((class_437)new class_442()), this.ownerCid, this.host, this.port);
                }
            });
        }
    }

    public record FriendRequest(UUID fromUser, SecurityLevel security) implements WorldHostS2CMessage,
    SecurityCheckable
    {
        public static final int ID = 3;

        public static FriendRequest decode(DataInputStream dis) throws IOException {
            return new FriendRequest(WorldHostS2CMessage.readUuid(dis), SecurityLevel.byId(dis.readUnsignedByte()));
        }

        @Override
        public void handle(ProtocolClient client) {
            if (!WorldHost.CONFIG.isEnableFriends() || !this.checkAndLogSecurity()) {
                return;
            }
            boolean isFriend = WorldHost.isFriend(this.fromUser);
            if (isFriend) {
                class_310.method_1551().execute(() -> {
                    class_1132 server = class_310.method_1551().method_1576();
                    if (server != null && server.method_3860()) {
                        client.publishedWorld(Collections.singleton(this.fromUser));
                    }
                });
            }
            if (!isFriend && !WorldHost.CONFIG.isAllowFriendRequests()) {
                return;
            }
            WorldHost.showFriendOrOnlineToast(WorldHost.resolveProfileInfo(new GameProfile(this.fromUser, "")), isFriend ? "world-host.friend_added_you.already" : "world-host.friend_added_you", isFriend ? "world-host.friend_added_you.already.desc" : "world-host.need_add_back", isFriend ? 100 : 200, isFriend ? null : () -> {
                class_310 minecraft = class_310.method_1551();
                minecraft.method_1507((class_437)new AddFriendScreen(minecraft.field_1755, FriendsScreen.ADD_FRIEND_TEXT, new WorldHostFriendListFriend(this.fromUser), (friend, notify) -> friend.addFriend((boolean)notify, () -> {})));
            });
        }
    }

    public record PublishedWorld(UUID user, long connectionId, SecurityLevel security) implements WorldHostS2CMessage,
    SecurityCheckable
    {
        public static final int ID = 4;

        public static PublishedWorld decode(DataInputStream dis) throws IOException {
            return new PublishedWorld(WorldHostS2CMessage.readUuid(dis), dis.readLong(), SecurityLevel.byId(dis.readUnsignedByte()));
        }

        @Override
        public void handle(ProtocolClient client) {
            if (!this.checkAndLogSecurity() || !WorldHost.isFriend(this.user)) {
                return;
            }
            class_310.method_1551().execute(() -> WorldHost.friendWentOnline(new WorldHostOnlineFriend(this.user, this.connectionId, this.security)));
        }
    }

    public record ClosedWorld(UUID user) implements WorldHostS2CMessage
    {
        public static final int ID = 5;

        public static ClosedWorld decode(DataInputStream dis) throws IOException {
            return new ClosedWorld(WorldHostS2CMessage.readUuid(dis));
        }

        @Override
        public void handle(ProtocolClient client) {
            WorldHost.ONLINE_FRIENDS.remove(this.user);
            WorldHost.ONLINE_FRIEND_PINGS.remove(this.user);
            WorldHost.ONLINE_FRIEND_UPDATES.forEach(FriendsListUpdate::friendsListUpdate);
        }
    }

    public record RequestJoin(UUID user, long connectionId, SecurityLevel security) implements WorldHostS2CMessage,
    SecurityCheckable
    {
        public static final int ID = 6;

        public static RequestJoin decode(DataInputStream dis) throws IOException {
            return new RequestJoin(WorldHostS2CMessage.readUuid(dis), dis.readLong(), SecurityLevel.byId(dis.readUnsignedByte()));
        }

        @Override
        public void handle(ProtocolClient client) {
            if (!this.checkAndLogSecurity()) {
                return;
            }
            class_1132 server = class_310.method_1551().method_1576();
            if (server == null || !server.method_3860()) {
                return;
            }
            JoinType joinType = JoinType.Proxy.INSTANCE;
            if (WorldHost.isFriend(this.user) && WorldHost.upnpGateway != null && WorldHost.CONFIG.isUPnP()) {
                try {
                    UPnPErrors.AddPortMappingErrors error = WorldHost.upnpGateway.openPort(server.method_3756(), 60, false);
                    if (error == null) {
                        joinType = new JoinType.UPnP(server.method_3756());
                    } else {
                        WorldHost.LOGGER.info("Failed to use UPnP mode due to {}. Falling back to Proxy mode.", (Object)error);
                    }
                }
                catch (Exception e) {
                    WorldHost.LOGGER.error("Failed to open UPnP due to exception", (Throwable)e);
                }
            }
            client.enqueue(new WorldHostC2SMessage.JoinGranted(this.connectionId, joinType));
        }
    }

    public record QueryRequest(UUID friend, long connectionId, SecurityLevel security) implements WorldHostS2CMessage,
    SecurityCheckable
    {
        public static final int ID = 7;

        public static QueryRequest decode(DataInputStream dis) throws IOException {
            return new QueryRequest(WorldHostS2CMessage.readUuid(dis), dis.readLong(), SecurityLevel.byId(dis.readUnsignedByte()));
        }

        @Override
        public void handle(ProtocolClient client) {
            if (!this.checkAndLogSecurity() || !WorldHost.isFriend(this.friend)) {
                return;
            }
            class_1132 server = class_310.method_1551().method_1576();
            if (server != null) {
                client.enqueue(new WorldHostC2SMessage.NewQueryResponse(this.connectionId, server.method_3765()));
            }
        }
    }

    public record QueryResponse(UUID friend, class_2926 metadata) implements WorldHostS2CMessage
    {
        public static final int ID = 8;

        public static QueryResponse decode(DataInputStream dis) throws IOException {
            class_2926 serverStatus;
            UUID friend = WorldHostS2CMessage.readUuid(dis);
            class_2540 buf = WorldHost.createByteBuf();
            buf.writeBytes((InputStream)dis, dis.readInt());
            try {
                serverStatus = WorldHost.parseServerStatus(buf);
            }
            catch (Exception e) {
                WorldHost.LOGGER.error("Failed to parse server status", (Throwable)e);
                serverStatus = WorldHost.createEmptyServerStatus();
            }
            return new QueryResponse(friend, serverStatus);
        }

        @Override
        public void handle(ProtocolClient client) {
            if (WorldHost.isFriend(this.friend)) {
                WorldHost.ONLINE_FRIEND_PINGS.put(this.friend, this.metadata);
            }
        }
    }

    public record ProxyC2SPacket(long connectionId, byte[] data) implements WorldHostS2CMessage
    {
        public static final int ID = 9;

        public static ProxyC2SPacket decode(DataInputStream dis) throws IOException {
            return new ProxyC2SPacket(dis.readLong(), dis.readAllBytes());
        }

        @Override
        public void handle(ProtocolClient client) {
            WorldHost.proxyPacket(this.connectionId, this.data);
        }
    }

    public record ProxyConnect(long connectionId, InetAddress remoteAddr) implements WorldHostS2CMessage
    {
        public static final int ID = 10;

        public static ProxyConnect decode(DataInputStream dis) throws IOException {
            return new ProxyConnect(dis.readLong(), InetAddress.getByAddress(dis.readNBytes(dis.readUnsignedByte())));
        }

        @Override
        public void handle(ProtocolClient client) {
            WorldHost.proxyConnect(this.connectionId, this.remoteAddr, () -> WorldHost.protoClient);
        }
    }

    public record ProxyDisconnect(long connectionId) implements WorldHostS2CMessage
    {
        public static final int ID = 11;

        public static ProxyDisconnect decode(DataInputStream dis) throws IOException {
            return new ProxyDisconnect(dis.readLong());
        }

        @Override
        public void handle(ProtocolClient client) {
            WorldHost.proxyDisconnect(this.connectionId);
        }
    }

    public record ConnectionInfo(long connectionId, String baseIp, int basePort, String userIp, int protocolVersion, int punchPort) implements WorldHostS2CMessage
    {
        public static final int ID = 12;

        public static ConnectionInfo decode(DataInputStream dis) throws IOException {
            return new ConnectionInfo(dis.readLong(), WorldHostS2CMessage.readString(dis), dis.readUnsignedShort(), WorldHostS2CMessage.readString(dis), dis.readInt(), dis.readUnsignedShort());
        }

        @Override
        public void handle(ProtocolClient client) {
            WorldHost.LOGGER.info("Received {}", (Object)this);
            client.connectingFuture.complete(null);
            client.setConnectionId(this.connectionId);
            client.setBaseIp(this.baseIp);
            client.setBasePort(this.basePort);
            client.setUserIp(this.userIp);
            client.setPunchPort(this.punchPort);
            if (7 < this.protocolVersion) {
                WorldHost.LOGGER.warn("Client is out of date with server! Client version: {}. Server version: {}.", (Object)7, (Object)this.protocolVersion);
            }
        }
    }

    public record ExternalProxyServer(String host, int port, String baseAddr, int mcPort) implements WorldHostS2CMessage
    {
        public static final int ID = 13;

        public static ExternalProxyServer decode(DataInputStream dis) throws IOException {
            return new ExternalProxyServer(WorldHostS2CMessage.readString(dis), dis.readUnsignedShort(), WorldHostS2CMessage.readString(dis), dis.readUnsignedShort());
        }

        @Override
        public void handle(ProtocolClient client) {
            WorldHost.LOGGER.info("Attempting to connect to WHEP server at {}, {}", (Object)this.host, (Object)this.port);
            if (WorldHost.proxyProtocolClient != null) {
                WorldHost.proxyProtocolClient.close();
            }
            WorldHost.proxyProtocolClient = new ProxyProtocolClient(this.host, this.port, client.getConnectionId(), this.baseAddr, this.mcPort);
        }
    }

    public record OutdatedWorldHost(String recommendedVersion) implements WorldHostS2CMessage
    {
        public static final int ID = 14;

        public static OutdatedWorldHost decode(DataInputStream dis) throws IOException {
            return new OutdatedWorldHost(WorldHostS2CMessage.readString(dis));
        }

        @Override
        public void handle(ProtocolClient client) {
            String currentVersion = WorldHost.getModVersion("world-host");
            WorldHost.LOGGER.info(class_1074.method_4662((String)"world-host.outdated_world_host.desc", (Object[])new Object[]{currentVersion, this.recommendedVersion + "+"}));
            if (!WorldHost.CONFIG.isShowOutdatedWorldHost()) {
                return;
            }
            WorldHostUpdateChecker.checkForUpdates().thenAcceptAsync(version -> {
                if (version.isEmpty()) {
                    return;
                }
                String updateLink = WorldHostUpdateChecker.formatUpdateLink((String)version.get());
                WHToast.builder("world-host.outdated_world_host").description((class_2561)class_2561.method_43469((String)"world-host.outdated_world_host.desc", (Object[])new Object[]{currentVersion, version.get()})).clickAction(() -> class_156.method_668().method_670(updateLink)).ticks(200).show();
            }, (Executor)class_310.method_1551());
        }
    }

    public record ConnectionNotFound(long connectionId) implements WorldHostS2CMessage
    {
        public static final int ID = 15;

        public static ConnectionNotFound decode(DataInputStream dis) throws IOException {
            return new ConnectionNotFound(dis.readLong());
        }

        @Override
        public void handle(ProtocolClient client) {
            class_310.method_1551().execute(() -> {
                if (client.getAttemptingToJoin() == null || client.getAttemptingToJoin() != this.connectionId) {
                    return;
                }
                client.setAttemptingToJoin(null);
                class_310 minecraft = class_310.method_1551();
                class_437 parentScreen = minecraft.field_1755;
                if (parentScreen instanceof JoiningWorldHostScreen) {
                    JoiningWorldHostScreen joinScreen = (JoiningWorldHostScreen)parentScreen;
                    parentScreen = joinScreen.parent;
                }
                minecraft.method_1507((class_437)new class_419(parentScreen, (class_2561)class_2561.method_43471((String)"world-host.connection_not_found"), (class_2561)class_2561.method_43469((String)"world-host.connection_not_found.desc", (Object[])new Object[]{WorldHost.connectionIdToString(this.connectionId)})));
            });
        }
    }

    public record NewQueryResponse(UUID friend, class_2926 metadata) implements WorldHostS2CMessage
    {
        public static final int ID = 16;

        public static NewQueryResponse decode(DataInputStream dis) throws IOException {
            class_2926 serverStatus;
            UUID friend = WorldHostS2CMessage.readUuid(dis);
            class_2540 buf = WorldHost.createByteBuf();
            buf.method_52983(dis.readAllBytes());
            try {
                serverStatus = WorldHost.parseServerStatus(buf);
            }
            catch (Exception e) {
                WorldHost.LOGGER.error("Failed to parse server status", (Throwable)e);
                serverStatus = WorldHost.createEmptyServerStatus();
            }
            return new NewQueryResponse(friend, serverStatus);
        }

        @Override
        public void handle(ProtocolClient client) {
            if (WorldHost.isFriend(this.friend)) {
                WorldHost.ONLINE_FRIEND_PINGS.put(this.friend, this.metadata);
            }
        }
    }

    public record Warning(String message, boolean important) implements WorldHostS2CMessage
    {
        public static final int ID = 17;

        public static Warning decode(DataInputStream dis) throws IOException {
            return new Warning(WorldHostS2CMessage.readString(dis), dis.readBoolean());
        }

        @Override
        public void handle(ProtocolClient client) {
            WorldHost.LOGGER.warn("Warning from WH server (important: {}): {}", (Object)this.important, (Object)this.message);
            WHToast.builder((class_2561)class_2561.method_43471((String)"world-host.protocol_warning_occurred")).description((class_2561)class_2561.method_43470((String)this.message)).important(this.important).show();
        }
    }

    public record PunchOpenRequest(UUID punchId, String purpose, String fromHost, int fromPort, long connectionId, UUID user, SecurityLevel security) implements WorldHostS2CMessage,
    SecurityCheckable
    {
        public static final int ID = 18;

        public static PunchOpenRequest decode(DataInputStream dis) throws IOException {
            return new PunchOpenRequest(WorldHostS2CMessage.readUuid(dis), WorldHostS2CMessage.readString(dis), WorldHostS2CMessage.readString(dis), dis.readUnsignedShort(), dis.readLong(), WorldHostS2CMessage.readUuid(dis), SecurityLevel.byId(dis.readUnsignedByte()));
        }

        @Override
        public void handle(ProtocolClient client) {
            if (!this.checkAndLogSecurity()) {
                return;
            }
            PunchReason reason = PunchReason.byId(this.purpose);
            if (reason == null) {
                WorldHost.LOGGER.warn("Punch {} from {} has unknown purpose {}", new Object[]{this.punchId, this.user, this.purpose});
                client.punchFailed(this.connectionId, this.punchId);
                return;
            }
            if (!reason.verificationType().verify(this.user)) {
                WorldHost.LOGGER.warn("Punch {} from {} failed verification (verification type {})", new Object[]{this.punchId, this.user, PunchReason.VerificationType.getName(reason.verificationType())});
                client.punchFailed(this.connectionId, this.punchId);
                return;
            }
            PunchTransmitter transmitter = reason.transmitterFinder().findServerTransmitter();
            if (transmitter == null) {
                WorldHost.LOGGER.warn("Punch {} from {} couldn't find transmitter (transmitter finder {})", new Object[]{this.punchId, this.user, reason.transmitterFinder()});
                client.punchFailed(this.connectionId, this.punchId);
                return;
            }
            class_310.method_1551().execute(() -> PunchManager.openPunchRequest(this.punchId, transmitter, this.fromHost, this.fromPort, this.connectionId));
        }
    }

    public record CancelPortLookup(UUID lookupId) implements WorldHostS2CMessage
    {
        public static final int ID = 19;

        public static CancelPortLookup decode(DataInputStream dis) throws IOException {
            return new CancelPortLookup(WorldHostS2CMessage.readUuid(dis));
        }

        @Override
        public void handle(ProtocolClient client) {
            class_310.method_1551().execute(() -> PunchManager.cancelPortLookup(this.lookupId));
        }
    }

    public record PortLookupSuccess(UUID lookupId, String host, int port) implements WorldHostS2CMessage
    {
        public static final int ID = 20;

        public static PortLookupSuccess decode(DataInputStream dis) throws IOException {
            UUID lookupId = WorldHostS2CMessage.readUuid(dis);
            return new PortLookupSuccess(lookupId, WorldHostS2CMessage.readString(dis), dis.readUnsignedShort());
        }

        @Override
        public void handle(ProtocolClient client) {
            HostAndPort hostAndPort = HostAndPort.fromParts((String)this.host, (int)this.port);
            class_310.method_1551().execute(() -> PunchManager.portLookupSuccess(this.lookupId, hostAndPort));
        }
    }

    public record PunchRequestCancelled(UUID punchId) implements WorldHostS2CMessage
    {
        public static final int ID = 21;

        public static PunchRequestCancelled decode(DataInputStream dis) throws IOException {
            return new PunchRequestCancelled(WorldHostS2CMessage.readUuid(dis));
        }

        @Override
        public void handle(ProtocolClient client) {
            class_310.method_1551().execute(() -> PunchManager.cancelPunch(this.punchId));
        }
    }

    public record PunchSuccess(UUID punchId, String host, int port) implements WorldHostS2CMessage
    {
        public static final int ID = 22;

        public static PunchSuccess decode(DataInputStream dis) throws IOException {
            return new PunchSuccess(WorldHostS2CMessage.readUuid(dis), WorldHostS2CMessage.readString(dis), dis.readUnsignedShort());
        }

        @Override
        public void handle(ProtocolClient client) {
            HostAndPort hostAndPort = HostAndPort.fromParts((String)this.host, (int)this.port);
            class_310.method_1551().execute(() -> PunchManager.punchSuccess(this.punchId, hostAndPort));
        }
    }

    public static interface SecurityCheckable {
        public SecurityLevel security();

        default public boolean checkAndLogSecurity() {
            SecurityLevel requiredLevel;
            SecurityLevel receivedLevel = this.security();
            if (receivedLevel.compareTo(requiredLevel = WorldHost.CONFIG.getRequiredSecurityLevel()) >= 0) {
                return true;
            }
            WorldHost.LOGGER.warn("Received {} from insecure client. Security is {}, but {} is required.", new Object[]{this, receivedLevel, requiredLevel});
            return false;
        }
    }
}

