/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.protocol.proxy;

import com.google.common.net.HostAndPort;
import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.protocol.proxy.ProxyMessage;
import io.github.gaming32.worldhost.protocol.proxy.ProxyPassthrough;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.Socket;
import java.net.SocketException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;

public class ProxyProtocolClient
implements AutoCloseable,
ProxyPassthrough {
    private static final Thread.Builder CONNECTION_THREAD_BUILDER = Thread.ofVirtual().name("WHEP-ConnectionThread-", 1L);
    private static final Thread.Builder SEND_THREAD_BUILDER = Thread.ofVirtual().name("WHEP-SendThread-", 1L);
    private static final Thread.Builder RECV_THREAD_BUILDER = Thread.ofVirtual().name("WHEP-RecvThread-", 1L);
    private final BlockingQueue<Optional<ProxyMessage>> sendQueue = new LinkedBlockingQueue<Optional<ProxyMessage>>();
    private final CompletableFuture<Void> shutdownFuture = new CompletableFuture();
    private final String baseAddr;
    private final int mcPort;
    private boolean closed;

    public ProxyProtocolClient(String host, int port, long connectionId, String baseAddr, int mcPort) {
        this.baseAddr = baseAddr;
        this.mcPort = mcPort;
        CONNECTION_THREAD_BUILDER.start(() -> {
            Socket socket;
            block9: {
                socket = null;
                try {
                    socket = new Socket(host, port);
                    DataOutputStream dos = new DataOutputStream(socket.getOutputStream());
                    dos.writeLong(connectionId);
                    dos.flush();
                }
                catch (Exception e) {
                    WorldHost.LOGGER.error("Failed to connect to WHEP server {}.", (Object)HostAndPort.fromParts((String)host, (int)port), (Object)e);
                    if (socket == null) break block9;
                    try {
                        socket.close();
                    }
                    catch (IOException e1) {
                        WorldHost.LOGGER.error("Failed to close WHEP socket.", (Throwable)e);
                    }
                    socket = null;
                }
            }
            if (socket == null) {
                this.closed = true;
                return;
            }
            Socket fSocket = socket;
            Thread sendThread = SEND_THREAD_BUILDER.start(() -> {
                try {
                    Optional<ProxyMessage> message;
                    DataOutputStream dos = new DataOutputStream(fSocket.getOutputStream());
                    while (!this.closed && !(message = this.sendQueue.take()).isEmpty()) {
                        dos.writeLong(message.get().getConnectionId());
                        dos.writeByte(message.get().getType());
                        message.get().write(dos);
                        dos.flush();
                    }
                }
                catch (IOException e) {
                    WorldHost.LOGGER.error("Disconnected from WHEP server in send thread.", (Throwable)e);
                }
                catch (Exception e) {
                    WorldHost.LOGGER.error("Critical error in WHEP send thread", (Throwable)e);
                }
                this.closed = true;
            });
            RECV_THREAD_BUILDER.start(() -> {
                block8: {
                    try {
                        DataInputStream dis = new DataInputStream(fSocket.getInputStream());
                        block7: while (!this.closed) {
                            ProxyMessage selector0$temp;
                            ProxyMessage message = ProxyMessage.read(dis);
                            Objects.requireNonNull(message);
                            int index$1 = 0;
                            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ProxyMessage.Open.class, ProxyMessage.Packet.class, ProxyMessage.Close.class}, (Object)selector0$temp, index$1)) {
                                default: {
                                    throw new MatchException(null, null);
                                }
                                case 0: {
                                    ProxyMessage.Open open = (ProxyMessage.Open)selector0$temp;
                                    WorldHost.proxyConnect(open.getConnectionId(), open.getAddress(), () -> WorldHost.proxyProtocolClient);
                                    continue block7;
                                }
                                case 1: {
                                    ProxyMessage.Packet packet = (ProxyMessage.Packet)selector0$temp;
                                    WorldHost.proxyPacket(packet.getConnectionId(), packet.getBuffer());
                                    continue block7;
                                }
                                case 2: 
                            }
                            ProxyMessage.Close close = (ProxyMessage.Close)selector0$temp;
                            WorldHost.proxyDisconnect(close.getConnectionId());
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof SocketException && e.getMessage().equals("Socket closed")) break block8;
                        WorldHost.LOGGER.error("Critical error in WHEP recv thread", (Throwable)e);
                    }
                }
                this.closed = true;
            });
            try {
                sendThread.join();
            }
            catch (InterruptedException e) {
                WorldHost.LOGGER.error("{} interrupted.", (Object)Thread.currentThread().getName(), (Object)e);
            }
            try {
                socket.close();
            }
            catch (IOException e) {
                WorldHost.LOGGER.error("Failed to close WHEP socket.", (Throwable)e);
            }
            this.shutdownFuture.complete(null);
        });
    }

    private void enqueue(ProxyMessage message) {
        if (this.closed) {
            WorldHost.LOGGER.warn("Attempted to send over closed connection: {}", (Object)message);
            return;
        }
        try {
            this.sendQueue.put(Optional.of(message));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void packet(long connectionId, byte[] buffer) {
        this.enqueue(new ProxyMessage.Packet(connectionId, buffer));
    }

    public void close(long connectionId) {
        this.enqueue(new ProxyMessage.Close(connectionId));
    }

    @Override
    public void proxyS2CPacket(long connectionId, byte[] data) {
        this.packet(connectionId, data);
    }

    @Override
    public void proxyDisconnect(long connectionId) {
        this.close(connectionId);
    }

    public CompletableFuture<Void> getShutdownFuture() {
        return this.shutdownFuture;
    }

    public String getBaseAddr() {
        return this.baseAddr;
    }

    public int getMcPort() {
        return this.mcPort;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.sendQueue.add(Optional.empty());
    }

    public boolean isClosed() {
        return this.closed;
    }
}

