/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.protocol.punch;

import com.google.common.net.HostAndPort;
import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.protocol.WorldHostC2SMessage;
import io.github.gaming32.worldhost.protocol.punch.PunchReason;
import io.github.gaming32.worldhost.protocol.punch.PunchTransmitter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public final class PunchManager {
    private static final int PORT_LOOKUP_RETRANSMIT_PERIOD = 3;
    private static final int SERVER_PUNCH_EXPIRY = 200;
    private static final Map<UUID, PendingClientPunch> PENDING_CLIENT_PUNCHES = new HashMap<UUID, PendingClientPunch>();
    private static final Map<UUID, PendingServerPunch> PENDING_SERVER_PUNCHES = new ConcurrentHashMap<UUID, PendingServerPunch>();
    private static final Map<UUID, PendingPortLookup> PENDING_PORT_LOOKUPS = new ConcurrentHashMap<UUID, PendingPortLookup>();

    private PunchManager() {
    }

    public static void lookupPort(PunchTransmitter transmitter, Consumer<HostAndPort> successAction, Runnable cancelledAction) {
        UUID lookupId = UUID.randomUUID();
        PendingPortLookup lookup = new PendingPortLookup(lookupId, transmitter, successAction, cancelledAction);
        PENDING_PORT_LOOKUPS.put(lookupId, lookup);
        if (WorldHost.protoClient != null) {
            WorldHost.protoClient.beginPortLookup(lookupId);
            HostAndPort signalling = WorldHost.protoClient.getHostAndPort();
            Thread.ofVirtual().name("PunchManager-TransmitLookup-" + String.valueOf(lookup)).start(() -> lookup.transmit(signalling));
        }
    }

    public static void punch(long connectionId, PunchReason reason, PunchTransmitter transmitter, Consumer<HostAndPort> successAction, Runnable cancelledAction) {
        PunchManager.lookupPort(transmitter, myHostAndPort -> {
            UUID punchId = UUID.randomUUID();
            PENDING_CLIENT_PUNCHES.put(punchId, new PendingClientPunch(successAction, cancelledAction));
            if (WorldHost.protoClient != null) {
                WorldHost.protoClient.requestPunchOpen(connectionId, reason.id(), punchId, myHostAndPort.getHost(), myHostAndPort.getPort(), "", 0);
            }
        }, cancelledAction);
    }

    public static void retransmitAll() {
        long tickCount = WorldHost.tickCount;
        if (tickCount % 3L == 0L && WorldHost.protoClient != null) {
            HostAndPort signalling = WorldHost.protoClient.getHostAndPort();
            Thread.ofVirtual().name("PunchManager-RetransmitLookups").start(() -> {
                for (PendingPortLookup lookup : PENDING_PORT_LOOKUPS.values()) {
                    lookup.transmit(signalling);
                }
            });
        }
        Thread.ofVirtual().name("PunchManager-RetransmitPunches").start(() -> {
            Iterator<PendingServerPunch> iter = PENDING_SERVER_PUNCHES.values().iterator();
            while (iter.hasNext()) {
                PendingServerPunch punch = iter.next();
                punch.transmit();
                if (tickCount <= punch.expiryTick) continue;
                iter.remove();
            }
        });
    }

    public static void openPunchRequest(UUID punchId, PunchTransmitter transmitter, String host, int port, long connectionId) {
        PendingServerPunch punch = new PendingServerPunch(punchId, connectionId, host, port, transmitter, WorldHost.tickCount + 200L);
        PendingServerPunch old = PENDING_SERVER_PUNCHES.put(punchId, punch);
        if (old != null) {
            WorldHost.LOGGER.warn("New punch request {} replaced old request {} (ID {})", new Object[]{punch, old, punchId});
        }
        Thread.ofVirtual().name("PunchManager-TransmitPunch-" + String.valueOf(punchId)).start(punch::transmit);
        PunchManager.lookupPort(transmitter, myAddr -> {
            PENDING_SERVER_PUNCHES.remove(punchId);
            if (WorldHost.protoClient != null) {
                WorldHost.protoClient.punchSuccess(connectionId, punchId, myAddr.getHost(), myAddr.getPort());
            }
        }, () -> {
            PENDING_SERVER_PUNCHES.remove(punchId);
            if (WorldHost.protoClient != null) {
                WorldHost.protoClient.punchFailed(connectionId, punchId);
            }
        });
    }

    public static void portLookupSuccess(UUID lookupId, HostAndPort hostAndPort) {
        PendingPortLookup lookup = PENDING_PORT_LOOKUPS.remove(lookupId);
        if (lookup == null) {
            WorldHost.LOGGER.warn("Success received for unknown port lookup {}", (Object)lookupId);
            return;
        }
        lookup.successAction.accept(hostAndPort);
    }

    public static void cancelPortLookup(UUID lookupId) {
        PendingPortLookup lookup = PENDING_PORT_LOOKUPS.remove(lookupId);
        if (lookup == null) {
            WorldHost.LOGGER.warn("Cancellation received for unknown port lookup {}", (Object)lookupId);
            return;
        }
        lookup.cancelledAction.run();
    }

    public static void punchSuccess(UUID punchId, HostAndPort hostAndPort) {
        PendingClientPunch punch = PENDING_CLIENT_PUNCHES.remove(punchId);
        if (punch == null) {
            WorldHost.LOGGER.warn("Success received for unknown punch {}", (Object)punchId);
            return;
        }
        punch.successAction.accept(hostAndPort);
    }

    public static void cancelPunch(UUID punchId) {
        PendingClientPunch punch = PENDING_CLIENT_PUNCHES.remove(punchId);
        if (punch == null) {
            WorldHost.LOGGER.warn("Cancellation received for unknown punch {}", (Object)punchId);
            return;
        }
        punch.cancelledAction.run();
    }

    private record PendingPortLookup(UUID lookupId, PunchTransmitter transmitter, Consumer<HostAndPort> successAction, Runnable cancelledAction) {
        void transmit(HostAndPort target) {
            try {
                ByteArrayOutputStream packet = new ByteArrayOutputStream();
                WorldHostC2SMessage.writeUuid(new DataOutputStream(packet), this.lookupId);
                this.transmitter.transmit(packet.toByteArray(), new InetSocketAddress(target.getHost(), target.getPort()));
            }
            catch (IOException e) {
                WorldHost.LOGGER.error("Failed to transmit {}", (Object)this, (Object)e);
            }
        }
    }

    private record PendingServerPunch(UUID punchId, long connectionId, String host, int port, PunchTransmitter transmitter, long expiryTick) {
        void transmit() {
            try {
                this.transmitter.transmit(new byte[0], new InetSocketAddress(this.host, this.port));
            }
            catch (IOException e) {
                WorldHost.LOGGER.error("Failed to transmit {}", (Object)this, (Object)e);
            }
        }
    }

    private record PendingClientPunch(Consumer<HostAndPort> successAction, Runnable cancelledAction) {
    }
}

