/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.protocol.punch;

import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.compat.simplevoicechat.WorldHostSimpleVoiceChatCompat;
import io.github.gaming32.worldhost.protocol.punch.PunchTransmitter;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public record PunchReason(String id, VerificationType verificationType, TransmitterFinder transmitterFinder) {
    public static final String SIMPLE_VOICE_CHAT_ID = "simple_voice_chat";
    public static final PunchReason SIMPLE_VOICE_CHAT = new PunchReason("simple_voice_chat", VerificationType.IN_WORLD, TransmitterFinder.SIMPLE_VOICE_CHAT);

    @Nullable
    public static PunchReason byId(String id) {
        return switch (id) {
            case SIMPLE_VOICE_CHAT_ID -> SIMPLE_VOICE_CHAT;
            default -> null;
        };
    }

    @Override
    public String toString() {
        return "PunchReason[" + this.id + "]";
    }

    @FunctionalInterface
    public static interface VerificationType {
        public static final VerificationType SELF = uuid -> uuid.equals(WorldHost.getUserId());
        public static final VerificationType IS_FRIEND = WorldHost::isFriend;
        public static final VerificationType IN_WORLD = uuid -> {
            class_310 minecraft = class_310.method_1551();
            return (Boolean)((CompletableFuture)minecraft.method_5385(() -> ((class_310)minecraft).method_1576()).thenCompose(server -> {
                if (server == null) {
                    return CompletableFuture.completedFuture(false);
                }
                return server.method_5385(() -> server.method_3760().method_14602(uuid) != null);
            })).join();
        };
        public static final Map<VerificationType, String> TYPE_NAMES = Map.of(SELF, "SELF", IS_FRIEND, "IS_FRIEND", IN_WORLD, "IN_WORLD");

        public boolean verify(UUID var1);

        public static String getName(VerificationType type) {
            String result = TYPE_NAMES.get(type);
            return result != null ? result : type.toString();
        }
    }

    @FunctionalInterface
    public static interface TransmitterFinder {
        public static final TransmitterFinder SIMPLE_VOICE_CHAT = () -> {
            if (!WorldHost.isModLoaded("voicechat")) {
                return null;
            }
            return WorldHostSimpleVoiceChatCompat.getServerTransmitter().orElse(null);
        };
        public static final Map<TransmitterFinder, String> TYPE_NAMES = Map.of(SIMPLE_VOICE_CHAT, "SIMPLE_VOICE_CHAT");

        @Nullable
        public PunchTransmitter findServerTransmitter();

        public static String getName(TransmitterFinder finder) {
            String result = TYPE_NAMES.get(finder);
            return result != null ? result : finder.toString();
        }
    }
}

