/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.proxy;

import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.protocol.proxy.ProxyPassthrough;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.local.LocalChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.util.function.Supplier;
import net.minecraft.class_3242;

public final class ProxyClient
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final int PACKET_SIZE = 65535;
    private final InetAddress remoteAddress;
    private final long connectionId;
    private final Supplier<ProxyPassthrough> proxy;
    private ByteArrayOutputStream preActiveBuffer = new ByteArrayOutputStream();
    private Channel channel;
    private boolean closed;

    public ProxyClient(InetAddress remoteAddress, long connectionId, Supplier<ProxyPassthrough> proxy) throws IOException {
        this.remoteAddress = remoteAddress;
        this.connectionId = connectionId;
        this.proxy = proxy;
        if (proxy.get() == null) {
            WorldHost.LOGGER.error("ProxyPassthrough for {} ({}) is initially null.", (Object)connectionId, (Object)remoteAddress);
        }
    }

    public synchronized void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        this.channel = ctx.channel();
        this.send(this.preActiveBuffer.toByteArray());
        this.preActiveBuffer = null;
        WorldHost.LOGGER.info("Started proxy client from {}", (Object)this.remoteAddress);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        WorldHost.CONNECTED_PROXY_CLIENTS.remove(this.connectionId);
        this.close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        WorldHost.LOGGER.error("Proxy client connection for {} had error", (Object)this.remoteAddress, (Object)cause);
        WorldHost.CONNECTED_PROXY_CLIENTS.remove(this.connectionId);
        this.close();
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
        int len;
        ProxyPassthrough proxy = this.proxy.get();
        if (proxy == null) {
            this.close();
            return;
        }
        while ((len = Math.min(msg.readableBytes(), 65535)) != 0) {
            byte[] buffer = new byte[len];
            msg.readBytes(buffer);
            proxy.proxyS2CPacket(this.connectionId, buffer);
        }
    }

    public void start() {
        WorldHost.LOGGER.info("Starting proxy client from {}", (Object)this.remoteAddress);
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)class_3242.field_14111.get())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ch.pipeline().addLast("handler", (ChannelHandler)ProxyClient.this);
            }
        })).channel(LocalChannel.class)).connect(WorldHost.proxySocketAddress).syncUninterruptibly();
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            ProxyPassthrough proxy;
            if (this.channel != null) {
                this.channel.close();
            }
            if ((proxy = this.proxy.get()) != null) {
                proxy.proxyDisconnect(this.connectionId);
            }
            WorldHost.LOGGER.info("Proxy client connection for {} closed", (Object)this.remoteAddress);
        }
        catch (Exception e) {
            WorldHost.LOGGER.error("Proxy client connection for {} failed to close", (Object)this.remoteAddress, (Object)e);
        }
    }

    public synchronized void send(byte[] message) {
        if (this.channel == null) {
            this.preActiveBuffer.writeBytes(message);
            return;
        }
        if (this.channel.eventLoop().inEventLoop()) {
            this.doSend(message);
        } else {
            this.channel.eventLoop().execute(() -> this.doSend(message));
        }
    }

    private void doSend(byte[] message) {
        this.channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])message)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }
}

