/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.testing;

import io.github.gaming32.worldhost.testing.WindowCallbackManager;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_7417;
import org.intellij.lang.annotations.RegExp;

public class MinecraftApi {
    private static final Thread.Builder SLEEP_BUILDER = Thread.ofVirtual().name("WH-TestingSleeper-", 1L);

    public static void click(class_339 widget) {
        MinecraftApi.click((double)widget.method_46426() + (double)widget.method_25368() / 2.0, (double)widget.method_46427() + (double)widget.method_25364() / 2.0);
    }

    public static void click(double x, double y) {
        MinecraftApi.click(x, y, 0);
    }

    public static void click(double x, double y, int button) {
        class_1041 window = class_310.method_1551().method_22683();
        WindowCallbackManager.cursorPosCallback.invoke(window.method_4490(), x * (double)window.method_4480() / (double)window.method_4486(), y * (double)window.method_4507() / (double)window.method_4502());
        WindowCallbackManager.mouseButtonCallback.invoke(window.method_4490(), button, 1, 0);
        WindowCallbackManager.mouseButtonCallback.invoke(window.method_4490(), button, 0, 0);
    }

    public static void press(int keycode) {
        long window = class_310.method_1551().method_22683().method_4490();
        WindowCallbackManager.keyCallback.invoke(window, keycode, 0, 1, 0);
        WindowCallbackManager.keyCallback.invoke(window, keycode, 0, 0, 0);
    }

    public static void type(String message) {
        long window = class_310.method_1551().method_22683().method_4490();
        message.codePoints().forEach(cp -> WindowCallbackManager.charModsCallback.invoke(window, cp, 0));
    }

    public static void enterText(class_339 widget, String text) {
        MinecraftApi.click(widget);
        MinecraftApi.type(text);
    }

    public static class_339 findWidgetByRegex(@RegExp String regex) {
        return MinecraftApi.findWidgetByRegex(Pattern.compile(regex));
    }

    public static class_339 findWidgetByRegex(Pattern regex) {
        return MinecraftApi.findWidgetByString(regex.asMatchPredicate(), "Could not find widget for regex \"" + regex.pattern() + "\"");
    }

    public static class_339 findWidgetByString(Predicate<String> messageMatcher, String errorMessage) {
        return MinecraftApi.findWidget(c -> messageMatcher.test(c.getString()), errorMessage);
    }

    public static class_339 findWidgetByTranslation(String translation) {
        return MinecraftApi.findWidget(c -> {
            class_2588 translatable;
            class_7417 patt0$temp = c.method_10851();
            return patt0$temp instanceof class_2588 && (translatable = (class_2588)patt0$temp).method_11022().equals(translation);
        }, "Could not find widget with translation key \"" + translation + "\"");
    }

    public static class_339 findWidgetByComponent(class_2561 component) {
        return MinecraftApi.findWidget(arg_0 -> ((class_2561)component).equals(arg_0), "Could not find widget with text \"" + component.getString() + "\"");
    }

    public static class_339 findWidget(Predicate<class_2561> messageMatcher, String errorMessage) {
        return MinecraftApi.findGuiElements(class_339.class).filter(b -> messageMatcher.test(b.method_25369())).findFirst().orElseThrow(() -> new IllegalStateException(errorMessage));
    }

    public static <T extends class_364> Stream<T> findGuiElements(Class<T> ofClass) {
        return MinecraftApi.allGuiElements().filter(ofClass::isInstance).map(ofClass::cast);
    }

    public static Stream<class_364> allGuiElements() {
        class_437 screen = class_310.method_1551().field_1755;
        if (screen == null) {
            return Stream.empty();
        }
        return MinecraftApi.streamOf((class_364)screen);
    }

    private static Stream<class_364> streamOf(class_364 widget) {
        Stream<class_364> result = Stream.of(widget);
        if (!(widget instanceof class_4069)) {
            return result;
        }
        class_4069 container = (class_4069)widget;
        return Stream.concat(result, container.method_25396().stream().flatMap(MinecraftApi::streamOf));
    }

    public static void sleep(long millis, Runnable wakeupAction) {
        SLEEP_BUILDER.start(() -> {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                class_310.method_1551().execute(() -> {
                    throw new RuntimeException(e);
                });
                return;
            }
            class_310.method_1551().execute(() -> {
                try {
                    wakeupAction.run();
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            });
        });
    }
}

