/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.testing;

import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_437;

public class ScreenChain {
    private final Deque<ChainElement> chain = new ArrayDeque<ChainElement>();

    private ScreenChain() {
    }

    public static ScreenChain start() {
        return new ScreenChain();
    }

    public ScreenChain then(Class<? extends class_437> screenClass, Runnable onReady) {
        this.chain.add(new IsChainElement(screenClass, onReady));
        return this;
    }

    public ScreenChain maybe(Class<? extends class_437> screenClass, Runnable onReady) {
        this.chain.add(new IfChainElement(screenClass, onReady));
        return this;
    }

    @SafeVarargs
    public final ScreenChain skip(Class<? extends class_437> ... screenClasses) {
        for (Class<? extends class_437> screenClass : screenClasses) {
            this.then(screenClass, () -> {});
        }
        return this;
    }

    public ScreenChain skipAbsentScreen() {
        return this.then(null, () -> {});
    }

    public ScreenChain then(ScreenChain other) {
        this.chain.addAll(other.chain);
        return this;
    }

    public void advance(class_437 screen) {
        ChainElement next = this.chain.poll();
        if (next == null) {
            throw new IllegalStateException("ScreenChain ended before test end. Remaining screen: " + String.valueOf(screen));
        }
        switch (next.advance(screen).ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                this.advance(screen);
                break;
            }
            case 2: {
                throw new IllegalStateException("ChainElement " + String.valueOf(next) + " failed on " + String.valueOf(screen));
            }
        }
    }

    public static Class<? extends class_437> getScreenClass(class_437 screen) {
        return screen != null ? screen.getClass() : null;
    }

    private record IsChainElement(Class<? extends class_437> screenClass, Runnable onScreenReady) implements ChainElement
    {
        @Override
        public AdvanceMode advance(class_437 screen) {
            if (ScreenChain.getScreenClass(screen) == this.screenClass) {
                this.onScreenReady.run();
                return AdvanceMode.SUCCESS;
            }
            return AdvanceMode.ERROR;
        }

        @Override
        public String toString() {
            return "Is[" + String.valueOf(this.screenClass) + "]";
        }
    }

    private record IfChainElement(Class<? extends class_437> screenClass, Runnable onScreenReady) implements ChainElement
    {
        @Override
        public AdvanceMode advance(class_437 screen) {
            if (ScreenChain.getScreenClass(screen) == this.screenClass) {
                this.onScreenReady.run();
                return AdvanceMode.SUCCESS;
            }
            return AdvanceMode.ADVANCE_FURTHER;
        }

        @Override
        public String toString() {
            return "If[" + String.valueOf(this.screenClass) + "]";
        }
    }

    private static interface ChainElement {
        public AdvanceMode advance(class_437 var1);

        public String toString();
    }

    private static enum AdvanceMode {
        SUCCESS,
        ADVANCE_FURTHER,
        ERROR;

    }
}

