/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.testing;

import com.google.common.base.Suppliers;
import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.gui.screen.AddFriendScreen;
import io.github.gaming32.worldhost.gui.screen.FriendsScreen;
import io.github.gaming32.worldhost.gui.screen.JoiningWorldHostScreen;
import io.github.gaming32.worldhost.gui.screen.OnlineFriendsScreen;
import io.github.gaming32.worldhost.gui.screen.WorldHostConfigScreen;
import io.github.gaming32.worldhost.mixin.DisconnectedScreenAccessor;
import io.github.gaming32.worldhost.testing.MinecraftApi;
import io.github.gaming32.worldhost.testing.ScreenChain;
import java.lang.runtime.SwitchBootstraps;
import java.util.function.Supplier;
import net.minecraft.class_1132;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3928;
import net.minecraft.class_412;
import net.minecraft.class_419;
import net.minecraft.class_433;
import net.minecraft.class_434;
import net.minecraft.class_436;
import net.minecraft.class_442;
import net.minecraft.class_4749;
import net.minecraft.class_500;
import net.minecraft.class_525;
import net.minecraft.class_526;

public class WorldHostTesting {
    public static final boolean ENABLED = Boolean.getBoolean("world-host-testing.enabled");
    public static final TestingUser USER = ENABLED ? TestingUser.valueOf(System.getProperty("world-host-testing.user")) : null;
    public static final Supplier<ScreenChain> SCREEN_CHAIN = Suppliers.memoize(() -> {
        TestingUser selector0$temp = USER;
        int index$1 = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"HOST", "JOINER"}, (TestingUser)selector0$temp, index$1)) {
            default -> throw new MatchException(null, null);
            case 0 -> WorldHostTesting.createHost();
            case 1 -> WorldHostTesting.createJoiner();
            case -1 -> throw new AssertionError((Object)"Shouldn't initialize WorldHostTesting.SCREEN_CHAIN outside of testing");
        };
    });
    private static final int TIMEOUT = 60000;

    private static ScreenChain createHost() {
        return ScreenChain.start().then(class_442.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("menu.singleplayer"))).maybe(class_4749.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("gui.proceed"))).maybe(class_526.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("world-host.create_world"))).then(class_525.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("selectWorld.create"))).skip(class_3928.class, class_434.class).then(null, () -> MinecraftApi.press(256)).then(class_433.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("world-host.online_status"))).then(WorldHostTesting.addFriend(TestingUser.JOINER)).then(class_433.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("world-host.open_world"))).then(class_436.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("world-host.open_world"))).then(null, () -> WorldHostTesting.waitForJoinerToJoin(0L)).then(class_433.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("menu.returnToMenu"))).then(class_442.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("menu.quit")));
    }

    private static void waitForJoinerToJoin(long timeSpent) {
        WorldHost.LOGGER.info("Checking for joins...");
        class_1132 server = class_310.method_1551().method_1576();
        if (server == null) {
            throw new IllegalStateException("Server shutdown before joiner joined");
        }
        if (server.method_3788() < 2) {
            if (timeSpent > 60000L) {
                throw new IllegalStateException("Timed out waiting for joiner to join");
            }
            MinecraftApi.sleep(2000L, () -> WorldHostTesting.waitForJoinerToJoin(timeSpent + 2000L));
        } else {
            MinecraftApi.sleep(15000L, () -> MinecraftApi.press(256));
        }
    }

    private static ScreenChain createJoiner() {
        return ScreenChain.start().then(class_442.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("world-host.online_status"))).then(WorldHostTesting.addFriend(TestingUser.HOST)).then(class_442.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("menu.multiplayer"))).maybe(class_4749.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("gui.proceed"))).then(class_500.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("world-host.friends"))).then(OnlineFriendsScreen.class, () -> WorldHostTesting.waitForHostToHost(0L)).skip(JoiningWorldHostScreen.class).then(WorldHostTesting.tryToJoinServer()).skipAbsentScreen().then(class_419.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("gui.toMenu"))).then(OnlineFriendsScreen.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("gui.cancel"))).then(class_442.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("menu.quit")));
    }

    private static ScreenChain tryToJoinServer() {
        return ScreenChain.start().skip(class_412.class).maybe(class_419.class, () -> {
            DisconnectedScreenAccessor screen = (DisconnectedScreenAccessor)class_310.method_1551().field_1755;
            assert (screen != null);
            class_2561 reason = screen.getDetails().comp_2853();
            throw new IllegalStateException("Unexpected disconnect trying to join server: " + reason.getString());
        }).skip(class_434.class);
    }

    private static void waitForHostToHost(long timeSpent) {
        WorldHost.LOGGER.info("Checking for host...");
        OnlineFriendsScreen.OnlineFriendsList list = MinecraftApi.findGuiElements(OnlineFriendsScreen.OnlineFriendsList.class).findFirst().orElseThrow();
        if (list.method_25396().isEmpty()) {
            if (timeSpent > 60000L) {
                throw new IllegalStateException("Timed out waiting for host to host");
            }
            MinecraftApi.press(294);
            MinecraftApi.sleep(2000L, () -> WorldHostTesting.waitForHostToHost(timeSpent + 2000L));
        } else {
            MinecraftApi.click((double)list.method_25342() + (double)list.method_25322() / 2.0, (double)list.method_25337(0) + (double)list.getItemHeight() / 2.0);
            MinecraftApi.click(MinecraftApi.findWidgetByTranslation("selectServer.select"));
        }
    }

    private static ScreenChain addFriend(TestingUser user) {
        return ScreenChain.start().then(WorldHostConfigScreen.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("world-host.friends"))).then(FriendsScreen.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("world-host.add_friend"))).then(AddFriendScreen.class, () -> {
            MinecraftApi.enterText(MinecraftApi.findWidgetByTranslation("world-host.add_friend.enter_username"), "o:" + String.valueOf((Object)user) + WorldHostTesting.getUsernameSuffix());
            MinecraftApi.click(MinecraftApi.findWidgetByComponent(AddFriendScreen.ADD_FRIEND_SILENT_TEXT));
        }).then(FriendsScreen.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("gui.done"))).then(WorldHostConfigScreen.class, () -> MinecraftApi.click(MinecraftApi.findWidgetByTranslation("gui.done")));
    }

    private static String getUsernameSuffix() {
        String username = class_310.method_1551().method_1548().method_1676();
        if (!username.startsWith(USER.name())) {
            throw new IllegalStateException("Username " + username + " doesn't start with " + String.valueOf((Object)USER));
        }
        return username.substring(USER.name().length());
    }

    public static enum TestingUser {
        HOST,
        JOINER;

    }
}

