/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.toast;

import io.github.gaming32.worldhost.gui.screen.WorldHostScreen;
import io.github.gaming32.worldhost.toast.IconRenderer;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ToastInstance {
    private static final int TEXT_WIDTH = 200;
    private static final int BORDER_SIZE = 5;
    private static final int ICON_SIZE = 20;
    private static final int DESCRIPTION_BREAK = 6;
    private static final int LINE_BREAK = 3;
    private static final int PROGRESS_HEIGHT = 3;
    private static final int PROGRESS_BORDER_HEIGHT = 6;
    private static final int BACKGROUND_COLOR = -14277082;
    private static final int PROGRESS_COLOR = -11711155;
    private static final int PROGRESS_COLOR_HOVERED = -9539986;
    private static final int TITLE_COLOR = -2697514;
    private static final int DESCRIPTION_COLOR = -6052957;
    public final class_327 font;
    @NotNull
    public final class_2561 title;
    @Nullable
    public final class_2561 description;
    @Nullable
    public final IconRenderer iconRenderer;
    @Nullable
    public final Runnable clickAction;
    public final boolean important;
    public final int width;
    public int height;
    public final int ticksTotal;
    public int ticksRemaining;
    public List<class_5481> formattedTitle;
    public List<class_5481> formattedDescription;
    public float y;
    private boolean clicked;

    public ToastInstance(@NotNull class_2561 title, @Nullable class_2561 description, @Nullable IconRenderer iconRenderer, @Nullable Runnable clickAction, boolean important, int ticks) {
        this.font = class_310.method_1551().field_1772;
        this.title = title;
        this.description = description;
        this.iconRenderer = iconRenderer;
        this.clickAction = clickAction;
        this.important = important;
        this.width = 210 + (iconRenderer != null ? 25 : 0);
        this.ticksRemaining = this.ticksTotal = ticks;
    }

    public void calculateText() {
        this.formattedTitle = this.font.method_1728((class_5348)this.title, 200);
        this.formattedDescription = this.description != null ? this.font.method_1728((class_5348)this.description, 200) : Collections.emptyList();
        int n = this.formattedTitle.size();
        Objects.requireNonNull(this.font);
        int n2 = 5 + n * (9 + 3) - 3 + 6;
        int n3 = this.formattedDescription.size();
        Objects.requireNonNull(this.font);
        this.height = n2 + n3 * (9 + 3) - 3 + (this.clickAction != null ? 6 : 5);
        if (this.iconRenderer != null) {
            this.height = Math.max(this.height, 30);
        }
    }

    public void render(@NotNull class_332 context, float x, float y, int mouseX, int mouseY, float tickDelta) {
        float prevX;
        class_4587 poseStack = WorldHostScreen.pose(context);
        float originalX = x;
        if (this.ticksRemaining < 20) {
            prevX = x - ToastInstance.calculateX(this.ticksRemaining + 1);
            x -= ToastInstance.calculateX(this.ticksRemaining);
        } else if (this.ticksTotal - this.ticksRemaining <= 20) {
            prevX = x - ToastInstance.calculateX(this.ticksTotal - this.ticksRemaining - 1);
            x -= ToastInstance.calculateX(this.ticksTotal - this.ticksRemaining);
        } else {
            prevX = x;
        }
        x = class_3532.method_16439((float)tickDelta, (float)prevX, (float)x);
        ToastInstance.fill(context, x, y, x + (float)this.width, y + (float)this.height, -14277082);
        poseStack.method_22903();
        poseStack.method_46416(x + 5.0f + (float)(this.iconRenderer != null ? 25 : 0), y + 5.0f, 0.0f);
        for (class_5481 line : this.formattedTitle) {
            WorldHostScreen.drawString(context, this.font, line, 0, 0, -2697514, false);
            Objects.requireNonNull(this.font);
            poseStack.method_46416(0.0f, (float)(9 + 3), 0.0f);
        }
        poseStack.method_46416(0.0f, 3.0f, 0.0f);
        for (class_5481 line : this.formattedDescription) {
            WorldHostScreen.drawString(context, this.font, line, 0, 0, -6052957, false);
            Objects.requireNonNull(this.font);
            poseStack.method_46416(0.0f, (float)(9 + 3), 0.0f);
        }
        poseStack.method_22909();
        if (this.iconRenderer != null) {
            poseStack.method_22903();
            poseStack.method_46416(x, y, 0.0f);
            this.iconRenderer.draw(context, 5, 5, 20, 20);
            poseStack.method_22909();
        }
        if (this.clickAction != null && this.ticksRemaining > 20) {
            ToastInstance.fill(context, x, y + (float)this.height - 3.0f, x + class_3532.method_16439((float)tickDelta, (float)(this.ticksRemaining - 20), (float)(this.ticksRemaining - 21)) / (float)(this.ticksTotal - 20) * (float)this.width, y + (float)this.height, (float)mouseX >= originalX && (float)mouseX <= originalX + (float)this.width && (float)mouseY >= y && (float)mouseY <= y + (float)this.height ? -9539986 : -11711155);
        }
    }

    public boolean click(int button) {
        if (this.clicked) {
            return false;
        }
        if (button != 0 && button != 2) {
            return false;
        }
        this.clicked = true;
        this.ticksRemaining = Math.min(this.ticksRemaining, 20);
        if (this.clickAction != null && button != 2) {
            this.clickAction.run();
        }
        return true;
    }

    private static float calculateX(int ticks) {
        return (float)(-Math.pow(ticks - 16, 2.0) + 16.0);
    }

    private static void fill(@NotNull class_332 context, float minX, float minY, float maxX, float maxY, int color) {
        class_4587 poseStack = WorldHostScreen.pose(context);
        poseStack.method_22903();
        poseStack.method_46416(minX, minY, 0.0f);
        poseStack.method_22905(maxX - minX, maxY - minY, 1.0f);
        WorldHostScreen.fill(context, 0, 0, 1, 1, color);
        poseStack.method_22909();
    }
}

