/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.toast;

import com.demonwav.mcdev.annotations.Translatable;
import io.github.gaming32.worldhost.ResourceLocations;
import io.github.gaming32.worldhost.gui.screen.WorldHostScreen;
import io.github.gaming32.worldhost.testing.WorldHostTesting;
import io.github.gaming32.worldhost.toast.ToastBuilder;
import io.github.gaming32.worldhost.toast.ToastInstance;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_4587;
import org.jetbrains.annotations.NotNull;

public class WHToast {
    private static final int GAP = 4;
    private static final int X_OFFSET = 4;
    private static final int Y_OFFSET = 4;
    private static final class_3414 IMPORTANT = WHToast.newSoundEvent("important");
    private static final class_3414 REGULAR = WHToast.newSoundEvent("regular");
    private static final class_3414 REMOVED = WHToast.newSoundEvent("removed");
    private static boolean ready = false;
    private static final List<ToastInstance> TOASTS = new ArrayList<ToastInstance>();

    public static ToastBuilder builder(@NotNull class_2561 title) {
        return new ToastBuilder(title);
    }

    public static ToastBuilder builder(@NotNull @Translatable String titleKey) {
        return new ToastBuilder((class_2561)class_2561.method_43471((String)titleKey));
    }

    public static void ready() {
        float y = 4.0f;
        for (ToastInstance toast : TOASTS) {
            toast.calculateText();
            toast.y = y;
            y += (float)(toast.height + 4);
        }
        if (!TOASTS.isEmpty()) {
            if (TOASTS.stream().anyMatch(t -> t.important)) {
                WHToast.playSound(IMPORTANT);
            } else {
                WHToast.playSound(REGULAR);
            }
        }
        ready = true;
    }

    static void add(ToastInstance toast) {
        if (ready) {
            toast.calculateText();
            WHToast.playSound(toast.important ? IMPORTANT : REGULAR);
            if (!TOASTS.isEmpty()) {
                if ((float)(4 + 2 * toast.height + 4) <= WHToast.TOASTS.getFirst().y) {
                    toast.y = 4.0f;
                    TOASTS.addFirst(toast);
                    return;
                }
                for (int i = 0; i < TOASTS.size() - 1; ++i) {
                    ToastInstance prevToast = TOASTS.get(i);
                    ToastInstance nextToast = TOASTS.get(i + 1);
                    if (!(prevToast.y + (float)prevToast.height + 4.0f + (float)(2 * toast.height) + 4.0f <= nextToast.y)) continue;
                    toast.y = prevToast.y + (float)prevToast.height + 4.0f;
                    TOASTS.add(i + 1, toast);
                    return;
                }
                ToastInstance lastToast = TOASTS.getLast();
                toast.y = lastToast.y + (float)lastToast.height + 4.0f;
            } else {
                toast.y = 4.0f;
            }
        }
        TOASTS.add(toast);
    }

    public static void tick() {
        if (!ready) {
            return;
        }
        Iterator<ToastInstance> it = TOASTS.iterator();
        while (it.hasNext()) {
            ToastInstance toast = it.next();
            --toast.ticksRemaining;
            if (toast.ticksRemaining == 19) {
                WHToast.playSound(REMOVED);
                continue;
            }
            if (toast.ticksRemaining > 0) continue;
            it.remove();
        }
    }

    public static void render(@NotNull class_332 context, int mouseX, int mouseY, float tickDelta) {
        if (!ready) {
            return;
        }
        class_4587 poseStack = WorldHostScreen.pose(context);
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 100.0f);
        class_1041 window = class_310.method_1551().method_22683();
        int screenWidth = window.method_4486();
        int screenHeight = window.method_4502();
        for (ToastInstance toast : TOASTS) {
            toast.render(context, screenWidth - 4 - toast.width, (float)screenHeight - toast.y - (float)toast.height, mouseX, mouseY, tickDelta);
        }
        poseStack.method_22909();
    }

    public static boolean click(double mouseX, double mouseY, int button) {
        if (!ready || WorldHostTesting.ENABLED) {
            return false;
        }
        class_1041 window = class_310.method_1551().method_22683();
        int screenWidth = window.method_4486();
        int screenHeight = window.method_4502();
        for (ToastInstance toast : TOASTS) {
            float toastX = screenWidth - 4 - toast.width;
            float toastY = (float)(screenHeight - toast.height) - toast.y;
            if (!(mouseX >= (double)toastX) || !(mouseX <= (double)(toastX + (float)toast.width)) || !(mouseY >= (double)toastY) || !(mouseY <= (double)(toastY + (float)toast.height)) || !toast.click(button)) continue;
            return true;
        }
        return false;
    }

    private static class_3414 newSoundEvent(String location) {
        return class_3414.method_47908((class_2960)ResourceLocations.worldHost("toast/" + location));
    }

    private static void playSound(class_3414 event) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)event, (float)1.0f, (float)1.0f));
    }
}

