/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.upnp;

import io.github.gaming32.worldhost.upnp.UPnPErrors;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class Gateway {
    private final InetAddress iface;
    private final InetAddress routerip;
    private String serviceType = null;
    private String controlURL = null;

    public Gateway(byte[] data, InetAddress ip, InetAddress gatewayip) throws Exception {
        this.iface = ip;
        this.routerip = gatewayip;
        String location = null;
        StringTokenizer st = new StringTokenizer(new String(data), "\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim();
            if (s.isEmpty() || s.startsWith("HTTP/1.") || s.startsWith("NOTIFY *")) continue;
            String name = s.substring(0, s.indexOf(58));
            String val = s.substring(name.length() + 1).trim();
            if (!name.equalsIgnoreCase("location")) continue;
            location = val;
        }
        if (location == null) {
            throw new Exception("Unsupported Gateway");
        }
        Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(location);
        NodeList services = d.getElementsByTagName("service");
        for (int i = 0; i < services.getLength(); ++i) {
            Node service = services.item(i);
            NodeList n = service.getChildNodes();
            String serviceType = null;
            String controlURL = null;
            for (int j = 0; j < n.getLength(); ++j) {
                Node x = n.item(j);
                if (x.getNodeName().trim().equalsIgnoreCase("serviceType")) {
                    serviceType = x.getFirstChild().getNodeValue();
                    continue;
                }
                if (!x.getNodeName().trim().equalsIgnoreCase("controlURL")) continue;
                controlURL = x.getFirstChild().getNodeValue();
            }
            if (serviceType == null || controlURL == null || !serviceType.trim().toLowerCase().contains(":wanipconnection:") && !serviceType.trim().toLowerCase().contains(":wanpppconnection:")) continue;
            this.serviceType = serviceType.trim();
            this.controlURL = controlURL.trim();
        }
        if (this.controlURL == null) {
            throw new Exception("Unsupported Gateway");
        }
        int slash = location.indexOf("/", 7);
        if (slash == -1) {
            throw new Exception("Unsupported Gateway");
        }
        location = location.substring(0, slash);
        if (!this.controlURL.startsWith("/")) {
            this.controlURL = "/" + this.controlURL;
        }
        this.controlURL = location + this.controlURL;
    }

    private Map<String, String> command(String action, Map<String, String> params) throws Exception {
        Node n;
        HashMap<String, String> ret = new HashMap<String, String>();
        StringBuilder soap = new StringBuilder("<?xml version=\"1.0\"?>\r\n<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><SOAP-ENV:Body><m:" + action + " xmlns:m=\"" + this.serviceType + "\">");
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                soap.append("<").append(entry.getKey()).append(">").append(entry.getValue()).append("</").append(entry.getKey()).append(">");
            }
        }
        soap.append("</m:").append(action).append("></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        byte[] req = soap.toString().getBytes();
        HttpURLConnection conn = (HttpURLConnection)new URI(this.controlURL).toURL().openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "text/xml");
        conn.setRequestProperty("SOAPAction", "\"" + this.serviceType + "#" + action + "\"");
        conn.setRequestProperty("Connection", "Close");
        conn.setRequestProperty("Content-Length", "" + req.length);
        conn.getOutputStream().write(req);
        Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(conn.getInputStream());
        NodeIterator iter = ((DocumentTraversal)((Object)d)).createNodeIterator(d.getDocumentElement(), 1, null, true);
        while ((n = iter.nextNode()) != null) {
            try {
                if (n.getFirstChild().getNodeType() != 3) continue;
                ret.put(n.getNodeName(), n.getTextContent());
            }
            catch (Throwable throwable) {}
        }
        conn.disconnect();
        return ret;
    }

    public String getGatewayIP() {
        return this.routerip.getHostAddress();
    }

    public String getLocalIP() {
        return this.iface.getHostAddress();
    }

    public String getExternalIP() {
        try {
            Map<String, String> r = this.command("GetExternalIPAddress", null);
            return r.get("NewExternalIPAddress");
        }
        catch (Throwable t) {
            return null;
        }
    }

    public UPnPErrors.AddPortMappingErrors openPort(int port, int leaseDurationSeconds, boolean udp) throws Exception {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("NewRemoteHost", "");
        params.put("NewProtocol", udp ? "UDP" : "TCP");
        params.put("NewInternalClient", this.iface.getHostAddress());
        params.put("NewExternalPort", "" + port);
        params.put("NewInternalPort", "" + port);
        params.put("NewEnabled", "1");
        params.put("NewPortMappingDescription", "WorldHost");
        params.put("NewLeaseDuration", "" + leaseDurationSeconds);
        String error = this.command("AddPortMapping", params).get("errorCode");
        return error != null ? (UPnPErrors.AddPortMappingErrors)((Object)UPnPErrors.ADD_PORT_MAPPING_ERROR_CODES.get(Integer.parseInt(error))) : null;
    }
}

