/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.worldhost.upnp;

import io.github.gaming32.worldhost.upnp.Gateway;
import java.lang.invoke.CallSite;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.function.Consumer;

public class GatewayFinder {
    private static final String[] SEARCH_MESSAGES;
    private final LinkedList<Thread> listeners = new LinkedList();
    private final Consumer<Gateway> onFound;

    public GatewayFinder(Consumer<Gateway> onFound) {
        this.onFound = onFound;
        for (InetAddress ip : GatewayFinder.getLocalIPs()) {
            for (String req : SEARCH_MESSAGES) {
                GatewayListener l = new GatewayListener(ip, req);
                Thread thread = Thread.ofVirtual().name("UPnP Gateway Finder " + String.valueOf(ip)).start(l);
                this.listeners.add(thread);
            }
        }
    }

    public boolean isSearching() {
        for (Thread l : this.listeners) {
            if (!l.isAlive()) continue;
            return true;
        }
        return false;
    }

    private static InetAddress[] getLocalIPs() {
        HashSet<InetAddress> ret = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                try {
                    NetworkInterface iface = ifaces.nextElement();
                    if (!iface.isUp() || iface.isLoopback() || iface.isVirtual() || iface.isPointToPoint()) continue;
                    Enumeration<InetAddress> addrs = iface.getInetAddresses();
                    while (addrs.hasMoreElements()) {
                        ret.add(addrs.nextElement());
                    }
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ret.toArray(new InetAddress[0]);
    }

    static {
        LinkedList<CallSite> m = new LinkedList<CallSite>();
        for (String type : new String[]{"urn:schemas-upnp-org:device:InternetGatewayDevice:1", "urn:schemas-upnp-org:service:WANIPConnection:1", "urn:schemas-upnp-org:service:WANPPPConnection:1"}) {
            m.add((CallSite)((Object)("M-SEARCH * HTTP/1.1\r\nHOST: 239.255.255.250:1900\r\nST: " + type + "\r\nMAN: \"ssdp:discover\"\r\nMX: 2\r\n\r\n")));
        }
        SEARCH_MESSAGES = m.toArray(new String[0]);
    }

    private class GatewayListener
    implements Runnable {
        private final InetAddress ip;
        private final String req;

        public GatewayListener(InetAddress ip, String req) {
            this.ip = ip;
            this.req = req;
        }

        @Override
        public void run() {
            boolean foundgw = false;
            Gateway gw = null;
            try {
                byte[] req = this.req.getBytes();
                try (DatagramSocket s = new DatagramSocket(new InetSocketAddress(this.ip, 0));){
                    s.send(new DatagramPacket(req, req.length, new InetSocketAddress("239.255.255.250", 1900)));
                    s.setSoTimeout(3000);
                    try {
                        while (true) {
                            DatagramPacket recv = new DatagramPacket(new byte[1536], 1536);
                            s.receive(recv);
                            gw = new Gateway(recv.getData(), this.ip, recv.getAddress());
                            String extIp = gw.getExternalIP();
                            if (extIp == null || extIp.equalsIgnoreCase("0.0.0.0")) continue;
                            GatewayFinder.this.onFound.accept(gw);
                            foundgw = true;
                        }
                    }
                    catch (SocketTimeoutException t) {
                    }
                    finally {
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (!foundgw && gw != null) {
                GatewayFinder.this.onFound.accept(gw);
            }
        }
    }
}

