/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.condition;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.condition.Condition;
import fr.ax_dev.universejobs.condition.ConditionResult;
import fr.ax_dev.universejobs.config.MessageConfig;
import fr.ax_dev.universejobs.utils.EnumUtils;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public abstract class AbstractCondition
implements Condition {
    private static final String MESSAGE_KEY = "message";
    protected final ConditionResult denyResult;
    protected final ConditionResult acceptResult;

    protected AbstractCondition(ConfigurationSection config) {
        ConfigurationSection denySection = config.getConfigurationSection("deny");
        MessageConfig denyMessage = null;
        List<String> denyCommands = null;
        Sound denySound = null;
        boolean denyCancelEvent = false;
        if (denySection != null) {
            ConfigurationSection denyMessageSection = denySection.getConfigurationSection(MESSAGE_KEY);
            if (denyMessageSection != null) {
                denyMessage = new MessageConfig(denyMessageSection);
            } else {
                String legacyMessage = denySection.getString(MESSAGE_KEY);
                if (legacyMessage != null) {
                    denyMessage = new MessageConfig(legacyMessage);
                }
            }
            denyCommands = MessageConfig.parseCommands(denySection, "commands");
            String denySoundStr = denySection.getString("sound");
            if (denySoundStr != null) {
                try {
                    NamespacedKey key = NamespacedKey.minecraft((String)denySoundStr.toLowerCase());
                    denySound = (Sound)Registry.SOUNDS.get(key);
                    if (denySound == null) {
                        denySound = EnumUtils.parseSound(denySoundStr, null);
                    }
                }
                catch (Exception key) {
                    // empty catch block
                }
            }
            denyCancelEvent = denySection.getBoolean("cancel-event", false);
        }
        ConfigurationSection acceptSection = config.getConfigurationSection("accept");
        MessageConfig acceptMessage = null;
        List<String> acceptCommands = null;
        Sound acceptSound = null;
        boolean acceptCancelEvent = false;
        if (acceptSection != null) {
            ConfigurationSection acceptMessageSection = acceptSection.getConfigurationSection(MESSAGE_KEY);
            if (acceptMessageSection != null) {
                acceptMessage = new MessageConfig(acceptMessageSection);
            } else {
                String legacyMessage = acceptSection.getString(MESSAGE_KEY);
                if (legacyMessage != null) {
                    acceptMessage = new MessageConfig(legacyMessage);
                }
            }
            acceptCommands = MessageConfig.parseCommands(acceptSection, "commands");
            String acceptSoundStr = acceptSection.getString("sound");
            if (acceptSoundStr != null) {
                try {
                    NamespacedKey key = NamespacedKey.minecraft((String)acceptSoundStr.toLowerCase());
                    acceptSound = (Sound)Registry.SOUNDS.get(key);
                    if (acceptSound == null) {
                        acceptSound = EnumUtils.parseSound(acceptSoundStr, null);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            acceptCancelEvent = acceptSection.getBoolean("cancel-event", false);
        }
        this.denyResult = new EnhancedConditionResult(false, denyMessage, denySound, denyCommands, denyCancelEvent, null, null, null, false);
        this.acceptResult = new EnhancedConditionResult(true, null, null, null, false, acceptMessage, acceptSound, acceptCommands, acceptCancelEvent);
    }

    @Override
    public ConditionResult getDenyResult() {
        return this.denyResult;
    }

    @Override
    public ConditionResult getAcceptResult() {
        return this.acceptResult;
    }

    private static class EnhancedConditionResult
    extends ConditionResult {
        private final MessageConfig denyMessageConfig;
        private final MessageConfig acceptMessageConfig;

        public EnhancedConditionResult(boolean allowed, MessageConfig denyMessageConfig, Sound denySound, List<String> denyCommands, boolean denyCancelEvent, MessageConfig acceptMessageConfig, Sound acceptSound, List<String> acceptCommands, boolean acceptCancelEvent) {
            super(allowed, denyMessageConfig != null ? denyMessageConfig.getText() : null, denySound, denyCommands, denyCancelEvent, acceptMessageConfig != null ? acceptMessageConfig.getText() : null, acceptSound, acceptCommands, acceptCancelEvent);
            this.denyMessageConfig = denyMessageConfig;
            this.acceptMessageConfig = acceptMessageConfig;
        }

        @Override
        public void execute(Player player) {
            Sound sound;
            MessageConfig messageConfig = this.isAllowed() ? this.acceptMessageConfig : this.denyMessageConfig;
            List<String> commands = this.isAllowed() ? this.getAcceptCommands() : this.getDenyCommands();
            Sound sound2 = sound = this.isAllowed() ? this.getAcceptSound() : this.getDenySound();
            if (messageConfig != null && messageConfig.hasContent()) {
                String text = messageConfig.getText();
                switch (messageConfig.getType()) {
                    case CHAT: {
                        MessageUtils.sendMessage(player, text);
                        break;
                    }
                    case ACTIONBAR: {
                        MessageUtils.sendActionBar(player, text);
                        if (messageConfig.getDuration() <= 0) break;
                        UniverseJobs.getInstance().getFoliaManager().runLater(() -> {
                            if (player.isOnline()) {
                                MessageUtils.sendActionBar(player, "");
                            }
                        }, messageConfig.getDuration());
                        break;
                    }
                    case BOSSBAR: {
                        BossBar bossBar = Bukkit.createBossBar((String)MessageUtils.colorize(text), (BarColor)messageConfig.getBossbarColor(), (BarStyle)messageConfig.getBossbarStyle(), (BarFlag[])new BarFlag[0]);
                        bossBar.setProgress(1.0);
                        bossBar.addPlayer(player);
                        if (messageConfig.getDuration() <= 0) break;
                        UniverseJobs.getInstance().getFoliaManager().runLater(() -> {
                            if (player.isOnline()) {
                                bossBar.removePlayer(player);
                            }
                        }, messageConfig.getDuration());
                    }
                }
            }
            if (sound != null) {
                player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
            }
            if (commands != null && !commands.isEmpty()) {
                for (String command : commands) {
                    String processedCommand = command.replace("{player}", player.getName());
                    player.getServer().dispatchCommand((CommandSender)player.getServer().getConsoleSender(), processedCommand);
                }
            }
        }
    }
}

