/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.condition.impl;

import fr.ax_dev.universejobs.condition.AbstractCondition;
import fr.ax_dev.universejobs.condition.ConditionContext;
import fr.ax_dev.universejobs.condition.ConditionType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class PermissionCondition
extends AbstractCondition {
    private final String permission;
    private final boolean require;

    public PermissionCondition(ConfigurationSection config) {
        super(config);
        this.permission = config.getString("permission", "");
        this.require = config.getBoolean("require", true);
    }

    @Override
    public boolean isMet(Player player, Event event, ConditionContext context) {
        boolean hasPermission = player.hasPermission(this.permission);
        return this.require ? hasPermission : !hasPermission;
    }

    @Override
    public ConditionType getType() {
        return ConditionType.PERMISSION;
    }

    public String toString() {
        return "PermissionCondition{permission='" + this.permission + "', require=" + this.require + "}";
    }
}

