/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.integration;

import com.gmail.nossr50.api.AbilityAPI;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class McMMOHandler {
    private static McMMOHandler instance;
    private final Logger logger;
    private boolean enabled = false;

    private McMMOHandler(Plugin plugin) {
        this.logger = plugin.getLogger();
        this.initialize(plugin);
    }

    public static McMMOHandler getInstance(Plugin plugin) {
        if (instance == null) {
            instance = new McMMOHandler(plugin);
        }
        return instance;
    }

    private void initialize(Plugin plugin) {
        if (plugin.getServer().getPluginManager().getPlugin("mcMMO") != null) {
            this.enabled = true;
            this.logger.info("[UniverseJobs] mcMMO integration enabled!");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAbilityActive(Player player, String abilityName) {
        if (!this.enabled || player == null || abilityName == null) {
            return false;
        }
        try {
            return AbilityAPI.isAnyAbilityEnabled((Player)player);
        }
        catch (Exception e) {
            this.logger.warning("Error checking mcMMO ability: " + e.getMessage());
            return false;
        }
    }

    public boolean isAnyAbilityActive(Player player) {
        if (!this.enabled || player == null) {
            return false;
        }
        try {
            return AbilityAPI.isAnyAbilityEnabled((Player)player);
        }
        catch (Exception e) {
            this.logger.warning("Error checking mcMMO abilities: " + e.getMessage());
            return false;
        }
    }

    public double getMoneyMultiplier(Player player, String abilityName, Map<String, McMMOAbilityConfig> mcmmoConfig) {
        if (!this.enabled || mcmmoConfig == null || mcmmoConfig.isEmpty()) {
            return 1.0;
        }
        if (!this.isAbilityActive(player, abilityName)) {
            return 1.0;
        }
        McMMOAbilityConfig config = mcmmoConfig.get(abilityName.toLowerCase());
        if (config != null) {
            return config.getMoneyAmplifier();
        }
        return 1.0;
    }

    public double getXpMultiplier(Player player, String abilityName, Map<String, McMMOAbilityConfig> mcmmoConfig) {
        if (!this.enabled || mcmmoConfig == null || mcmmoConfig.isEmpty()) {
            return 1.0;
        }
        if (!this.isAbilityActive(player, abilityName)) {
            return 1.0;
        }
        McMMOAbilityConfig config = mcmmoConfig.get(abilityName.toLowerCase());
        if (config != null) {
            return config.getXpAmplifier();
        }
        return 1.0;
    }

    public double getActiveAbilityMultiplier(Player player, Map<String, McMMOAbilityConfig> mcmmoConfig, boolean forMoney) {
        if (!this.enabled || mcmmoConfig == null || mcmmoConfig.isEmpty()) {
            return 1.0;
        }
        if (!this.isAnyAbilityActive(player)) {
            return 1.0;
        }
        double multiplier = 1.0;
        for (Map.Entry<String, McMMOAbilityConfig> entry : mcmmoConfig.entrySet()) {
            McMMOAbilityConfig config = entry.getValue();
            double d = forMoney ? config.getMoneyAmplifier() : config.getXpAmplifier();
            double currentMultiplier = d;
            if (!(currentMultiplier > multiplier)) continue;
            multiplier = currentMultiplier;
        }
        return multiplier;
    }

    public static class McMMOAbilityConfig {
        private final double moneyAmplifier;
        private final double xpAmplifier;

        public McMMOAbilityConfig(double moneyAmplifier, double xpAmplifier) {
            this.moneyAmplifier = moneyAmplifier;
            this.xpAmplifier = xpAmplifier;
        }

        public double getMoneyAmplifier() {
            return this.moneyAmplifier;
        }

        public double getXpAmplifier() {
            return this.xpAmplifier;
        }
    }
}

