/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.job;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.job.JobManager;
import fr.ax_dev.universejobs.job.PlayerJobData;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class InactivityDecayManager {
    private final UniverseJobs plugin;
    private final JobManager jobManager;
    private volatile boolean isProcessing = false;

    public InactivityDecayManager(UniverseJobs plugin, JobManager jobManager) {
        this.plugin = plugin;
        this.jobManager = jobManager;
    }

    public void processInactivePlayersAsync() {
        if (!this.plugin.getConfigManager().isInactivityDecayEnabled()) {
            return;
        }
        if (this.isProcessing) {
            this.plugin.getLogger().info("Inactivity decay process already running, skipping...");
            return;
        }
        this.isProcessing = true;
        CompletableFuture.runAsync(() -> {
            try {
                this.processInactivePlayers();
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.SEVERE, "Error processing inactive players", e);
            }
            finally {
                this.isProcessing = false;
            }
        });
    }

    private void processInactivePlayers() {
        long currentTime = System.currentTimeMillis();
        int daysBeforeInactive = this.plugin.getConfigManager().getDaysBeforeInactive();
        int daysBeforeRemoval = this.plugin.getConfigManager().getDaysBeforeRemoval();
        long inactiveThreshold = TimeUnit.DAYS.toMillis(daysBeforeInactive);
        long removalThreshold = daysBeforeRemoval > 0 ? TimeUnit.DAYS.toMillis(daysBeforeRemoval) : Long.MAX_VALUE;
        Map<UUID, PlayerJobData> allPlayerData = this.jobManager.getAllPlayerData();
        int processedCount = 0;
        int decayedCount = 0;
        int removedCount = 0;
        for (Map.Entry<UUID, PlayerJobData> entry : allPlayerData.entrySet()) {
            long inactiveDays;
            UUID playerUuid = entry.getKey();
            PlayerJobData data = entry.getValue();
            long lastLogin = data.getLastLogin();
            long timeSinceLogin = currentTime - lastLogin;
            if (timeSinceLogin >= removalThreshold && daysBeforeRemoval > 0) {
                this.jobManager.removePlayerData(playerUuid);
                ++removedCount;
                if (this.plugin.getConfigManager().isDebugEnabled()) {
                    this.plugin.getLogger().info("Removed player data for " + String.valueOf(playerUuid) + " (inactive for " + TimeUnit.MILLISECONDS.toDays(timeSinceLogin) + " days)");
                }
            } else if (timeSinceLogin >= inactiveThreshold && (inactiveDays = TimeUnit.MILLISECONDS.toDays(timeSinceLogin - inactiveThreshold)) > 0L) {
                this.applyDecay(data, (int)inactiveDays);
                ++decayedCount;
            }
            if (++processedCount % 100 != 0) continue;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.plugin.getLogger().warning("Inactivity decay process interrupted");
                return;
            }
        }
        if (decayedCount > 0 || removedCount > 0) {
            this.plugin.getLogger().info("Inactivity decay process completed: " + decayedCount + " players decayed, " + removedCount + " players removed");
        }
    }

    private void applyDecay(PlayerJobData data, int inactiveDays) {
        HashSet<String> jobs = new HashSet<String>(data.getJobs());
        block10: for (String jobId : jobs) {
            String decayType = this.plugin.getConfigManager().getInactivityDecayType(jobId);
            double decayAmount = this.plugin.getConfigManager().getInactivityDecayAmount(jobId);
            int minLevel = this.plugin.getConfigManager().getInactivityDecayMinLevel(jobId);
            if (decayAmount <= 0.0) continue;
            int currentLevel = data.getLevel(jobId);
            double currentXp = data.getXp(jobId);
            for (int day = 0; day < inactiveDays; ++day) {
                switch (decayType.toLowerCase()) {
                    case "percentage": {
                        double requiredXp;
                        double levelLoss;
                        int newLevel;
                        if (currentLevel <= minLevel || (newLevel = Math.max(minLevel, (int)Math.floor((double)currentLevel - (levelLoss = (double)currentLevel * decayAmount)))) == currentLevel) break;
                        currentLevel = newLevel;
                        data.setLevel(jobId, newLevel);
                        Job job = this.jobManager.getJob(jobId);
                        if (job == null || !(currentXp > (requiredXp = job.getXpForLevel(newLevel)))) break;
                        data.setXp(jobId, requiredXp);
                        currentXp = requiredXp;
                        break;
                    }
                    case "level": {
                        double requiredXp;
                        int levelsToLose = (int)decayAmount;
                        int newLevelFixed = Math.max(minLevel, currentLevel - levelsToLose);
                        if (newLevelFixed == currentLevel) break;
                        currentLevel = newLevelFixed;
                        data.setLevel(jobId, newLevelFixed);
                        Job job = this.jobManager.getJob(jobId);
                        if (job == null || !(currentXp > (requiredXp = job.getXpForLevel(newLevelFixed)))) break;
                        data.setXp(jobId, requiredXp);
                        currentXp = requiredXp;
                        break;
                    }
                    case "xp": {
                        int calculatedLevel;
                        double xpToLose = decayAmount;
                        double newXp = Math.max(0.0, currentXp - xpToLose);
                        if (newXp == currentXp) break;
                        data.setXp(jobId, newXp);
                        currentXp = newXp;
                        Job job = this.jobManager.getJob(jobId);
                        if (job == null || (calculatedLevel = job.getLevelFromXp(newXp)) >= currentLevel || calculatedLevel < minLevel) break;
                        data.setLevel(jobId, calculatedLevel);
                        currentLevel = calculatedLevel;
                    }
                }
                if (currentLevel <= minLevel) continue block10;
            }
        }
    }

    public void updatePlayerActivity(UUID playerUuid) {
        if (Bukkit.isPrimaryThread()) {
            CompletableFuture.runAsync(() -> this.updatePlayerActivityAsync(playerUuid));
        } else {
            this.updatePlayerActivityAsync(playerUuid);
        }
    }

    private void updatePlayerActivityAsync(UUID playerUuid) {
        PlayerJobData data = this.jobManager.getPlayerData(playerUuid);
        if (data != null) {
            data.setLastLogin(System.currentTimeMillis());
            this.jobManager.markDataDirty(playerUuid);
        }
    }
}

