/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.job;

import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.job.JobManager;
import fr.ax_dev.universejobs.levelup.SimpleLevelUpActionManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class PlayerJobData {
    private static final String LAST_MODIFIED_KEY = "lastModified";
    private final UUID playerUuid;
    private final Set<String> jobs = ConcurrentHashMap.newKeySet();
    private final Map<String, Double> xpData = new ConcurrentHashMap<String, Double>();
    private final Map<String, Integer> levelData = new ConcurrentHashMap<String, Integer>();
    private final ReadWriteLock dataLock = new ReentrantReadWriteLock();
    private final AtomicBoolean isLoading = new AtomicBoolean(false);
    private volatile long lastModified = System.currentTimeMillis();
    private volatile long lastLogin = System.currentTimeMillis();
    private volatile JobManager jobManager;

    public PlayerJobData(UUID playerUuid) {
        this.playerUuid = playerUuid;
    }

    public void setJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    public UUID getPlayerUuid() {
        return this.playerUuid;
    }

    public boolean joinJob(String jobId) {
        if (jobId == null || jobId.isEmpty()) {
            return false;
        }
        this.dataLock.writeLock().lock();
        try {
            if (this.jobs.add(jobId)) {
                this.xpData.putIfAbsent(jobId, 0.0);
                this.levelData.putIfAbsent(jobId, 1);
                this.lastModified = System.currentTimeMillis();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean leaveJob(String jobId) {
        if (jobId == null || jobId.isEmpty()) {
            return false;
        }
        this.dataLock.writeLock().lock();
        try {
            boolean removed = this.jobs.remove(jobId);
            if (removed) {
                this.lastModified = System.currentTimeMillis();
            }
            boolean bl = removed;
            return bl;
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    public boolean hasJob(String jobId) {
        return this.jobs.contains(jobId);
    }

    public Set<String> getJobs() {
        this.dataLock.readLock().lock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.jobs);
            return hashSet;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXp(String jobId, double xp) {
        if (jobId == null || !this.hasJob(jobId)) {
            return;
        }
        if (Double.isNaN(xp) || Double.isInfinite(xp)) {
            return;
        }
        this.dataLock.writeLock().lock();
        try {
            double currentXp = this.xpData.getOrDefault(jobId, 0.0);
            double newXp = currentXp + xp;
            if (newXp < 0.0) {
                newXp = 0.0;
            }
            if (newXp > 8.988465674311579E307) {
                newXp = 8.988465674311579E307;
            }
            this.xpData.put(jobId, newXp);
            this.lastModified = System.currentTimeMillis();
            if (xp > 0.0) {
                this.checkLevelUp(jobId, xp);
            }
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    public double getXp(String jobId) {
        return this.xpData.getOrDefault(jobId, 0.0);
    }

    public void setXp(String jobId, double xp) {
        this.xpData.put(jobId, xp);
        this.checkLevelUp(jobId, 0.0);
    }

    public int getLevel(String jobId) {
        return this.levelData.getOrDefault(jobId, 1);
    }

    public void setLevel(String jobId, int level) {
        this.levelData.put(jobId, Math.max(1, level));
    }

    public int getMaxLevel(String jobId) {
        return this.getEffectiveMaxLevel(jobId);
    }

    private double getTotalXpForLevel(String jobId, int level) {
        if (this.jobManager == null) {
            return PlayerJobData.fallbackTotalXpForLevel(level);
        }
        Job job = this.jobManager.getJob(jobId);
        if (job != null && job.getXpCurve() != null) {
            return job.getXpCurve().getXpForLevel(level);
        }
        return PlayerJobData.fallbackTotalXpForLevel(level);
    }

    private int getLevelFromXp(String jobId, double totalXp) {
        if (this.jobManager == null) {
            return PlayerJobData.fallbackLevelFromXp(totalXp);
        }
        Job job = this.jobManager.getJob(jobId);
        if (job != null && job.getXpCurve() != null) {
            return job.getXpCurve().getLevelForXp(totalXp, job.getMaxLevel());
        }
        return PlayerJobData.fallbackLevelFromXp(totalXp);
    }

    private static double fallbackRequiredXp(int level) {
        if (level <= 1) {
            return 0.0;
        }
        return 100.0 * Math.pow(1.5, (double)level - 2.0);
    }

    private static double fallbackTotalXpForLevel(int level) {
        double totalXp = 0.0;
        for (int i = 2; i <= level; ++i) {
            totalXp += PlayerJobData.fallbackRequiredXp(i);
        }
        return totalXp;
    }

    private static int fallbackLevelFromXp(double totalXp) {
        if (totalXp <= 0.0) {
            return 1;
        }
        int level = 1;
        for (double xpNeeded = 0.0; xpNeeded <= totalXp; xpNeeded += PlayerJobData.fallbackRequiredXp(++level)) {
        }
        return (int)((double)level - 1.0);
    }

    public double[] getXpProgress(String jobId) {
        double totalXp = this.getXp(jobId);
        int currentLevel = this.getLevel(jobId);
        double xpForCurrentLevel = this.getTotalXpForLevel(jobId, currentLevel);
        double xpForNextLevel = this.getTotalXpForLevel(jobId, currentLevel + 1);
        double currentXpInLevel = totalXp - xpForCurrentLevel;
        double xpNeededForNext = xpForNextLevel - xpForCurrentLevel;
        return new double[]{currentXpInLevel, xpNeededForNext};
    }

    private int getEffectiveMaxLevel(String jobId) {
        int defaultMaxLevel;
        if (this.jobManager == null) {
            return Integer.MAX_VALUE;
        }
        Player player = Bukkit.getPlayer((UUID)this.playerUuid);
        if (player == null || !player.isOnline()) {
            Job job = this.jobManager.getJob(jobId);
            return job != null ? job.getMaxLevel() : 100;
        }
        Job job = this.jobManager.getJob(jobId);
        int highestPermissionLevel = defaultMaxLevel = job != null ? job.getMaxLevel() : 100;
        for (int level = 10000; level >= defaultMaxLevel; --level) {
            String permission = "universejobs.job." + jobId + ".maxlevel." + level;
            if (!this.hasExplicitPermission(player, permission)) continue;
            highestPermissionLevel = level;
            break;
        }
        return highestPermissionLevel;
    }

    private boolean hasExplicitPermission(Player player, String permission) {
        if (!player.hasPermission(permission)) {
            return false;
        }
        if (!this.hasWildcardPermission(player)) {
            return true;
        }
        try {
            for (PermissionAttachmentInfo info : player.getEffectivePermissions()) {
                if (!permission.equals(info.getPermission()) || !info.getValue()) continue;
                return true;
            }
        }
        catch (Exception e) {
            return player.hasPermission(permission);
        }
        return false;
    }

    private boolean hasWildcardPermission(Player player) {
        return player.hasPermission("*") || player.hasPermission("universejobs.*") || player.hasPermission("universejobs.job.*") || player.hasPermission("universejobs.job.*.maxlevel.*");
    }

    private boolean checkLevelUp(String jobId, double xpGained) {
        int maxLevel;
        double totalXp = this.getXp(jobId);
        int currentLevel = this.getLevel(jobId);
        int calculatedLevel = this.getLevelFromXp(jobId, totalXp);
        if (calculatedLevel > (maxLevel = this.getEffectiveMaxLevel(jobId))) {
            calculatedLevel = maxLevel;
        }
        if (calculatedLevel > currentLevel) {
            block6: {
                this.setLevel(jobId, calculatedLevel);
                if (this.jobManager != null) {
                    try {
                        SimpleLevelUpActionManager actionManager;
                        Player player = Bukkit.getPlayer((UUID)this.playerUuid);
                        if (player != null && player.isOnline() && (actionManager = this.jobManager.getPlugin().getLevelUpActionManager()) != null) {
                            actionManager.executeLevelUpActions(player, jobId, currentLevel, calculatedLevel, totalXp, xpGained);
                        }
                    }
                    catch (Exception e) {
                        if (this.jobManager.getPlugin() == null) break block6;
                        this.jobManager.getPlugin().getLogger().warning("Failed to execute level up actions for player " + String.valueOf(this.playerUuid) + " in job " + jobId + ": " + e.getMessage());
                    }
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(FileConfiguration config) {
        this.dataLock.readLock().lock();
        try {
            config.set("uuid", (Object)this.playerUuid.toString());
            config.set(LAST_MODIFIED_KEY, (Object)this.lastModified);
            config.set("jobs", new ArrayList<String>(this.jobs));
            ConfigurationSection xpSection = config.createSection("xp");
            for (Map.Entry<String, Double> entry : this.xpData.entrySet()) {
                xpSection.set(entry.getKey(), (Object)entry.getValue());
            }
            ConfigurationSection levelSection = config.createSection("levels");
            for (Map.Entry<String, Integer> entry : this.levelData.entrySet()) {
                levelSection.set(entry.getKey(), (Object)entry.getValue());
            }
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(FileConfiguration config) {
        if (this.isLoading.compareAndSet(false, true)) {
            this.dataLock.writeLock().lock();
            try {
                ConfigurationSection levelSection;
                this.lastModified = config.getLong(LAST_MODIFIED_KEY, System.currentTimeMillis());
                List jobsList = config.getStringList("jobs");
                this.jobs.clear();
                this.jobs.addAll(jobsList);
                ConfigurationSection xpSection = config.getConfigurationSection("xp");
                if (xpSection != null) {
                    this.xpData.clear();
                    for (String jobId : xpSection.getKeys(false)) {
                        double xp = xpSection.getDouble(jobId);
                        if (Double.isNaN(xp) || Double.isInfinite(xp) || !(xp >= 0.0)) continue;
                        this.xpData.put(jobId, xp);
                    }
                }
                if ((levelSection = config.getConfigurationSection("levels")) != null) {
                    this.levelData.clear();
                    for (String jobId : levelSection.getKeys(false)) {
                        int level = levelSection.getInt(jobId);
                        if (level < 1 || level > 10000) continue;
                        this.levelData.put(jobId, level);
                    }
                }
                for (String jobId : this.jobs) {
                    this.xpData.putIfAbsent(jobId, 0.0);
                    this.levelData.putIfAbsent(jobId, 1);
                }
            }
            finally {
                this.dataLock.writeLock().unlock();
                this.isLoading.set(false);
            }
        }
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(long lastLogin) {
        this.lastLogin = lastLogin;
    }

    public boolean isLoading() {
        return this.isLoading.get();
    }

    public Map<String, Object> getDataSnapshot() {
        this.dataLock.readLock().lock();
        try {
            HashMap<String, Object> snapshot = new HashMap<String, Object>();
            snapshot.put("playerUuid", this.playerUuid.toString());
            snapshot.put("jobCount", this.jobs.size());
            snapshot.put("totalXp", this.xpData.values().stream().mapToDouble(Double::doubleValue).sum());
            snapshot.put(LAST_MODIFIED_KEY, new Date(this.lastModified));
            snapshot.put("isLoading", this.isLoading.get());
            HashMap<String, Object> hashMap = snapshot;
            return hashMap;
        }
        finally {
            this.dataLock.readLock().unlock();
        }
    }

    public String toString() {
        return "PlayerJobData{playerUuid=" + String.valueOf(this.playerUuid) + ", jobs=" + this.jobs.size() + ", lastModified=" + String.valueOf(new Date(this.lastModified)) + "}";
    }
}

