/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.placeholder;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.job.JobManager;
import fr.ax_dev.universejobs.job.PlayerJobData;
import fr.ax_dev.universejobs.storage.dao.LeaderboardDao;
import fr.ax_dev.universejobs.storage.database.DatabaseDataStorage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class JobsLeaderboardPlaceholder
extends PlaceholderExpansion {
    private final UniverseJobs plugin;
    private final JobManager jobManager;
    private final Map<String, List<LeaderboardEntry>> cachedLeaderboards = new ConcurrentHashMap<String, List<LeaderboardEntry>>();
    private final Map<String, Long> lastCacheUpdate = new ConcurrentHashMap<String, Long>();
    private static final long CACHE_DURATION = 30000L;

    public JobsLeaderboardPlaceholder(UniverseJobs plugin) {
        this.plugin = plugin;
        this.jobManager = plugin.getJobManager();
    }

    public String getIdentifier() {
        return "universejobs";
    }

    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, String params) {
        if (params == null) {
            return null;
        }
        String[] args = params.split("_");
        if (args.length < 2) {
            return null;
        }
        String jobId = args[0];
        String type = args[1];
        Job job = this.jobManager.getJob(jobId);
        if (job == null) {
            return "Invalid Job";
        }
        switch (type.toLowerCase()) {
            case "leaderboard": {
                return this.handleLeaderboardPlaceholder(jobId, args);
            }
            case "player": {
                return this.handlePlayerPlaceholder(player, jobId, args);
            }
            case "job": {
                return this.handleJobPlaceholder(job, args);
            }
        }
        return null;
    }

    private String handleLeaderboardPlaceholder(String jobId, String[] args) {
        if (args.length < 4) {
            return null;
        }
        try {
            int position = Integer.parseInt(args[2]);
            String info = args[3];
            List<LeaderboardEntry> leaderboard = this.getJobLeaderboard(jobId);
            if (position < 1 || position > leaderboard.size()) {
                return this.getEmptyLeaderboardValue(info);
            }
            LeaderboardEntry entry = leaderboard.get(position - 1);
            return this.formatLeaderboardInfo(entry, info, position);
        }
        catch (NumberFormatException e) {
            return "Invalid Position";
        }
    }

    private String handlePlayerPlaceholder(OfflinePlayer player, String jobId, String[] args) {
        if (player == null || args.length < 3) {
            return null;
        }
        String info = args[2];
        PlayerJobData playerData = this.jobManager.getPlayerData(player.getUniqueId());
        switch (info.toLowerCase()) {
            case "level": {
                return String.valueOf(playerData.getLevel(jobId));
            }
            case "xp": {
                return String.format("%.1f", playerData.getXp(jobId));
            }
            case "rank": {
                return String.valueOf(this.getPlayerRank(player.getUniqueId(), jobId));
            }
            case "progress": {
                double[] progress = playerData.getXpProgress(jobId);
                return String.format("%.1f/%.1f", progress[0], progress[1]);
            }
            case "progresspercent": {
                double[] progressPercent = playerData.getXpProgress(jobId);
                double percentage = progressPercent[0] / progressPercent[1] * 100.0;
                return String.format("%.1f%%", percentage);
            }
            case "hasjob": {
                return String.valueOf(playerData.hasJob(jobId));
            }
        }
        return null;
    }

    private String handleJobPlaceholder(Job job, String[] args) {
        if (args.length < 3) {
            return null;
        }
        String info = args[2];
        switch (info.toLowerCase()) {
            case "name": {
                return job.getName();
            }
            case "description": {
                return job.getDescription();
            }
            case "maxlevel": {
                return String.valueOf(job.getMaxLevel());
            }
            case "enabled": {
                return String.valueOf(job.isEnabled());
            }
            case "playercount": {
                return String.valueOf(this.getJobPlayerCount(job.getId()));
            }
        }
        return null;
    }

    private List<LeaderboardEntry> getJobLeaderboard(String jobId) {
        String cacheKey = jobId;
        Long lastUpdate = this.lastCacheUpdate.get(cacheKey);
        long currentTime = System.currentTimeMillis();
        if (lastUpdate != null && currentTime - lastUpdate < 30000L) {
            return this.cachedLeaderboards.getOrDefault(cacheKey, new ArrayList());
        }
        List<LeaderboardEntry> leaderboard = this.calculateJobLeaderboard(jobId);
        this.cachedLeaderboards.put(cacheKey, leaderboard);
        this.lastCacheUpdate.put(cacheKey, currentTime);
        return leaderboard;
    }

    private List<LeaderboardEntry> calculateJobLeaderboard(String jobId) {
        if (this.plugin.isDatabaseEnabled()) {
            try {
                LeaderboardDao leaderboardDao = ((DatabaseDataStorage)this.plugin.getDataStorage()).getLeaderboardDao();
                List<LeaderboardDao.LeaderboardEntry> dbEntries = leaderboardDao.getJobLeaderboard(jobId, 100).join();
                return dbEntries.stream().map(entry -> new LeaderboardEntry(entry.getPlayerId(), entry.getPlayerName(), entry.getXp(), entry.getLevel())).toList();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to fetch job leaderboard from database, falling back to file system");
            }
        }
        ArrayList<LeaderboardEntry> entries = new ArrayList<LeaderboardEntry>();
        File dataFolder = new File(this.plugin.getDataFolder(), "data");
        if (!dataFolder.exists()) {
            return entries;
        }
        File[] dataFiles = dataFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (dataFiles == null) {
            return entries;
        }
        for (File dataFile : dataFiles) {
            try {
                String uuidString = dataFile.getName().replace(".yml", "");
                UUID playerUuid = UUID.fromString(uuidString);
                PlayerJobData playerData = this.jobManager.getPlayerData(playerUuid);
                if (!playerData.hasJob(jobId)) continue;
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerUuid);
                String playerName = offlinePlayer.getName();
                if (playerName == null) {
                    playerName = "Unknown Player";
                }
                double xp = playerData.getXp(jobId);
                int level = playerData.getLevel(jobId);
                entries.add(new LeaderboardEntry(playerUuid, playerName, xp, level));
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Error processing data file: " + dataFile.getName());
            }
        }
        entries.sort((a, b) -> {
            int levelCompare = Integer.compare(b.level, a.level);
            if (levelCompare != 0) {
                return levelCompare;
            }
            return Double.compare(b.xp, a.xp);
        });
        return entries;
    }

    private String formatLeaderboardInfo(LeaderboardEntry entry, String info, int position) {
        switch (info.toLowerCase()) {
            case "player": 
            case "name": {
                return entry.playerName;
            }
            case "level": {
                return String.valueOf(entry.level);
            }
            case "xp": {
                return String.format("%.1f", entry.xp);
            }
            case "position": 
            case "rank": {
                return String.valueOf(position);
            }
            case "formatted": {
                return String.format("#%d %s - Level %d (%.1f XP)", position, entry.playerName, entry.level, entry.xp);
            }
        }
        return "Invalid Info";
    }

    private String getEmptyLeaderboardValue(String info) {
        switch (info.toLowerCase()) {
            case "player": 
            case "name": {
                return "No Player";
            }
            case "level": {
                return "0";
            }
            case "xp": {
                return "0.0";
            }
            case "position": 
            case "rank": {
                return "0";
            }
            case "formatted": {
                return "No player in ranking";
            }
        }
        return "N/A";
    }

    private int getPlayerRank(UUID playerUuid, String jobId) {
        List<LeaderboardEntry> leaderboard = this.getJobLeaderboard(jobId);
        for (int i = 0; i < leaderboard.size(); ++i) {
            if (!leaderboard.get((int)i).playerUuid.equals(playerUuid)) continue;
            return i + 1;
        }
        return 0;
    }

    private int getJobPlayerCount(String jobId) {
        File dataFolder = new File(this.plugin.getDataFolder(), "data");
        if (!dataFolder.exists()) {
            return 0;
        }
        File[] dataFiles = dataFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (dataFiles == null) {
            return 0;
        }
        int count = 0;
        for (File dataFile : dataFiles) {
            try {
                String uuidString = dataFile.getName().replace(".yml", "");
                UUID playerUuid = UUID.fromString(uuidString);
                PlayerJobData playerData = this.jobManager.getPlayerData(playerUuid);
                if (!playerData.hasJob(jobId)) continue;
                ++count;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return count;
    }

    public void clearCache() {
        this.cachedLeaderboards.clear();
        this.lastCacheUpdate.clear();
    }

    public void clearJobCache(String jobId) {
        this.cachedLeaderboards.remove(jobId);
        this.lastCacheUpdate.remove(jobId);
    }

    private static class LeaderboardEntry {
        final UUID playerUuid;
        final String playerName;
        final double xp;
        final int level;

        LeaderboardEntry(UUID playerUuid, String playerName, double xp, int level) {
            this.playerUuid = playerUuid;
            this.playerName = playerName;
            this.xp = xp;
            this.level = level;
        }
    }
}

