/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.storage.database;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.storage.database.DatabaseConfig;
import fr.ax_dev.universejobs.storage.database.DatabaseType;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class HikariConnectionPool {
    private final UniverseJobs plugin;
    private final DatabaseConfig config;
    private HikariDataSource dataSource;
    private boolean initialized = false;

    public HikariConnectionPool(UniverseJobs plugin, DatabaseConfig config) {
        this.plugin = plugin;
        this.config = config;
    }

    public void initialize() throws SQLException {
        if (this.initialized) {
            return;
        }
        HikariConfig hikariConfig = new HikariConfig();
        String jdbcUrl = this.config.buildJdbcUrl(this.plugin.getDataFolder().getAbsolutePath());
        hikariConfig.setJdbcUrl(jdbcUrl);
        if (this.config.getType() == DatabaseType.MYSQL) {
            hikariConfig.setUsername(this.config.getUsername());
            hikariConfig.setPassword(this.config.getPassword());
            hikariConfig.setDriverClassName("com.mysql.cj.jdbc.Driver");
        } else {
            hikariConfig.setDriverClassName("org.sqlite.JDBC");
        }
        hikariConfig.setMinimumIdle(this.config.getMinConnections());
        hikariConfig.setMaximumPoolSize(this.config.getMaxConnections());
        hikariConfig.setConnectionTimeout(this.config.getConnectionTimeoutMs());
        hikariConfig.setValidationTimeout(TimeUnit.SECONDS.toMillis(5L));
        hikariConfig.setLeakDetectionThreshold(TimeUnit.MINUTES.toMillis(1L));
        hikariConfig.addDataSourceProperty("cachePrepStmts", (Object)"true");
        hikariConfig.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
        hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
        if (this.config.getType() == DatabaseType.MYSQL) {
            hikariConfig.addDataSourceProperty("useServerPrepStmts", (Object)"true");
            hikariConfig.addDataSourceProperty("rewriteBatchedStatements", (Object)"true");
            hikariConfig.addDataSourceProperty("maintainTimeStats", (Object)"false");
        }
        try {
            this.dataSource = new HikariDataSource(hikariConfig);
            try (Connection connection = this.dataSource.getConnection();){
                this.plugin.getLogger().info("Database connection established successfully (" + this.config.getType().getName() + ")");
            }
            this.initialized = true;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to initialize database connection pool", e);
            throw e;
        }
    }

    public Connection getConnection() throws SQLException {
        if (!this.initialized) {
            throw new SQLException("Connection pool not initialized");
        }
        return this.dataSource.getConnection();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void shutdown() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
            this.plugin.getLogger().info("Database connection pool shut down");
        }
        this.initialized = false;
    }

    public HikariDataSource getDataSource() {
        return this.dataSource;
    }
}

