/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.storage.migration;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.job.PlayerJobData;
import fr.ax_dev.universejobs.storage.database.DatabaseDataStorage;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataMigrator {
    private final UniverseJobs plugin;
    private final DatabaseDataStorage databaseStorage;
    private final File dataFolder;
    private final File backupFolder;

    public DataMigrator(UniverseJobs plugin, DatabaseDataStorage databaseStorage) {
        this.plugin = plugin;
        this.databaseStorage = databaseStorage;
        this.dataFolder = new File(plugin.getDataFolder(), "data");
        this.backupFolder = new File(plugin.getDataFolder(), "migration-backup");
    }

    public CompletableFuture<MigrationResult> migrateAllData() {
        return CompletableFuture.supplyAsync(() -> {
            this.plugin.getLogger().info("Starting data migration from YML to database...");
            MigrationResult result = new MigrationResult();
            try {
                this.createBackup();
                result.playerDataMigrated = this.migratePlayerData();
                result.rewardDataMigrated = this.migrateRewardData();
                result.success = true;
                this.plugin.getLogger().info("Data migration completed successfully!");
                this.plugin.getLogger().info("Player data migrated: " + result.playerDataMigrated);
                this.plugin.getLogger().info("Reward data migrated: " + result.rewardDataMigrated);
            }
            catch (Exception e) {
                result.success = false;
                result.error = e.getMessage();
                this.plugin.getLogger().log(Level.SEVERE, "Data migration failed", e);
            }
            return result;
        });
    }

    private void createBackup() {
        if (!this.backupFolder.exists()) {
            this.backupFolder.mkdirs();
        }
        File backupDataFolder = new File(this.backupFolder, "data-" + System.currentTimeMillis());
        if (this.dataFolder.exists()) {
            this.copyDirectory(this.dataFolder, backupDataFolder);
            this.plugin.getLogger().info("Created backup at: " + backupDataFolder.getAbsolutePath());
        }
    }

    private int migratePlayerData() {
        AtomicInteger migratedCount = new AtomicInteger(0);
        if (!this.dataFolder.exists()) {
            return 0;
        }
        File[] playerFiles = this.dataFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (playerFiles == null || playerFiles.length == 0) {
            return 0;
        }
        this.plugin.getLogger().info("Migrating " + playerFiles.length + " player data files...");
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (File playerFile : playerFiles) {
            CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                try {
                    String fileName = playerFile.getName();
                    String uuidString = fileName.substring(0, fileName.length() - 4);
                    UUID playerId = UUID.fromString(uuidString);
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)playerFile);
                    PlayerJobData data = new PlayerJobData(playerId);
                    data.load((FileConfiguration)config);
                    this.databaseStorage.savePlayerDataAsync(playerId, data).join();
                    migratedCount.incrementAndGet();
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "Failed to migrate player file: " + playerFile.getName(), e);
                }
            });
            futures.add(future);
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        return migratedCount.get();
    }

    private int migrateRewardData() {
        AtomicInteger migratedCount = new AtomicInteger(0);
        try {
            File rewardDataFolder = new File(this.plugin.getDataFolder(), "reward-data");
            if (!rewardDataFolder.exists()) {
                return 0;
            }
            File[] rewardFiles = rewardDataFolder.listFiles((dir, name) -> name.endsWith(".yml"));
            if (rewardFiles == null) {
                return 0;
            }
            for (File rewardFile : rewardFiles) {
                try {
                    String uuidString = rewardFile.getName().replace(".yml", "");
                    UUID playerId = UUID.fromString(uuidString);
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)rewardFile);
                    for (String jobId : config.getKeys(false)) {
                        if (!config.isConfigurationSection(jobId)) continue;
                        for (String rewardId : config.getConfigurationSection(jobId).getKeys(false)) {
                            long claimTime = config.getLong(jobId + "." + rewardId, System.currentTimeMillis());
                            this.databaseStorage.claimReward(playerId, jobId, rewardId, claimTime);
                            migratedCount.incrementAndGet();
                        }
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to migrate reward file: " + rewardFile.getName());
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to migrate reward data", e);
        }
        return migratedCount.get();
    }

    private void copyDirectory(File source, File destination) {
        try {
            if (source.isDirectory()) {
                destination.mkdirs();
                File[] files = source.listFiles();
                if (files != null) {
                    for (File file : files) {
                        File destFile = new File(destination, file.getName());
                        this.copyDirectory(file, destFile);
                    }
                }
            } else {
                Files.copy(source.toPath(), destination.toPath(), new CopyOption[0]);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to copy file: " + source.getName(), e);
        }
    }

    public boolean shouldMigrate() {
        if (!this.databaseStorage.isHealthy()) {
            return false;
        }
        File migrationMarker = new File(this.plugin.getDataFolder(), ".migrated");
        if (migrationMarker.exists()) {
            return false;
        }
        return this.dataFolder.exists() && this.dataFolder.listFiles((dir, name) -> name.endsWith(".yml")) != null;
    }

    public void markMigrationComplete() {
        try {
            File migrationMarker = new File(this.plugin.getDataFolder(), ".migrated");
            migrationMarker.createNewFile();
            this.plugin.getLogger().info("Migration marked as complete");
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to create migration marker", e);
        }
    }

    public static class MigrationResult {
        public boolean success = false;
        public int playerDataMigrated = 0;
        public int rewardDataMigrated = 0;
        public String error = null;

        public boolean isSuccessful() {
            return this.success;
        }

        public int getTotalMigrated() {
            return this.playerDataMigrated + this.rewardDataMigrated;
        }
    }
}

