/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.utils;

import fr.ax_dev.universejobs.utils.LegacyToMiniMessageConverter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MessageUtils {
    private static final MiniMessage miniMessage = MiniMessage.miniMessage();
    private static final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.legacySection();
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{([^}]+)}");
    private static final Map<String, Component> COMPONENT_CACHE = new ConcurrentHashMap<String, Component>(256);
    private static final Map<String, String> COLORIZE_CACHE = new ConcurrentHashMap<String, String>(256);
    private static final Map<String, String> LEGACY_CONVERTED_CACHE = new ConcurrentHashMap<String, String>(256);
    private static final Map<String, Long> CACHE_TIMESTAMPS = new ConcurrentHashMap<String, Long>(256);
    private static final long CACHE_DURATION = 300000L;
    private static long lastCleanup = System.currentTimeMillis();
    private static final Map<String, String> COMMON_PATTERNS = new ConcurrentHashMap<String, String>();

    public static Component parseMessage(String message) {
        Component result;
        if (message == null || message.isEmpty()) {
            return Component.empty();
        }
        MessageUtils.cleanupOldCache();
        Component cached = COMPONENT_CACHE.get(message);
        if (cached != null) {
            return cached;
        }
        String processedMessage = LEGACY_CONVERTED_CACHE.get(message);
        if (processedMessage == null) {
            if (LegacyToMiniMessageConverter.containsLegacyCodes(message)) {
                processedMessage = MessageUtils.fastLegacyConvert(message);
                LEGACY_CONVERTED_CACHE.put(message, processedMessage);
                CACHE_TIMESTAMPS.put(message + ":legacy", System.currentTimeMillis());
            } else {
                processedMessage = message;
                LEGACY_CONVERTED_CACHE.put(message, processedMessage);
            }
        }
        try {
            result = miniMessage.deserialize((Object)processedMessage);
        }
        catch (Exception e) {
            result = Component.text((String)message);
        }
        COMPONENT_CACHE.put(message, result);
        CACHE_TIMESTAMPS.put(message, System.currentTimeMillis());
        return result;
    }

    public static Component parseMessage(String message, Map<String, String> placeholders) {
        if (message == null || message.isEmpty()) {
            return Component.empty();
        }
        String processedMessage = MessageUtils.replacePlaceholders(message, placeholders);
        return MessageUtils.parseMessage(processedMessage);
    }

    public static Component parseMessage(String message, String placeholder, String value) {
        return MessageUtils.parseMessage(message, Map.of(placeholder, value));
    }

    public static void sendMessage(Player player, String message) {
        if (player != null && message != null && !message.isEmpty()) {
            player.sendMessage(MessageUtils.parseMessage(message));
        }
    }

    public static void sendMessage(CommandSender sender, String message) {
        if (sender != null && message != null && !message.isEmpty()) {
            sender.sendMessage(MessageUtils.parseMessage(message));
        }
    }

    public static void sendMessage(Player player, String message, Map<String, String> placeholders) {
        if (player != null && message != null && !message.isEmpty()) {
            player.sendMessage(MessageUtils.parseMessage(message, placeholders));
        }
    }

    public static void sendMessage(Player player, String message, String placeholder, String value) {
        MessageUtils.sendMessage(player, message, Map.of(placeholder, value));
    }

    public static String translateLegacyColorCodes(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        String cached = LEGACY_CONVERTED_CACHE.get(message);
        if (cached != null) {
            return cached;
        }
        String result = MessageUtils.fastLegacyConvert(message);
        LEGACY_CONVERTED_CACHE.put(message, result);
        CACHE_TIMESTAMPS.put(message + ":legacy", System.currentTimeMillis());
        return result;
    }

    private static String fastLegacyConvert(String message) {
        for (Map.Entry<String, String> entry : COMMON_PATTERNS.entrySet()) {
            if (!message.contains(entry.getKey())) continue;
            message = message.replace(entry.getKey(), entry.getValue());
        }
        if (LegacyToMiniMessageConverter.containsLegacyCodes(message)) {
            return LegacyToMiniMessageConverter.convert(message);
        }
        return message;
    }

    private static void cleanupOldCache() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastCleanup > 300000L) {
            CACHE_TIMESTAMPS.entrySet().removeIf(entry -> {
                boolean expired;
                boolean bl = expired = currentTime - (Long)entry.getValue() > 300000L;
                if (expired) {
                    String key = (String)entry.getKey();
                    if (key.endsWith(":colorize")) {
                        COLORIZE_CACHE.remove(key.substring(0, key.length() - 9));
                    } else if (key.endsWith(":legacy")) {
                        LEGACY_CONVERTED_CACHE.remove(key.substring(0, key.length() - 7));
                    } else {
                        COMPONENT_CACHE.remove(key);
                    }
                }
                return expired;
            });
            lastCleanup = currentTime;
        }
    }

    private static String replacePlaceholders(String message, Map<String, String> placeholders) {
        if (placeholders == null || placeholders.isEmpty()) {
            return message;
        }
        StringBuffer result = new StringBuffer();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(message);
        while (matcher.find()) {
            String key = matcher.group(1);
            String replacement = placeholders.getOrDefault(key, "{" + key + "}");
            matcher.appendReplacement(result, Matcher.quoteReplacement(replacement));
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static String stripFormatting(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        Component component = MessageUtils.parseMessage(message);
        return PlainTextComponentSerializer.plainText().serialize(component);
    }

    public static void sendActionBar(Player player, String message) {
        if (player != null && message != null) {
            player.sendActionBar(MessageUtils.parseMessage(message));
        }
    }

    public static void sendActionBar(Player player, String message, Map<String, String> placeholders) {
        if (player != null && message != null) {
            player.sendActionBar(MessageUtils.parseMessage(message, placeholders));
        }
    }

    public static String colorize(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        MessageUtils.cleanupOldCache();
        String cached = COLORIZE_CACHE.get(message);
        if (cached != null) {
            return cached;
        }
        String processed = MessageUtils.translateLegacyColorCodes(message);
        Component component = MessageUtils.parseMessage(processed);
        String result = legacySerializer.serialize(component);
        COLORIZE_CACHE.put(message, result);
        CACHE_TIMESTAMPS.put(message + ":colorize", System.currentTimeMillis());
        return result;
    }

    static {
        COMMON_PATTERNS.put("&a+", "<green>+");
        COMMON_PATTERNS.put("&e$", "<yellow>$");
        COMMON_PATTERNS.put("&b[", "<aqua>[");
        COMMON_PATTERNS.put("&6{job}", "<gold>{job}");
        COMMON_PATTERNS.put("&7(", "<gray>(");
        COMMON_PATTERNS.put("&f)", "<white>)");
        COMMON_PATTERNS.put("&c-", "<red>-");
        COMMON_PATTERNS.put("&d{level}", "<light_purple>{level}");
    }
}

