/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.bonus;

import java.util.Objects;
import java.util.UUID;

public abstract class BaseBonus {
    protected final UUID playerId;
    protected final String jobId;
    protected final double multiplier;
    protected final long startTime;
    protected final long duration;
    protected final String reason;
    protected final String grantedBy;
    protected final String boostId;
    protected final boolean isGlobal;
    protected final String actionType;
    protected final String actionId;

    protected BaseBonus(UUID playerId, String jobId, double multiplier, long duration, String reason, String grantedBy, String boostId, boolean isGlobal, String actionType, String actionId) {
        this.playerId = playerId;
        this.jobId = jobId;
        this.multiplier = multiplier;
        this.startTime = System.currentTimeMillis();
        this.duration = duration * 1000L;
        this.reason = reason;
        this.grantedBy = grantedBy;
        this.boostId = boostId;
        this.isGlobal = isGlobal;
        this.actionType = actionType;
        this.actionId = actionId;
    }

    public boolean isActive() {
        return System.currentTimeMillis() < this.startTime + this.duration;
    }

    public boolean appliesTo(String jobId) {
        return this.jobId == null || this.jobId.equals(jobId);
    }

    public long getRemainingTime() {
        long remaining = this.startTime + this.duration - System.currentTimeMillis();
        return Math.max(0L, remaining / 1000L);
    }

    public String getRemainingTimeFormatted() {
        long remainingSeconds = this.getRemainingTime();
        if (remainingSeconds <= 0L) {
            return "Expired";
        }
        long hours = remainingSeconds / 3600L;
        long minutes = remainingSeconds % 3600L / 60L;
        long seconds = remainingSeconds % 60L;
        if (hours > 0L) {
            return String.format("%dh %dm %ds", hours, minutes, seconds);
        }
        if (minutes > 0L) {
            return String.format("%dm %ds", minutes, seconds);
        }
        return String.format("%ds", seconds);
    }

    public BonusType getType() {
        return this.jobId == null ? BonusType.GLOBAL : BonusType.SPECIFIC;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public int getBonusPercentage() {
        return (int)Math.round((this.multiplier - 1.0) * 100.0);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getReason() {
        return this.reason;
    }

    public String getGrantedBy() {
        return this.grantedBy;
    }

    public String getBoostId() {
        return this.boostId;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public String getActionType() {
        return this.actionType;
    }

    public String getActionId() {
        return this.actionId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BaseBonus baseBonus = (BaseBonus)obj;
        return Objects.equals(this.playerId, baseBonus.playerId) && Objects.equals(this.jobId, baseBonus.jobId) && this.startTime == baseBonus.startTime;
    }

    public int hashCode() {
        return Objects.hash(this.playerId, this.jobId, this.startTime);
    }

    protected abstract String getBonusTypeName();

    public String toString() {
        return this.getBonusTypeName() + "{boostId='" + this.boostId + "', playerId=" + String.valueOf(this.playerId) + ", jobId='" + this.jobId + "', multiplier=" + this.multiplier + ", remaining=" + this.getRemainingTimeFormatted() + ", reason='" + this.reason + "'}";
    }

    public static enum BonusType {
        GLOBAL,
        SPECIFIC;

    }
}

