/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.command.handler;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.command.handler.JobCommandHandler;
import fr.ax_dev.universejobs.job.Job;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class JoinLeaveCommandHandler
extends JobCommandHandler {
    public JoinLeaveCommandHandler(UniverseJobs plugin) {
        super(plugin);
    }

    @Override
    public boolean handleCommand(CommandSender sender, String[] args) {
        String subCommand;
        Player player = this.validatePlayerSender(sender);
        if (player == null) {
            return true;
        }
        if (args.length == 0) {
            return false;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "join": {
                this.handleJoinCommand(player, args);
                break;
            }
            case "leave": {
                this.handleLeaveCommand(player, args);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        Player player = this.getPlayerFromSender(sender);
        if (player == null || args.length == 0) {
            return completions;
        }
        String subCommand = args[0].toLowerCase();
        if (args.length == 2) {
            String input = args[1].toLowerCase();
            switch (subCommand) {
                case "join": {
                    for (Job job : this.jobManager.getEnabledJobs()) {
                        if (this.jobManager.hasJob(player, job.getId()) || !job.getId().toLowerCase().startsWith(input)) continue;
                        completions.add(job.getId());
                    }
                    break;
                }
                case "leave": {
                    for (String jobId : this.jobManager.getPlayerJobs(player)) {
                        if (!jobId.toLowerCase().startsWith(input)) continue;
                        completions.add(jobId);
                    }
                    break;
                }
            }
        }
        return completions;
    }

    private void handleJoinCommand(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(this.languageManager.getMessage("commands.join.usage"));
            return;
        }
        String jobId = this.sanitizeInput(args[1]);
        if (!this.isValidJobId(jobId)) {
            return;
        }
        Job job = this.jobManager.getJob(jobId);
        if (job == null) {
            player.sendMessage(this.languageManager.getMessage("commands.join.job-not-found", "job", jobId));
            return;
        }
        if (this.jobManager.hasJob(player, jobId)) {
            player.sendMessage(this.languageManager.getMessage("commands.join.already-have", "job", job.getName()));
            return;
        }
        Set<String> playerJobs = this.jobManager.getPlayerJobs(player);
        int maxJobs = this.getMaxJobsForPlayer(player);
        if (playerJobs.size() >= maxJobs) {
            player.sendMessage(this.languageManager.getMessage("commands.join.max-jobs-reached", "max", String.valueOf(maxJobs)));
            return;
        }
        if (!player.hasPermission(job.getPermission())) {
            player.sendMessage(this.languageManager.getMessage("commands.join.no-permission", "job", job.getName()));
            return;
        }
        if (this.jobManager.joinJob(player, jobId)) {
            player.sendMessage(this.languageManager.getMessage("commands.join.success", "job", job.getName()));
            this.plugin.getMenuManager().refreshPlayerMenu(player);
        } else {
            player.sendMessage(this.languageManager.getMessage("commands.join.failed", "job", job.getName()));
        }
    }

    private void handleLeaveCommand(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(this.languageManager.getMessage("commands.leave.usage"));
            return;
        }
        String jobId = this.sanitizeInput(args[1]);
        if (!this.isValidJobId(jobId)) {
            return;
        }
        Job job = this.jobManager.getJob(jobId);
        if (job == null) {
            player.sendMessage(this.languageManager.getMessage("commands.leave.job-not-found", "job", jobId));
            return;
        }
        if (!this.jobManager.hasJob(player, jobId)) {
            player.sendMessage(this.languageManager.getMessage("commands.leave.dont-have", "job", job.getName()));
            return;
        }
        if (this.plugin.getConfigManager().isDefaultJob(jobId)) {
            player.sendMessage(this.languageManager.getMessage("commands.leave.default-job", "job", job.getName()));
            return;
        }
        if (this.jobManager.leaveJob(player, jobId)) {
            player.sendMessage(this.languageManager.getMessage("commands.leave.success", "job", job.getName()));
            this.plugin.getMenuManager().refreshPlayerMenu(player);
        } else {
            player.sendMessage(this.languageManager.getMessage("commands.leave.failed", "job", job.getName()));
        }
    }

    private int getMaxJobsForPlayer(Player player) {
        int maxJobs = 1;
        for (PermissionAttachmentInfo permInfo : player.getEffectivePermissions()) {
            String permission = permInfo.getPermission();
            if (!permission.startsWith("universejobs.max_join.") || !permInfo.getValue()) continue;
            try {
                String numberPart = permission.substring("universejobs.max_join.".length());
                int permissionValue = Integer.parseInt(numberPart);
                if (permissionValue <= maxJobs) continue;
                maxJobs = permissionValue;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return maxJobs;
    }
}

