/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.listener;

import dev.lone.itemsadder.api.CustomBlock;
import dev.lone.itemsadder.api.Events.CustomBlockBreakEvent;
import dev.lone.itemsadder.api.Events.CustomBlockInteractEvent;
import dev.lone.itemsadder.api.Events.CustomBlockPlaceEvent;
import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionProcessor;
import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.condition.ConditionContext;
import fr.ax_dev.universejobs.protection.BlockProtectionManager;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;

public class ItemsAdderEventListener
implements Listener {
    private static final String TARGET_PREFIX = "target";
    private static final String ITEMSADDER_PREFIX = "itemsadder:";
    private static final String ITEMSADDER_BLOCK_ID = "itemsadder_block_id";
    private final UniverseJobs plugin;
    private final ActionProcessor actionProcessor;
    private final BlockProtectionManager protectionManager;

    public ItemsAdderEventListener(UniverseJobs plugin, ActionProcessor actionProcessor, BlockProtectionManager protectionManager) {
        this.plugin = plugin;
        this.actionProcessor = actionProcessor;
        this.protectionManager = protectionManager;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemsAdderBlockPlace(CustomBlockPlaceEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        String itemsAdderBlockId = event.getNamespacedID();
        this.protectionManager.recordBlockPlacement(player, block);
        ConditionContext context = new ConditionContext().setBlock(block).set(TARGET_PREFIX, ITEMSADDER_PREFIX + itemsAdderBlockId).set(ITEMSADDER_BLOCK_ID, itemsAdderBlockId);
        this.actionProcessor.processAction(player, ActionType.PLACE, (Event)event, context);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("ItemsAdder block placed: " + itemsAdderBlockId + " by " + player.getName() + " at " + String.valueOf(block.getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemsAdderBlockBreak(CustomBlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        CustomBlock customBlock = CustomBlock.byAlreadyPlaced((Block)block);
        if (customBlock == null) {
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().warning("CustomBlockBreakEvent fired but no custom block found at location: " + String.valueOf(block.getLocation()));
            }
            return;
        }
        String itemsAdderBlockId = customBlock.getNamespacedID();
        if (this.protectionManager.isPlayerPlacedBlock(block)) {
            this.protectionManager.removeTrackedBlock(block);
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Player " + player.getName() + " mined a player-placed ItemsAdder block (" + itemsAdderBlockId + ") - no XP awarded");
            }
            return;
        }
        ConditionContext context = new ConditionContext().setBlock(block).set(TARGET_PREFIX, ITEMSADDER_PREFIX + itemsAdderBlockId).set(ITEMSADDER_BLOCK_ID, itemsAdderBlockId);
        this.actionProcessor.processAction(player, ActionType.BREAK, (Event)event, context);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("ItemsAdder block broken: " + itemsAdderBlockId + " by " + player.getName() + " at " + String.valueOf(block.getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onItemsAdderBlockInteract(CustomBlockInteractEvent event) {
        String interactType;
        Player player = event.getPlayer();
        Block block = event.getBlockClicked();
        String itemsAdderBlockId = event.getNamespacedID();
        try {
            boolean isRightClick;
            Action action = event.getAction();
            boolean bl = isRightClick = action == Action.RIGHT_CLICK_BLOCK;
            interactType = player.isSneaking() ? (isRightClick ? "RIGHT_SHIFT_CLICK" : "LEFT_SHIFT_CLICK") : (isRightClick ? "RIGHT_CLICK" : "LEFT_CLICK");
        }
        catch (Exception e) {
            interactType = player.isSneaking() ? "RIGHT_SHIFT_CLICK" : "RIGHT_CLICK";
        }
        ConditionContext context = new ConditionContext().setBlock(block).set(TARGET_PREFIX, ITEMSADDER_PREFIX + itemsAdderBlockId).set(ITEMSADDER_BLOCK_ID, itemsAdderBlockId).set("interact-type", interactType);
        this.actionProcessor.processAction(player, ActionType.BLOCK_INTERACT, (Event)event, context);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("ItemsAdder block interact: " + itemsAdderBlockId + " by " + player.getName() + " - interact-type: " + interactType);
        }
    }
}

