/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.listener;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionProcessor;
import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.condition.ConditionContext;
import fr.ax_dev.universejobs.protection.BlockProtectionManager;
import java.lang.reflect.Method;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.NoteBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class OraxenEventListener
implements Listener {
    private static final String TARGET_PREFIX = "target";
    private static final String ORAXEN_PREFIX = "oraxen:";
    private static final String ORAXEN_ITEM_ID = "oraxen_item_id";
    private final UniverseJobs plugin;
    private final ActionProcessor actionProcessor;
    private final BlockProtectionManager protectionManager;

    public OraxenEventListener(UniverseJobs plugin, ActionProcessor actionProcessor, BlockProtectionManager protectionManager) {
        this.plugin = plugin;
        this.actionProcessor = actionProcessor;
        this.protectionManager = protectionManager;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onOraxenBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        ItemStack itemInHand = event.getItemInHand();
        String oraxenItemId = this.getOraxenItemId(itemInHand);
        if (oraxenItemId == null) {
            return;
        }
        this.protectionManager.recordBlockPlacement(player, block);
        ConditionContext context = new ConditionContext().setBlock(block).set(TARGET_PREFIX, ORAXEN_PREFIX + oraxenItemId).set(ORAXEN_ITEM_ID, oraxenItemId);
        this.actionProcessor.processAction(player, ActionType.PLACE, (Event)event, context);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("Oraxen block placed: " + oraxenItemId + " by " + player.getName() + " at " + String.valueOf(block.getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onOraxenBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        String oraxenItemId = this.getOraxenBlockId(block);
        if (oraxenItemId == null) {
            return;
        }
        if (this.protectionManager.isPlayerPlacedBlock(block)) {
            this.protectionManager.removeTrackedBlock(block);
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Player " + player.getName() + " mined a player-placed Oraxen block (" + oraxenItemId + ") - no XP awarded");
            }
            return;
        }
        ConditionContext context = new ConditionContext().setBlock(block).set(TARGET_PREFIX, ORAXEN_PREFIX + oraxenItemId).set(ORAXEN_ITEM_ID, oraxenItemId);
        this.actionProcessor.processAction(player, ActionType.BREAK, (Event)event, context);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("Oraxen block broken: " + oraxenItemId + " by " + player.getName() + " at " + String.valueOf(block.getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onOraxenBlockInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        Block block = event.getClickedBlock();
        String oraxenItemId = this.getOraxenBlockId(block);
        if (oraxenItemId == null) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        String interactType = player.isSneaking() ? "RIGHT_SHIFT_CLICK" : "RIGHT_CLICK";
        ConditionContext context = new ConditionContext().setBlock(block).set(TARGET_PREFIX, ORAXEN_PREFIX + oraxenItemId).set(ORAXEN_ITEM_ID, oraxenItemId).set("interact-type", interactType);
        this.actionProcessor.processAction(player, ActionType.BLOCK_INTERACT, (Event)event, context);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("Oraxen block interact: " + oraxenItemId + " by " + player.getName() + " - interact-type: " + interactType);
        }
    }

    private String getOraxenItemId(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType().isAir()) {
            return null;
        }
        try {
            if (!this.plugin.getServer().getPluginManager().isPluginEnabled("Oraxen")) {
                return null;
            }
            Class<?> oraxenItemsClass = Class.forName("io.th0rgal.oraxen.api.OraxenItems");
            Method getIdByItemMethod = oraxenItemsClass.getMethod("getIdByItem", ItemStack.class);
            Object result = getIdByItemMethod.invoke(null, itemStack);
            return (String)result;
        }
        catch (Exception e) {
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().warning("Error checking Oraxen item ID: " + e.getMessage());
            }
            return null;
        }
    }

    private String getOraxenBlockId(Block block) {
        block4: {
            if (block == null) {
                return null;
            }
            try {
                if (block.getType() == Material.NOTE_BLOCK) {
                    NoteBlock noteBlockData = (NoteBlock)block.getBlockData();
                    String instrument = noteBlockData.getInstrument().name();
                    byte note = noteBlockData.getNote().getId();
                    return "noteblock_" + instrument.toLowerCase() + "_" + note;
                }
            }
            catch (Exception e) {
                if (!this.plugin.getConfigManager().isDebugEnabled()) break block4;
                this.plugin.getLogger().warning("Error checking Oraxen block ID: " + e.getMessage());
            }
        }
        return null;
    }

    public boolean isOraxenBlock(Block block) {
        return this.getOraxenBlockId(block) != null;
    }
}

